/*
 * Decompiled with CFR 0.152.
 */
package au.org.ala.layers.intersect;

import au.org.ala.layers.dao.FieldDAO;
import au.org.ala.layers.dao.LayerDAO;
import au.org.ala.layers.dto.Field;
import au.org.ala.layers.dto.GridClass;
import au.org.ala.layers.dto.IntersectionFile;
import au.org.ala.layers.dto.Layer;
import au.org.ala.layers.intersect.Grid;
import au.org.ala.layers.intersect.SimpleShapeFileCache;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import net.sf.json.JSONArray;
import net.sf.json.JSONObject;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.methods.GetMethod;
import org.apache.commons.io.FileUtils;
import org.apache.log4j.Logger;
import org.codehaus.jackson.map.ObjectMapper;
import org.codehaus.jackson.type.TypeReference;

public class IntersectConfig {
    public static final String GEOSERVER_URL_PLACEHOLDER = "<COMMON_GEOSERVER_URL>";
    public static final String GEONETWORK_URL_PLACEHOLDER = "<COMMON_GEONETWORK_URL>";
    static final String ALASPATIAL_OUTPUT_PATH = "ALASPATIAL_OUTPUT_PATH";
    static final String LAYER_FILES_PATH = "LAYER_FILES_PATH";
    static final String ANALYSIS_LAYER_FILES_PATH = "ANALYSIS_LAYER_FILES_PATH";
    static final String ANALYSIS_TMP_LAYER_FILES_PATH = "ANALYSIS_TMP_LAYER_FILES_PATH";
    static final String LAYER_INDEX_URL = "LAYER_INDEX_URL";
    static final String BATCH_THREAD_COUNT = "BATCH_THREAD_COUNT";
    static final String CONFIG_RELOAD_WAIT = "CONFIG_RELOAD_WAIT";
    static final String PRELOADED_SHAPE_FILES = "PRELOADED_SHAPE_FILES";
    static final String GRID_BUFFER_SIZE = "GRID_BUFFER_SIZE";
    static final String GRID_CACHE_PATH = "GRID_CACHE_PATH";
    static final String GRID_CACHE_READER_COUNT = "GRID_CACHE_READER_COUNT";
    static final String LOCAL_SAMPLING = "LOCAL_SAMPLING";
    static final String GEOSERVER_URL = "GEOSERVER_URL";
    static final String GEONETWORK_URL = "GEONETWORK_URL";
    static final String GDAL_PATH = "GDAL_PATH";
    static final String ANALYSIS_RESOLUTIONS = "ANALYSIS_RESOLUTIONS";
    static final String OCCURRENCE_SPECIES_RECORDS_FILENAME = "OCCURRENCE_SPECIES_RECORDS_FILENAME";
    static final String UPLOADED_SHAPES_FIELD_ID = "UPLOADED_SHAPES_FIELD_ID";
    static final String API_KEY_CHECK_URL_TEMPLATE = "API_KEY_CHECK_URL_TEMPLATE";
    static final String SPATIAL_PORTAL_APP_NAME = "SPATIAL_PORTAL_APP_NAME";
    static final String BIOCACHE_SERVICE_URL = "BIOCACHE_SERVICE_URL";
    static final String GEOSERVER_USERNAME = "GEOSERVER_USERNAME";
    static final String GEOSERVER_PASSWORD = "GEOSERVER_PASSWORD";
    static final String SHP2PGSQL_PATH = "SHP2PGSQL_PATH";
    static final String GRIDS_TO_CACHE = "GRIDS_TO_CACHE";
    static final String CAN_UPDATE_LAYER_DISTANCES = "CAN_UPDATE_LAYER_DISTANCES";
    static final String CAN_UPDATE_GRID_CACHE = "CAN_UPDATE_GRID_CACHE";
    static final String CAN_GENERATE_ANALYSIS_FILES = "CAN_GENERATE_ANALYSIS_FILES";
    static final String CAN_INTERSECT_LAYERS = "CAN_INTERSECT_LAYERS";
    static final String CAN_GENRATE_THUMBNAILS = "CAN_GENRATE_THUMBNAILS";
    private static final Logger logger = Logger.getLogger(IntersectConfig.class);
    static ObjectMapper mapper = new ObjectMapper();
    static String layerFilesPath;
    static String analysisLayerFilesPath;
    static String analysisTmpLayerFilesPath;
    static String alaspatialOutputPath;
    static String layerIndexUrl;
    static int batchThreadCount;
    static long configReloadWait;
    static String preloadedShapeFiles;
    static int gridBufferSize;
    static String gridCachePath;
    static int gridCacheReaderCount;
    static boolean localSampling;
    static String geoserverUrl;
    static String geonetworkUrl;
    static String gdalPath;
    static List<Double> analysisResolutions;
    static String occurrenceSpeciesRecordsFilename;
    static String uploadedShapesFieldId;
    static String apiKeyCheckUrlTemplate;
    static String spatialPortalAppName;
    static String biocacheServiceUrl;
    static String geoserverUsername;
    static String geoserverPassword;
    static String shp2pgsqlPath;
    static boolean fieldStyles;
    private static boolean canUpdateLayerDistances;
    private static boolean canUpdateGridCache;
    private static boolean canGenerateAnalysisLayers;
    private static boolean canIntersectLayers;
    private static boolean canGenerateThumbnails;
    long lastReload;
    SimpleShapeFileCache shapeFileCache;
    HashMap<String, IntersectionFile> intersectionFiles;
    HashMap<String, HashMap<Integer, GridClass>> classGrids;
    private FieldDAO fieldDao;
    private LayerDAO layerDao;

    public IntersectConfig(FieldDAO fieldDao, LayerDAO layerDao) {
        this.fieldDao = fieldDao;
        this.layerDao = layerDao;
        this.load();
    }

    private static void isValidPath(String path, String desc) {
        File f = new File(path);
        if (!f.exists()) {
            logger.error((Object)("Config error. Property \"" + desc + "\" with value \"" + path + "\"  is not a valid local file path.  It does not exist."));
        } else if (!f.isDirectory()) {
            logger.error((Object)("Config error. Property \"" + desc + "\" with value \"" + path + "\"  is not a valid local file path.  It is not a directory."));
        } else if (!f.canRead()) {
            logger.error((Object)("Config error. Property \"" + desc + "\" with value \"" + path + "\"  is not a valid local file path.  Not permitted to READ."));
        } else if (!f.canWrite()) {
            logger.error((Object)("Config error. Property \"" + desc + "\" with value \"" + path + "\"  is not a valid local file path.  Not permitted to WRITE."));
        }
    }

    private static void isValidPathGDAL(String path, String desc) {
        File f = new File(path);
        if (!f.exists()) {
            logger.error((Object)("Config error. Property \"" + desc + "\" with value \"" + path + "\" is not a valid local file path.  It does not exist."));
        } else if (!f.isDirectory()) {
            logger.error((Object)("Config error. Property \"" + desc + "\" with value \"" + path + "\"  is not a valid local file path.  It is not a directory."));
        } else if (!f.canRead()) {
            logger.error((Object)("Config error. Property \"" + desc + "\" with value \"" + path + "\"  is not a valid local file path.  Not permitted to READ."));
        }
        File g = new File(path + File.separator + "gdalwarp");
        if (!f.exists()) {
            logger.error((Object)("Config error. Property \"" + desc + "\" with value \"" + path + "\"  is not a valid local file path.  gdalwarp does not exist."));
        } else if (!g.canExecute()) {
            logger.error((Object)("Config error. Property \"" + desc + "\" with value \"" + path + "\"  is not a valid local file path.  gdalwarp not permitted to EXECUTE."));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void isValidUrl(String url, String desc) {
        HttpClient client = new HttpClient();
        GetMethod get = null;
        try {
            get = new GetMethod(url);
            int result = client.executeMethod((HttpMethod)get);
            if (result != 200) {
                logger.error((Object)("Config error. Property \"" + desc + "\" with value \"" + url + "\"  is not a valid URL.  Error executing GET request, response=" + result));
            }
        }
        catch (Exception e) {
            logger.error((Object)("Config error. Property \"" + desc + "\" with value \"" + url + "\"  is not a valid URL.  Error executing GET request."));
        }
        finally {
            if (get != null) {
                get.releaseConnection();
            }
        }
    }

    public static void setPreloadedShapeFiles(String preloadedShapeFiles) {
        IntersectConfig.preloadedShapeFiles = preloadedShapeFiles;
    }

    static String getProperty(String property, Properties properties, String defaultValue) {
        String p = System.getProperty(property);
        if (p == null) {
            p = properties.getProperty(property);
        }
        if (p == null) {
            p = defaultValue;
        }
        logger.info((Object)(property + " > " + p));
        return p;
    }

    static long getPositiveLongProperty(String property, Properties properties, long defaultValue) {
        String p = IntersectConfig.getProperty(property, properties, null);
        long l = defaultValue;
        try {
            l = Long.parseLong(p);
            if (l < 0L) {
                l = defaultValue;
            }
        }
        catch (NumberFormatException ex) {
            logger.error((Object)("parsing " + property + ": " + p + ", using default: " + defaultValue), (Throwable)ex);
        }
        return l;
    }

    public static String getAlaspatialOutputPath() {
        return alaspatialOutputPath;
    }

    public static String getLayerFilesPath() {
        return layerFilesPath;
    }

    public static String getLayerIndexUrl() {
        return layerIndexUrl;
    }

    public static int getThreadCount() {
        return batchThreadCount;
    }

    public static int getGridBufferSize() {
        return gridBufferSize;
    }

    public static String getGridCachePath() {
        return gridCachePath;
    }

    public static int getGridCacheReaderCount() {
        return gridCacheReaderCount;
    }

    private static HashMap<Integer, GridClass> getGridClasses(String filePath, String type) throws IOException {
        HashMap classes = null;
        if (type.equals("Contextual")) {
            if (new File(filePath + ".gri").exists() && new File(filePath + ".grd").exists() && new File(filePath + ".txt").exists()) {
                File gridClassesFile = new File(filePath + ".classes.json");
                if (gridClassesFile.exists()) {
                    classes = (HashMap)mapper.readValue(gridClassesFile, (TypeReference)new TypeReference<Map<Integer, GridClass>>(){});
                    logger.info((Object)("found grid classes for " + gridClassesFile.getPath()));
                } else {
                    logger.error((Object)("classes unavailable for " + gridClassesFile.getPath() + ", build classes offline"));
                }
            } else if (new File(filePath + ".gri").exists() && new File(filePath + ".grd").exists()) {
                logger.error((Object)("missing grid classes for " + filePath));
            }
        }
        return classes;
    }

    public static long getConfigReloadWait() {
        return configReloadWait;
    }

    public static String getGeoserverUrl() {
        return geoserverUrl;
    }

    public static String getGeonetworkUrl() {
        return geonetworkUrl;
    }

    public static String getAnalysisLayerFilesPath() {
        return analysisLayerFilesPath;
    }

    public static String getGdalPath() {
        return gdalPath;
    }

    public static List<Double> getAnalysisResolutions() {
        return analysisResolutions;
    }

    private static List<Double> getDoublesFrom(String property) {
        ArrayList<Double> l = new ArrayList<Double>();
        if (property != null) {
            for (String s : property.split(",")) {
                try {
                    Double d = Double.parseDouble(s.trim());
                    if (d != null && !d.isNaN()) {
                        l.add(d);
                        continue;
                    }
                    logger.warn((Object)("Cannot parse '" + s + "' to Double"));
                }
                catch (Exception e) {
                    logger.warn((Object)("Cannot parse '" + s + "' to Double"), (Throwable)e);
                }
            }
        }
        Collections.sort(l);
        return l;
    }

    public static String getOccurrenceSpeciesRecordsFilename() {
        return occurrenceSpeciesRecordsFilename;
    }

    public static String getUploadedShapesFieldId() {
        return uploadedShapesFieldId;
    }

    public static String getApiKeyCheckUrlTemplate() {
        return apiKeyCheckUrlTemplate;
    }

    public static String getSpatialPortalAppName() {
        return spatialPortalAppName;
    }

    public static String getAnalysisTmpLayerFilesPath() {
        return analysisTmpLayerFilesPath;
    }

    public static int getMaxGridsLoaded() {
        return Grid.maxGridsLoaded;
    }

    public static void setMaxGridsLoaded(int maxGridsLoaded) {
        Grid.maxGridsLoaded = maxGridsLoaded;
    }

    public static void main(String[] args) {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < 100000; ++i) {
            if (i > 0) {
                sb.append(',');
            }
            sb.append(Math.random() * 32.0 - 44.0).append(',').append(Math.random() * 42.0 + 112.0);
        }
        try {
            FileUtils.writeStringToFile((File)new File("/data/p.txt"), (String)sb.toString());
        }
        catch (IOException e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
        }
    }

    public static boolean getCanUpdateLayerDistances() {
        return canUpdateLayerDistances;
    }

    public static boolean getCanUpdateGridCache() {
        return canUpdateGridCache;
    }

    public static boolean getCanGenerateAnalysisLayers() {
        return canGenerateAnalysisLayers;
    }

    public static boolean getCanIntersectLayers() {
        return canIntersectLayers;
    }

    public static boolean getCanGenerateThumbnails() {
        return canGenerateThumbnails;
    }

    public static boolean hasFieldStyles() {
        return fieldStyles;
    }

    public String getBiocacheServiceUrl() {
        return biocacheServiceUrl;
    }

    public void load() {
        this.lastReload = System.currentTimeMillis();
        try {
            this.updateIntersectionFiles();
            this.updateShapeFileCache();
            logger.info((Object)("**** grids to cache ***** = " + Grid.maxGridsLoaded));
            if (Grid.maxGridsLoaded <= 0) {
                this.seedGridFileCache();
            }
        }
        catch (Exception e) {
            logger.error((Object)"load failed, retry in 30s", (Throwable)e);
            configReloadWait = 30000L;
        }
    }

    private void seedGridFileCache() {
        int count = 0;
        for (String s : this.intersectionFiles.keySet()) {
            if (!s.startsWith("el") || !this.intersectionFiles.get(s).getType().equalsIgnoreCase("environmental")) continue;
            try {
                Grid g = Grid.getGrid(this.intersectionFiles.get(s).getFilePath());
                g.getGrid();
            }
            catch (Exception e) {
                logger.info((Object)("error caching grid: " + s));
            }
            if (++count % 5 != 0) continue;
            logger.info((Object)("cached " + count + " grids"));
        }
    }

    public IntersectionFile getIntersectionFile(String fieldId) {
        return this.intersectionFiles.get(fieldId);
    }

    public String getFieldIdFromFile(String file) {
        String on;
        String off;
        if (File.separator.equals("/")) {
            off = "\\";
            on = "/";
        } else {
            on = "\\";
            off = "/";
        }
        file = file.replace(off, on);
        for (Map.Entry<String, IntersectionFile> entry : this.intersectionFiles.entrySet()) {
            if (!entry.getValue().getFilePath().replace(off, on).equalsIgnoreCase(file)) continue;
            return entry.getKey();
        }
        return file;
    }

    private void updateIntersectionFiles() throws MalformedURLException, IOException {
        if (this.intersectionFiles == null) {
            this.intersectionFiles = new HashMap();
            this.classGrids = new HashMap();
        }
        if (layerIndexUrl != null) {
            JSONArray layers = JSONArray.fromObject((Object)this.getUrl(layerIndexUrl + "/layers"));
            HashMap<String, String> layerPathOrig = new HashMap<String, String>();
            HashMap<String, String> layerName = new HashMap<String, String>();
            HashMap<String, String> layerType = new HashMap<String, String>();
            HashMap<String, String> layerPid = new HashMap<String, String>();
            for (int i = 0; i < layers.size(); ++i) {
                layerPathOrig.put(layers.getJSONObject(i).getString("id"), layers.getJSONObject(i).getString("path_orig"));
                layerName.put(layers.getJSONObject(i).getString("id"), layers.getJSONObject(i).getString("name"));
                layerType.put(layers.getJSONObject(i).getString("id"), layers.getJSONObject(i).getString("type"));
                layerPid.put(layers.getJSONObject(i).getString("id"), layers.getJSONObject(i).getString("id"));
            }
            JSONArray fields = JSONArray.fromObject((Object)this.getUrl(layerIndexUrl + "/fields"));
            for (int i = 0; i < fields.size(); ++i) {
                JSONObject jo = fields.getJSONObject(i);
                String spid = jo.getString("spid");
                if (layerPathOrig.get(spid) == null) {
                    logger.error((Object)("cannot find layer with id '" + spid + "'"));
                    continue;
                }
                HashMap<Integer, GridClass> gridClasses = IntersectConfig.getGridClasses(layerFilesPath + (String)layerPathOrig.get(spid), (String)layerType.get(spid));
                IntersectionFile intersectionFile = new IntersectionFile(jo.getString("name"), layerFilesPath + (String)layerPathOrig.get(spid), jo.containsKey((Object)"sname") ? jo.getString("sname") : null, (String)layerName.get(jo.getString("spid")), jo.getString("id"), jo.getString("name"), (String)layerPid.get(spid), jo.getString("type"), gridClasses);
                this.intersectionFiles.put(jo.getString("id"), intersectionFile);
                this.intersectionFiles.put((String)layerName.get(spid), intersectionFile);
                this.intersectionFiles.put((String)layerPid.get(spid), intersectionFile);
                this.classGrids.put(jo.getString("id"), gridClasses);
            }
        } else {
            for (Field f : this.fieldDao.getFields()) {
                if (!f.isEnabled().booleanValue()) continue;
                Layer layer = this.layerDao.getLayerById(Integer.parseInt(f.getSpid()), false);
                if (layer == null) {
                    logger.error((Object)("cannot find layer with id '" + f.getSpid() + "'"));
                    continue;
                }
                HashMap<Integer, GridClass> gridClasses = IntersectConfig.getGridClasses(IntersectConfig.getLayerFilesPath() + layer.getPath_orig(), layer.getType());
                IntersectionFile intersectionFile = new IntersectionFile(f.getName(), IntersectConfig.getLayerFilesPath() + layer.getPath_orig(), f.getSname(), layer.getName(), f.getId(), f.getName(), String.valueOf(layer.getId()), f.getType(), gridClasses);
                this.intersectionFiles.put(f.getId(), intersectionFile);
                if (f.isDefaultlayer().booleanValue() || this.intersectionFiles.get(layer.getName()) == null) {
                    this.intersectionFiles.put(layer.getName(), intersectionFile);
                }
                if (f.isDefaultlayer().booleanValue() || this.intersectionFiles.get(String.valueOf(layer.getId())) == null) {
                    this.intersectionFiles.put(String.valueOf(layer.getId()), intersectionFile);
                }
                this.classGrids.put(f.getId(), gridClasses);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    String getUrl(String url) {
        HttpClient client = new HttpClient();
        GetMethod get = null;
        try {
            String slist;
            logger.info((Object)("opening url: " + url));
            get = new GetMethod(url);
            int result = client.executeMethod((HttpMethod)get);
            String string = slist = get.getResponseBodyAsString();
            return string;
        }
        catch (Exception e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
        }
        finally {
            if (get != null) {
                get.releaseConnection();
            }
        }
        return "";
    }

    public void updateShapeFileCache() {
        if (preloadedShapeFiles == null || preloadedShapeFiles.length() == 0) {
            return;
        }
        String[] fields = preloadedShapeFiles.split(",");
        HashSet<String> shapefiles = new HashSet<String>();
        HashSet<Object> fieldSet = new HashSet<Object>();
        if (fields[0].equalsIgnoreCase("all")) {
            for (String s : this.intersectionFiles.keySet()) {
                if (!s.startsWith("cl") || !this.intersectionFiles.get(s).getType().equalsIgnoreCase("c")) continue;
                fieldSet.add(s);
                shapefiles.add(this.intersectionFiles.get(s).getFilePath());
            }
        } else {
            for (String string : fields) {
                fieldSet.add(string);
                shapefiles.add(this.intersectionFiles.get(string).getFilePath());
            }
            for (String s : this.intersectionFiles.keySet()) {
                if (!s.startsWith("cl") || !this.intersectionFiles.get(s).getType().equalsIgnoreCase("c") || !shapefiles.contains(this.intersectionFiles.get(s).getFilePath()) || fieldSet.contains(s)) continue;
                fieldSet.add(s);
            }
        }
        String[] layers = new String[shapefiles.size()];
        String[] columns = new String[shapefiles.size()];
        String[] fid = new String[shapefiles.size()];
        int i = 0;
        HashMap<String, Integer> addedShapefiles = new HashMap<String, Integer>();
        for (String string : fieldSet) {
            String path = this.intersectionFiles.get(string).getFilePath();
            IntersectionFile f = this.intersectionFiles.get(string);
            if (addedShapefiles.containsKey(path)) {
                Integer pos = (Integer)addedShapefiles.get(path);
                int n = pos;
                columns[n] = columns[n] + "," + f.getShapeFields();
                int n2 = pos;
                fid[n2] = fid[n2] + "," + f.getFieldId();
                continue;
            }
            layers[i] = f.getFilePath();
            columns[i] = f.getShapeFields();
            fid[i] = f.getFieldId();
            addedShapefiles.put(path, i);
            ++i;
        }
        if (this.shapeFileCache == null) {
            this.shapeFileCache = new SimpleShapeFileCache(layers, columns, fid);
        } else {
            this.shapeFileCache.update(layers, columns, fid);
        }
    }

    public void addToShapeFileCache(String fieldIds) {
        if (preloadedShapeFiles != null) {
            fieldIds = fieldIds + "," + preloadedShapeFiles;
        }
        String[] fields = fieldIds.split(",");
        String[] layers = new String[fields.length];
        String[] columns = new String[fields.length];
        String[] fid = new String[fields.length];
        int pos = 0;
        for (int i = 0; i < fields.length; ++i) {
            try {
                layers[pos] = this.getIntersectionFile(fields[i].trim()).getFilePath();
                columns[pos] = this.getIntersectionFile(fields[i].trim()).getShapeFields();
                fid[pos] = fields[i];
                ++pos;
                continue;
            }
            catch (Exception e) {
                logger.error((Object)("problem adding shape file to cache for field: " + fields[i]), (Throwable)e);
            }
        }
        if (pos < layers.length) {
            layers = Arrays.copyOf(layers, pos);
            columns = Arrays.copyOf(columns, pos);
            fid = Arrays.copyOf(fid, pos);
        }
        if (this.shapeFileCache == null) {
            this.shapeFileCache = new SimpleShapeFileCache(layers, columns, fid);
        } else {
            this.shapeFileCache.update(layers, columns, fid);
        }
    }

    public SimpleShapeFileCache getShapeFileCache() {
        return this.shapeFileCache;
    }

    public boolean requiresReload() {
        return this.lastReload + configReloadWait >= System.currentTimeMillis();
    }

    public boolean isLocalSampling() {
        return localSampling;
    }

    public List<Field> getFieldsByDB() {
        List<Field> fields = new ArrayList<Field>();
        if (layerIndexUrl != null) {
            try {
                fields = (List)mapper.readValue(this.getUrl(layerIndexUrl + "/fieldsdb"), (TypeReference)new TypeReference<List<Field>>(){});
            }
            catch (Exception ex) {
                logger.error((Object)("failed to read: " + layerIndexUrl + "/fieldsdb"), (Throwable)ex);
            }
        }
        return fields;
    }

    public Map<String, IntersectionFile> getIntersectionFiles() {
        return this.intersectionFiles;
    }

    public String[] getAnalysisLayerInfo(String id) {
        String name = null;
        String filename = null;
        String gid = null;
        if (id.startsWith("species_")) {
            gid = id.substring("species_".length());
            filename = IntersectConfig.getAlaspatialOutputPath() + File.separator + "maxent" + File.separator + gid + File.separator + gid;
            name = "Prediction";
        } else if (id.startsWith("aloc_")) {
            gid = id.substring("aloc_".length());
            filename = IntersectConfig.getAlaspatialOutputPath() + File.separator + "aloc" + File.separator + gid + File.separator + "aloc";
            name = "Classification";
        } else if (id.startsWith("odensity_")) {
            gid = id.substring("odensity_".length());
            filename = IntersectConfig.getAlaspatialOutputPath() + File.separator + "sitesbyspecies" + File.separator + gid + File.separator + "occurrence_density";
            name = "Occurrence Density";
        } else if (id.startsWith("srichness_")) {
            gid = id.substring("srichness_".length());
            filename = IntersectConfig.getAlaspatialOutputPath() + File.separator + "sitesbyspecies" + File.separator + gid + File.separator + "species_richness";
            name = "Species Richness";
        } else if (id.endsWith("_odensity") && id.indexOf("_") == id.length() - 9) {
            gid = id.substring(0, id.length() - "_odensity".length());
            filename = IntersectConfig.getAlaspatialOutputPath() + File.separator + "sitesbyspecies" + File.separator + gid + File.separator + "occurrence_density";
            name = "Occurrence Density";
        } else if (id.endsWith("_srichness") && id.indexOf("_") == id.length() - 10) {
            gid = id.substring(0, id.length() - "_srichness".length());
            filename = IntersectConfig.getAlaspatialOutputPath() + File.separator + "sitesbyspecies" + File.separator + gid + File.separator + "species_richness";
            name = "Species Richness";
        } else if (id.startsWith("envelope_")) {
            gid = id.substring("envelope_".length());
            filename = IntersectConfig.getAlaspatialOutputPath() + File.separator + "envelope" + File.separator + gid + File.separator + "envelope";
            name = "Environmental Envelope";
        } else if (id.startsWith("gdm_")) {
            int pos1 = id.indexOf("_");
            int pos2 = id.lastIndexOf("_");
            String[] gdmparts = new String[]{id.substring(0, pos1), id.substring(pos1 + 1, pos2), id.substring(pos2 + 1)};
            gid = gdmparts[2];
            filename = IntersectConfig.getAlaspatialOutputPath() + File.separator + "gdm" + File.separator + gid + File.separator + gdmparts[1];
            IntersectionFile f = this.getIntersectionFile(gdmparts[1].replaceAll("Tran", ""));
            name = "Transformed " + (f != null ? f.getFieldName() : gdmparts[1].replaceAll("Tran", ""));
        } else if (id.contains("_")) {
            int pos = id.indexOf("_");
            String[] gdmparts = new String[]{id.substring(0, pos), id.substring(pos + 1)};
            gid = gdmparts[0];
            filename = IntersectConfig.getAlaspatialOutputPath() + File.separator + "gdm" + File.separator + gid + File.separator + gdmparts[1] + "Tran";
            logger.error((Object)("id: " + id));
            logger.error((Object)("parts: " + gdmparts[0] + ", " + gdmparts[1]));
            logger.info((Object)("parts: " + gdmparts[0] + ", " + gdmparts[1]));
            logger.error((Object)("filename: " + filename));
            IntersectionFile f = this.getIntersectionFile(gdmparts[1]);
            name = "Transformed " + (f != null ? f.getFieldName() : gdmparts[1]);
        }
        if (gid != null) {
            return new String[]{gid, filename, name};
        }
        return null;
    }

    public String getGeoserverUsername() {
        return geoserverUsername;
    }

    public String getGeoserverPassword() {
        return geoserverPassword;
    }

    public String getShp2pgsqlPath() {
        return shp2pgsqlPath;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static {
        Properties properties = new Properties();
        InputStream is = null;
        try {
            String pth = "/data/layers-store/config/layers-store-config.properties";
            logger.debug((Object)("config path: " + pth));
            is = new FileInputStream(pth);
            if (is != null) {
                properties.load(is);
            } else {
                String msg = "cannot get properties file: " + pth;
                logger.warn((Object)msg);
            }
        }
        catch (IOException ex) {
            logger.error(null, (Throwable)ex);
        }
        finally {
            if (is != null) {
                try {
                    is.close();
                }
                catch (IOException e) {
                    logger.error((Object)"failed to close layers-store-config.properties", (Throwable)e);
                }
            }
        }
        layerFilesPath = IntersectConfig.getProperty(LAYER_FILES_PATH, properties, null);
        IntersectConfig.isValidPath(layerFilesPath, LAYER_FILES_PATH);
        analysisLayerFilesPath = IntersectConfig.getProperty(ANALYSIS_LAYER_FILES_PATH, properties, null);
        IntersectConfig.isValidPath(analysisLayerFilesPath, ANALYSIS_LAYER_FILES_PATH);
        analysisTmpLayerFilesPath = IntersectConfig.getProperty(ANALYSIS_TMP_LAYER_FILES_PATH, properties, null);
        IntersectConfig.isValidPath(analysisTmpLayerFilesPath, ANALYSIS_TMP_LAYER_FILES_PATH);
        alaspatialOutputPath = IntersectConfig.getProperty(ALASPATIAL_OUTPUT_PATH, properties, null);
        IntersectConfig.isValidPath(alaspatialOutputPath, ALASPATIAL_OUTPUT_PATH);
        layerIndexUrl = IntersectConfig.getProperty(LAYER_INDEX_URL, properties, null);
        IntersectConfig.isValidUrl(layerIndexUrl, LAYER_INDEX_URL);
        batchThreadCount = (int)IntersectConfig.getPositiveLongProperty(BATCH_THREAD_COUNT, properties, 1L);
        configReloadWait = IntersectConfig.getPositiveLongProperty(CONFIG_RELOAD_WAIT, properties, 3600000L);
        preloadedShapeFiles = IntersectConfig.getProperty(PRELOADED_SHAPE_FILES, properties, null);
        gridBufferSize = (int)IntersectConfig.getPositiveLongProperty(GRID_BUFFER_SIZE, properties, 4096L);
        gridCachePath = IntersectConfig.getProperty(GRID_CACHE_PATH, properties, null);
        gridCacheReaderCount = (int)IntersectConfig.getPositiveLongProperty(GRID_CACHE_READER_COUNT, properties, 10L);
        localSampling = IntersectConfig.getProperty(LOCAL_SAMPLING, properties, "true").toLowerCase().equals("true");
        geoserverUrl = IntersectConfig.getProperty(GEOSERVER_URL, properties, null);
        geoserverUsername = IntersectConfig.getProperty(GEOSERVER_USERNAME, properties, null);
        geoserverPassword = IntersectConfig.getProperty(GEOSERVER_PASSWORD, properties, null);
        geonetworkUrl = IntersectConfig.getProperty(GEONETWORK_URL, properties, null);
        gdalPath = IntersectConfig.getProperty(GDAL_PATH, properties, null);
        IntersectConfig.isValidPathGDAL(gdalPath, GDAL_PATH);
        analysisResolutions = IntersectConfig.getDoublesFrom(IntersectConfig.getProperty(ANALYSIS_RESOLUTIONS, properties, "0.5"));
        occurrenceSpeciesRecordsFilename = IntersectConfig.getProperty(OCCURRENCE_SPECIES_RECORDS_FILENAME, properties, null);
        uploadedShapesFieldId = IntersectConfig.getProperty(UPLOADED_SHAPES_FIELD_ID, properties, null);
        apiKeyCheckUrlTemplate = IntersectConfig.getProperty(API_KEY_CHECK_URL_TEMPLATE, properties, null);
        spatialPortalAppName = IntersectConfig.getProperty(SPATIAL_PORTAL_APP_NAME, properties, null);
        biocacheServiceUrl = IntersectConfig.getProperty(BIOCACHE_SERVICE_URL, properties, null);
        canGenerateAnalysisLayers = IntersectConfig.getProperty(CAN_GENERATE_ANALYSIS_FILES, properties, "false").equalsIgnoreCase("true");
        canGenerateThumbnails = IntersectConfig.getProperty(CAN_GENRATE_THUMBNAILS, properties, "false").equalsIgnoreCase("true");
        canIntersectLayers = IntersectConfig.getProperty(CAN_INTERSECT_LAYERS, properties, "false").equalsIgnoreCase("true");
        canUpdateGridCache = IntersectConfig.getProperty(CAN_UPDATE_GRID_CACHE, properties, "false").equalsIgnoreCase("true");
        canUpdateLayerDistances = IntersectConfig.getProperty(CAN_UPDATE_LAYER_DISTANCES, properties, "false").equalsIgnoreCase("true");
        String gridsToCache = IntersectConfig.getProperty(GRIDS_TO_CACHE, properties, "1");
        if ("all".equals(gridsToCache)) {
            Grid.maxGridsLoaded = -1;
        } else {
            try {
                Grid.maxGridsLoaded = Integer.parseInt(gridsToCache);
            }
            catch (Exception e) {
                logger.error((Object)("failed to parse 'GRIDS_TO_CACHE' property as Integer: " + gridsToCache), (Throwable)e);
            }
        }
        shp2pgsqlPath = IntersectConfig.getProperty(SHP2PGSQL_PATH, properties, null);
    }
}

