/*
 * Decompiled with CFR 0.152.
 */
package au.org.ala.layers.grid;

import au.org.ala.layers.intersect.IniReader;
import java.io.BufferedReader;
import java.io.FileReader;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.ArrayList;
import java.util.HashMap;
import org.apache.log4j.Logger;

public class GridGroup {
    private static final Logger logger = Logger.getLogger(GridGroup.class);
    public Boolean byteorderLSB;
    public int ncols;
    public int nrows;
    public double nodatavalue;
    public Boolean valid;
    public double[] values;
    public double xmin;
    public double xmax;
    public double ymin;
    public double ymax;
    public double xres;
    public double yres;
    public String datatype;
    public String filename;
    ArrayList<String> names;
    ArrayList<String> files;
    float[] cell;
    float[] emptyCell;
    RandomAccessFile raf;
    int cellSize;
    byte[] buffer;
    Long bufferOffset;
    byte[] b;
    int size;
    byte nbytes;

    public GridGroup(String fname) throws IOException {
        this.filename = fname;
        this.readgrd(this.filename.substring(0, this.filename.length() - 4) + ".grd");
        this.raf = new RandomAccessFile(this.filename.substring(0, this.filename.length() - 4) + ".gri", "r");
        this.readHeader(fname);
        this.buffer = new byte[256 * this.cellSize];
        this.bufferOffset = this.raf.length();
        this.size = 4;
        this.b = new byte[4 * this.cellSize];
    }

    public int getcellnumber(double x, double y) {
        if (x < this.xmin || x > this.xmax || y < this.ymin || y > this.ymax) {
            return -1;
        }
        int col = (int)((x - this.xmin) / this.xres);
        int row = this.nrows - 1 - (int)((y - this.ymin) / this.yres);
        if (col < 0) {
            col = 0;
        }
        if (row < 0) {
            row = 0;
        }
        if (col >= this.ncols) {
            col = this.ncols - 1;
        }
        if (row >= this.nrows) {
            row = this.nrows - 1;
        }
        return row * this.ncols + col;
    }

    private void readgrd(String filename) {
        IniReader ir = new IniReader(filename);
        this.datatype = "FLOAT";
        this.ncols = ir.getIntegerValue("GeoReference", "Columns");
        this.nrows = ir.getIntegerValue("GeoReference", "Rows");
        this.xmin = ir.getDoubleValue("GeoReference", "MinX");
        this.ymin = ir.getDoubleValue("GeoReference", "MinY");
        this.xmax = ir.getDoubleValue("GeoReference", "MaxX");
        this.ymax = ir.getDoubleValue("GeoReference", "MaxY");
        this.xres = ir.getDoubleValue("GeoReference", "ResolutionX");
        this.yres = ir.getDoubleValue("GeoReference", "ResolutionY");
        this.nodatavalue = ir.valueExists("Data", "NoDataValue") ? (double)((float)ir.getDoubleValue("Data", "NoDataValue")) : Double.NaN;
        String s = ir.getStringValue("Data", "ByteOrder");
        this.byteorderLSB = true;
        if (s != null && s.length() > 0 && s.equals("MSB")) {
            this.byteorderLSB = false;
        }
    }

    public HashMap<String, Float> sample(double longitude, double latitude) throws IOException {
        HashMap<String, Float> map = new HashMap<String, Float>();
        float[] c = this.readCell(longitude, latitude);
        for (int i = 0; i < c.length; ++i) {
            map.put(this.names.get(i), Float.valueOf(c[i]));
        }
        return map;
    }

    float[] readCell(double longitude, double latitude) throws IOException {
        long pos = this.getcellnumber(longitude, latitude);
        if (pos >= 0L) {
            this.raf.seek(pos * (long)this.size * (long)this.cellSize);
            this.raf.read(this.b);
            ByteBuffer bb = ByteBuffer.wrap(this.b);
            if (this.byteorderLSB.booleanValue()) {
                bb.order(ByteOrder.LITTLE_ENDIAN);
            }
            for (int i = 0; i < this.cell.length; ++i) {
                this.cell[i] = bb.getFloat();
                if (this.cell[i] != -3.4028235E38f) continue;
                this.cell[i] = Float.NaN;
            }
            return this.cell;
        }
        return this.emptyCell;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void readHeader(String fname) throws IOException {
        this.names = new ArrayList();
        this.files = new ArrayList();
        BufferedReader br = null;
        try {
            String line;
            br = new BufferedReader(new FileReader(fname));
            while ((line = br.readLine()) != null) {
                this.names.add(line);
                this.files.add(line);
            }
        }
        catch (Exception e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
        }
        finally {
            if (br != null) {
                try {
                    br.close();
                }
                catch (Exception e) {
                    logger.error((Object)e.getMessage(), (Throwable)e);
                }
            }
        }
        this.cellSize = this.names.size();
        this.cell = new float[this.cellSize];
        this.emptyCell = new float[this.cellSize];
        for (int i = 0; i < this.emptyCell.length; ++i) {
            this.emptyCell[i] = Float.NaN;
        }
    }
}

