/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.data.store;

import java.io.IOException;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import org.geotools.data.FeatureLocking;
import org.geotools.data.FeatureReader;
import org.geotools.data.FeatureWriter;
import org.geotools.data.FilteringFeatureWriter;
import org.geotools.data.InProcessLockingManager;
import org.geotools.data.LockingManager;
import org.geotools.data.Query;
import org.geotools.data.Transaction;
import org.geotools.data.simple.SimpleFeatureStore;
import org.geotools.data.store.ContentEntry;
import org.geotools.data.store.ContentFeatureSource;
import org.geotools.data.store.DiffContentFeatureWriter;
import org.geotools.data.store.DiffTransactionState;
import org.geotools.data.store.EventContentFeatureWriter;
import org.geotools.factory.Hints;
import org.geotools.feature.FeatureCollection;
import org.geotools.feature.FeatureIterator;
import org.geotools.feature.NameImpl;
import org.geotools.filter.identity.FeatureIdImpl;
import org.opengis.feature.simple.SimpleFeature;
import org.opengis.feature.simple.SimpleFeatureType;
import org.opengis.feature.type.AttributeDescriptor;
import org.opengis.feature.type.Name;
import org.opengis.filter.Filter;
import org.opengis.filter.identity.FeatureId;

public abstract class ContentFeatureStore
extends ContentFeatureSource
implements SimpleFeatureStore,
FeatureLocking<SimpleFeatureType, SimpleFeature> {
    protected final int WRITER_ADD = 1;
    protected final int WRITER_UPDATE = 2;

    public ContentFeatureStore(ContentEntry entry, Query query) {
        super(entry, query);
    }

    public final FeatureWriter<SimpleFeatureType, SimpleFeature> getWriter(Filter filter) throws IOException {
        return this.getWriter(filter, 3);
    }

    public final FeatureWriter<SimpleFeatureType, SimpleFeature> getWriter(Filter filter, int flags) throws IOException {
        return this.getWriter(new Query(this.getSchema().getTypeName(), filter), flags);
    }

    public final FeatureWriter<SimpleFeatureType, SimpleFeature> getWriter(Query query) throws IOException {
        return this.getWriter(query, 3);
    }

    public final FeatureWriter<SimpleFeatureType, SimpleFeature> getWriter(Query query, int flags) throws IOException {
        FeatureWriter<SimpleFeatureType, SimpleFeature> writer;
        query = this.joinQuery(query);
        query = this.resolvePropertyNames(query);
        if (!this.canTransact() && this.transaction != null && this.transaction != Transaction.AUTO_COMMIT) {
            DiffTransactionState state = (DiffTransactionState)this.getTransaction().getState(this.getEntry());
            FeatureReader<SimpleFeatureType, SimpleFeature> reader = this.getReader(query);
            writer = new DiffContentFeatureWriter(this, state.getDiff(), reader);
        } else {
            writer = this.getWriterInternal(query, flags);
            if (this.canTransact() && !this.canEvent()) {
                writer = new EventContentFeatureWriter(this, writer);
            }
            if (!this.canFilter() && query.getFilter() != null && query.getFilter() != Filter.INCLUDE) {
                writer = new FilteringFeatureWriter(writer, query.getFilter());
            }
            if (!this.canLock()) {
                LockingManager lockingManager = this.getDataStore().getLockingManager();
                writer = ((InProcessLockingManager)lockingManager).checkedWriter(writer, this.transaction);
            }
        }
        return writer;
    }

    protected abstract FeatureWriter<SimpleFeatureType, SimpleFeature> getWriterInternal(Query var1, int var2) throws IOException;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<FeatureId> addFeatures(Collection collection) throws IOException {
        LinkedList<FeatureId> ids = new LinkedList<FeatureId>();
        FeatureWriter<SimpleFeatureType, SimpleFeature> writer = this.getWriterAppend();
        try {
            Iterator f = collection.iterator();
            while (f.hasNext()) {
                FeatureId id = this.addFeature((SimpleFeature)f.next(), writer);
                ids.add(id);
            }
        }
        finally {
            writer.close();
        }
        return ids;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<FeatureId> addFeatures(FeatureCollection<SimpleFeatureType, SimpleFeature> featureCollection) throws IOException {
        LinkedList<FeatureId> ids = new LinkedList<FeatureId>();
        FeatureWriter<SimpleFeatureType, SimpleFeature> writer = this.getWriterAppend();
        FeatureIterator<SimpleFeature> f = featureCollection.features();
        try {
            while (f.hasNext()) {
                SimpleFeature feature = f.next();
                FeatureId id = this.addFeature(feature, writer);
                ids.add(id);
            }
        }
        finally {
            writer.close();
            f.close();
        }
        return ids;
    }

    private FeatureWriter<SimpleFeatureType, SimpleFeature> getWriterAppend() throws IOException {
        FeatureWriter<SimpleFeatureType, SimpleFeature> writer = this.getWriter((Filter)Filter.INCLUDE, 1);
        while (writer.hasNext()) {
            writer.next();
        }
        return writer;
    }

    FeatureId addFeature(SimpleFeature feature, FeatureWriter<SimpleFeatureType, SimpleFeature> writer) throws IOException {
        SimpleFeature toWrite = writer.next();
        for (int i = 0; i < toWrite.getType().getAttributeCount(); ++i) {
            String name = toWrite.getType().getDescriptor(i).getLocalName();
            toWrite.setAttribute(name, feature.getAttribute(name));
        }
        if (feature.getUserData().size() > 0) {
            toWrite.getUserData().putAll(feature.getUserData());
        }
        boolean useExisting = Boolean.TRUE.equals(feature.getUserData().get(Hints.USE_PROVIDED_FID));
        if (this.getQueryCapabilities().isUseProvidedFIDSupported() && useExisting) {
            ((FeatureIdImpl)toWrite.getIdentifier()).setID(feature.getID());
        }
        writer.write();
        feature.getUserData().putAll(toWrite.getUserData());
        FeatureId id = toWrite.getIdentifier();
        return id;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void setFeatures(FeatureReader<SimpleFeatureType, SimpleFeature> reader) throws IOException {
        this.removeFeatures((Filter)Filter.INCLUDE);
        FeatureWriter<SimpleFeatureType, SimpleFeature> writer = this.getWriter((Filter)Filter.INCLUDE, 1);
        try {
            while (reader.hasNext()) {
                SimpleFeature feature = reader.next();
                SimpleFeature toWrite = writer.next();
                for (int i = 0; i < toWrite.getType().getAttributeCount(); ++i) {
                    String name = toWrite.getType().getDescriptor(i).getLocalName();
                    toWrite.setAttribute(name, feature.getAttribute(name));
                }
                writer.write();
            }
        }
        finally {
            writer.close();
        }
    }

    @Override
    public void modifyFeatures(AttributeDescriptor[] type, Object[] value, Filter filter) throws IOException {
        Name[] attributeNames = new Name[type.length];
        for (int i = 0; i < type.length; ++i) {
            attributeNames[i] = type[i].getName();
        }
        this.modifyFeatures(attributeNames, value, filter);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void modifyFeatures(Name[] type, Object[] value, Filter filter) throws IOException {
        if (filter == null) {
            String msg = "Must specify a filter, must not be null.";
            throw new IllegalArgumentException(msg);
        }
        filter = this.resolvePropertyNames(filter);
        FeatureWriter<SimpleFeatureType, SimpleFeature> writer = this.getWriter(filter, 2);
        try {
            while (writer.hasNext()) {
                SimpleFeature toWrite = writer.next();
                for (int i = 0; i < type.length; ++i) {
                    toWrite.setAttribute(type[i], value[i]);
                }
                writer.write();
            }
        }
        finally {
            writer.close();
        }
    }

    @Override
    public final void modifyFeatures(String name, Object attributeValue, Filter filter) throws IOException {
        this.modifyFeatures(new Name[]{new NameImpl(name)}, new Object[]{attributeValue}, filter);
    }

    @Override
    public final void modifyFeatures(String[] names, Object[] values, Filter filter) throws IOException {
        Name[] attributeNames = new Name[names.length];
        for (int i = 0; i < names.length; ++i) {
            attributeNames[i] = new NameImpl(names[i]);
        }
        this.modifyFeatures(attributeNames, values, filter);
    }

    @Override
    public final void modifyFeatures(AttributeDescriptor type, Object value, Filter filter) throws IOException {
        this.modifyFeatures(new Name[]{type.getName()}, new Object[]{value}, filter);
    }

    @Override
    public final void modifyFeatures(Name name, Object value, Filter filter) throws IOException {
        this.modifyFeatures(new Name[]{name}, new Object[]{value}, filter);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeFeatures(Filter filter) throws IOException {
        if (filter == null) {
            String msg = "Must specify a filter, must not be null.";
            throw new IllegalArgumentException(msg);
        }
        filter = this.resolvePropertyNames(filter);
        FeatureWriter<SimpleFeatureType, SimpleFeature> writer = this.getWriter(filter, 2);
        try {
            while (writer.hasNext()) {
                writer.next();
                writer.remove();
            }
        }
        finally {
            writer.close();
        }
    }
}

