/*
 * Decompiled with CFR 0.152.
 */
package com.jayway.jsonpath;

import com.jayway.jsonpath.Configuration;
import com.jayway.jsonpath.Filter;
import com.jayway.jsonpath.IndefinitePathException;
import com.jayway.jsonpath.InvalidModelException;
import com.jayway.jsonpath.JsonPath;
import com.jayway.jsonpath.Option;
import com.jayway.jsonpath.PathNotFoundException;
import com.jayway.jsonpath.Transformer;
import com.jayway.jsonpath.internal.JsonFormatter;
import com.jayway.jsonpath.internal.JsonReader;
import com.jayway.jsonpath.internal.PathToken;
import com.jayway.jsonpath.internal.Utils;
import com.jayway.jsonpath.spi.JsonProvider;
import com.jayway.jsonpath.spi.JsonProviderFactory;
import com.jayway.jsonpath.spi.MappingProviderFactory;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class JsonModel {
    private static final JsonPath JSON_PATH_ROOT = JsonPath.compile("$", new Filter[0]);
    private Object jsonObject;
    private Configuration configuration;

    private JsonModel(Object jsonObject, Configuration configuration) {
        Utils.notNull(jsonObject, "json can not be null", new Object[0]);
        Utils.notNull(configuration, "configuration can not be null", new Object[0]);
        if (!configuration.getProvider().isContainer(jsonObject)) {
            throw new IllegalArgumentException("Invalid container object");
        }
        this.configuration = configuration;
        this.jsonObject = jsonObject;
    }

    public boolean isList() {
        return this.configuration.getProvider().isArray(this.jsonObject);
    }

    public boolean isMap() {
        return this.configuration.getProvider().isMap(this.jsonObject);
    }

    public void print() {
        String json = this.toJson();
        System.out.println(JsonFormatter.prettyPrint(json));
    }

    public boolean hasPath(String jsonPath) {
        return this.hasPath(JsonPath.compile(jsonPath, new Filter[0]));
    }

    public boolean hasPath(JsonPath jsonPath) {
        Utils.isTrue(jsonPath.isPathDefinite(), "hasPath can only be used for definite paths");
        try {
            jsonPath.read(this.jsonObject, this.configuration.options(Option.THROW_ON_MISSING_PROPERTY));
        }
        catch (PathNotFoundException e) {
            return false;
        }
        return true;
    }

    public Object getJsonObject() {
        return this.jsonObject;
    }

    public <T> T get(String jsonPath, Filter ... filters) {
        return this.get(JsonPath.compile(jsonPath, filters));
    }

    public <T> T get(JsonPath jsonPath) {
        Utils.notNull(jsonPath, "jsonPath can not be null", new Object[0]);
        return jsonPath.read(this.jsonObject, this.configuration);
    }

    public ArrayOps opsForArray() {
        Utils.isTrue(this.configuration.getProvider().isArray(this.jsonObject), "This JsonModel is not a JSON array");
        return this.opsForArray(JSON_PATH_ROOT);
    }

    public ArrayOps opsForArray(String jsonPath) {
        return this.opsForArray(JsonPath.compile(jsonPath, new Filter[0]));
    }

    public ArrayOps opsForArray(JsonPath jsonPath) {
        Utils.notNull(jsonPath, "jsonPath can not be null", new Object[0]);
        return new DefaultArrayOps(jsonPath);
    }

    public ObjectOps opsForObject() {
        return this.opsForObject(JSON_PATH_ROOT);
    }

    public ObjectOps opsForObject(String jsonPath) {
        return this.opsForObject(JsonPath.compile(jsonPath, new Filter[0]));
    }

    public ObjectOps opsForObject(JsonPath jsonPath) {
        Utils.notNull(jsonPath, "jsonPath can not be null", new Object[0]);
        return new DefaultObjectOps(jsonPath);
    }

    public String toJson() {
        return this.toJson(false);
    }

    public String toJson(boolean prettyPrint) {
        String json = this.configuration.getProvider().toJson(this.jsonObject);
        if (prettyPrint) {
            return JsonFormatter.prettyPrint(json);
        }
        return json;
    }

    public String toJson(String jsonPath, Filter ... filters) {
        return this.toJson(JsonPath.compile(jsonPath, filters));
    }

    public String toJson(JsonPath jsonPath) {
        Utils.notNull(jsonPath, "jsonPath can not be null", new Object[0]);
        return this.configuration.getProvider().toJson(this.get(jsonPath));
    }

    public JsonModel getSubModel(String jsonPath) {
        return this.getSubModel(JsonPath.compile(jsonPath, new Filter[0]));
    }

    public JsonModel getSubModel(JsonPath jsonPath) {
        Utils.notNull(jsonPath, "jsonPath can not be null", new Object[0]);
        Utils.isTrue(jsonPath.isPathDefinite(), "You can only get subModels with a definite path. Use getDetachedModel if path is not definite.");
        Object subModel = jsonPath.read(this.jsonObject);
        if (!this.configuration.getProvider().isContainer(subModel)) {
            throw new InvalidModelException("The path " + jsonPath.getPath() + " returned an invalid model " + (subModel != null ? subModel.getClass() : "null"));
        }
        return new JsonSubModel(subModel, this.configuration, this, jsonPath);
    }

    public JsonModel getSubModelDetached(String jsonPath, Filter ... filters) {
        return this.getSubModelDetached(JsonPath.compile(jsonPath, filters));
    }

    public JsonModel getSubModelDetached(JsonPath jsonPath) {
        Utils.notNull(jsonPath, "jsonPath can not be null", new Object[0]);
        Object subModel = jsonPath.read(this.jsonObject, this.configuration);
        if (!this.configuration.getProvider().isContainer(subModel)) {
            throw new InvalidModelException("The path " + jsonPath.getPath() + " returned an invalid model " + (subModel != null ? subModel.getClass() : "null"));
        }
        subModel = this.configuration.getProvider().clone(subModel);
        return new JsonModel(subModel, this.configuration);
    }

    public MappingModelReader map() {
        return new DefaultMappingModelReader(this.jsonObject);
    }

    public MappingModelReader map(String jsonPath, Filter ... filters) {
        return this.map(JsonPath.compile(jsonPath, filters));
    }

    public MappingModelReader map(JsonPath jsonPath) {
        Utils.notNull(jsonPath, "jsonPath can not be null", new Object[0]);
        return new DefaultMappingModelReader(this.get(jsonPath));
    }

    public static JsonModel model(JsonProvider jsonProvider, String json) {
        Utils.notNull(jsonProvider, "jsonProvider can not be null", new Object[0]);
        Utils.notNull(json, "jsonObject can not be null", new Object[0]);
        return new JsonModel(new JsonReader(jsonProvider).parse(json).json(), Configuration.builder().jsonProvider(jsonProvider).build());
    }

    public static JsonModel model(String json) {
        return JsonModel.model(JsonProviderFactory.createProvider(), json);
    }

    public static JsonModel create(String json) {
        return JsonModel.model(json);
    }

    public static JsonModel model(JsonProvider jsonProvider, Object jsonObject) {
        Utils.notNull(jsonProvider, "jsonProvider can not be null", new Object[0]);
        Utils.notNull(jsonObject, "jsonObject can not be null", new Object[0]);
        return new JsonModel(jsonObject, Configuration.builder().jsonProvider(jsonProvider).build());
    }

    public static JsonModel model(Object jsonObject) {
        return JsonModel.model(JsonProviderFactory.createProvider(), jsonObject);
    }

    public static JsonModel create(Object jsonObject) {
        return JsonModel.model(jsonObject);
    }

    public static JsonModel model(JsonProvider jsonProvider, URL url) throws IOException {
        Utils.notNull(jsonProvider, "jsonProvider can not be null", new Object[0]);
        Utils.notNull(url, "url can not be null", new Object[0]);
        return new JsonModel(new JsonReader(jsonProvider).parse(url).json(), Configuration.builder().jsonProvider(jsonProvider).build());
    }

    public static JsonModel model(URL url) throws IOException {
        return JsonModel.model(JsonProviderFactory.createProvider(), url);
    }

    public static JsonModel create(URL url) throws IOException {
        return JsonModel.model(url);
    }

    public static JsonModel model(JsonProvider jsonProvider, InputStream jsonInputStream) throws IOException {
        Utils.notNull(jsonProvider, "jsonProvider can not be null", new Object[0]);
        Utils.notNull(jsonInputStream, "jsonInputStream can not be null", new Object[0]);
        return new JsonModel(new JsonReader(jsonProvider).parse(jsonInputStream).json(), Configuration.builder().jsonProvider(jsonProvider).build());
    }

    public static JsonModel model(InputStream jsonInputStream) throws IOException {
        return JsonModel.model(JsonProviderFactory.createProvider(), jsonInputStream);
    }

    public static JsonModel create(InputStream jsonInputStream) throws IOException {
        return JsonModel.model(jsonInputStream);
    }

    private <T> T getTargetObject(JsonPath jsonPath, Class<T> clazz) {
        Utils.notNull(jsonPath, "jsonPath can not be null", new Object[0]);
        if (!jsonPath.isPathDefinite()) {
            throw new IndefinitePathException(jsonPath.getPath());
        }
        Object modelRef = this.jsonObject;
        if (jsonPath.getTokenizer().size() == 1) {
            PathToken onlyToken = jsonPath.getTokenizer().iterator().next();
            if ("$".equals(onlyToken.getFragment())) {
                return clazz.cast(modelRef);
            }
        } else {
            PathToken currentToken;
            LinkedList<PathToken> tokens = jsonPath.getTokenizer().getPathTokens();
            do {
                currentToken = tokens.poll();
                modelRef = currentToken.apply(modelRef, this.configuration);
            } while (!tokens.isEmpty());
            if (modelRef.getClass().isAssignableFrom(clazz)) {
                throw new InvalidModelException(jsonPath + " does nor refer to a Map but " + currentToken.getClass().getName());
            }
            return clazz.cast(modelRef);
        }
        throw new InvalidModelException();
    }

    private void setTargetObject(JsonPath jsonPath, Object newValue) {
        JsonPath setterPath = jsonPath.copy();
        PathToken pathToken = setterPath.getTokenizer().removeLastPathToken();
        if (pathToken.isRootToken()) {
            if (this instanceof JsonSubModel) {
                JsonSubModel thisModel = (JsonSubModel)this;
                thisModel.parent.setTargetObject(thisModel.subModelPath, newValue);
            } else {
                this.jsonObject = newValue;
            }
        } else if (pathToken.isArrayIndexToken()) {
            int arrayIndex = pathToken.getArrayIndex();
            this.opsForArray(setterPath).set(arrayIndex, newValue);
        } else {
            this.opsForObject(setterPath).put(pathToken.getFragment(), newValue);
        }
    }

    private static class JsonSubModel
    extends JsonModel {
        private final JsonModel parent;
        private final JsonPath subModelPath;

        private JsonSubModel(Object jsonObject, Configuration configuration, JsonModel parent, JsonPath subModelPath) {
            super(jsonObject, configuration);
            this.parent = parent;
            this.subModelPath = subModelPath;
        }
    }

    private static class DefaultMappingModelReader
    implements MappingModelReader {
        private Object model;

        private DefaultMappingModelReader(Object model) {
            this.model = model;
        }

        @Override
        public ListMappingModelReader toList() {
            return this;
        }

        @Override
        public <T> List<T> of(Class<T> targetClass) {
            return this.toListOf(targetClass);
        }

        @Override
        public <T> List<T> toListOf(Class<T> targetClass) {
            List<Object> modelRef = this.model;
            if (!(modelRef instanceof List)) {
                modelRef = Arrays.asList(modelRef);
            }
            return MappingProviderFactory.createProvider().convertValue(modelRef, List.class, targetClass);
        }

        @Override
        public <T> Set<T> toSetOf(Class<T> targetClass) {
            HashSet<Object> modelRef = this.model;
            if (!(modelRef instanceof List)) {
                HashSet<Object> setModel = new HashSet<Object>();
                setModel.add(this.model);
                modelRef = setModel;
            }
            return MappingProviderFactory.createProvider().convertValue(modelRef, Set.class, targetClass);
        }

        @Override
        public <T> T to(Class<T> targetClass) {
            return MappingProviderFactory.createProvider().convertValue(this.model, targetClass);
        }
    }

    private class DefaultArrayOps
    implements ArrayOps {
        private JsonPath jsonPath;

        private DefaultArrayOps(JsonPath jsonPath) {
            this.jsonPath = jsonPath;
        }

        @Override
        public List<Object> getTarget() {
            return (List)JsonModel.this.getTargetObject(this.jsonPath, List.class);
        }

        @Override
        public ArrayOps add(Object o) {
            ((List)JsonModel.this.getTargetObject(this.jsonPath, List.class)).add(o);
            return this;
        }

        @Override
        public ArrayOps addAll(Collection<Object> collection) {
            ((List)JsonModel.this.getTargetObject(this.jsonPath, List.class)).addAll(collection);
            return this;
        }

        @Override
        public ArrayOps remove(Object o) {
            ((List)JsonModel.this.getTargetObject(this.jsonPath, List.class)).remove(o);
            return this;
        }

        @Override
        public int size() {
            return ((List)JsonModel.this.getTargetObject(this.jsonPath, List.class)).size();
        }

        @Override
        public ArrayOps set(int index, Object value) {
            ((List)JsonModel.this.getTargetObject(this.jsonPath, List.class)).set(index, value);
            return this;
        }

        @Override
        public ListMappingModelReader toList() {
            return new DefaultMappingModelReader(JsonModel.this.getTargetObject(this.jsonPath, List.class));
        }

        @Override
        public ArrayOps transform(Transformer<List<Object>> transformer) {
            Object transformed = transformer.transform((List<Object>)JsonModel.this.getTargetObject(this.jsonPath, List.class), JsonModel.this.configuration);
            JsonModel.this.setTargetObject(this.jsonPath, transformed);
            return this;
        }

        @Override
        public ArrayOps each(Transformer<Object> transformer) {
            List targetObject = (List)JsonModel.this.getTargetObject(this.jsonPath, List.class);
            for (int i = 0; i < targetObject.size(); ++i) {
                targetObject.set(i, transformer.transform(targetObject.get(i), JsonModel.this.configuration));
            }
            return this;
        }

        @Override
        public <T> List<T> toListOf(Class<T> targetClass) {
            return new DefaultMappingModelReader(JsonModel.this.getTargetObject(this.jsonPath, List.class)).toListOf(targetClass);
        }

        @Override
        public <T> Set<T> toSetOf(Class<T> targetClass) {
            return new DefaultMappingModelReader(JsonModel.this.getTargetObject(this.jsonPath, List.class)).toSetOf(targetClass);
        }
    }

    private class DefaultObjectOps
    implements ObjectOps {
        private JsonPath jsonPath;

        private DefaultObjectOps(JsonPath jsonPath) {
            this.jsonPath = jsonPath;
        }

        @Override
        public Map<String, Object> getTarget() {
            return (Map)JsonModel.this.getTargetObject(this.jsonPath, Map.class);
        }

        @Override
        public boolean containsKey(String key) {
            return ((Map)JsonModel.this.getTargetObject(this.jsonPath, Map.class)).containsKey(key);
        }

        @Override
        public ObjectOps put(String key, Object value) {
            ((Map)JsonModel.this.getTargetObject(this.jsonPath, Map.class)).put(key, value);
            return this;
        }

        @Override
        public ObjectOps putIfAbsent(String key, Object value) {
            Map targetObject = (Map)JsonModel.this.getTargetObject(this.jsonPath, Map.class);
            if (!targetObject.containsKey(key)) {
                targetObject.put(key, value);
            }
            return this;
        }

        @Override
        public Object get(String key) {
            return ((Map)JsonModel.this.getTargetObject(this.jsonPath, Map.class)).get(key);
        }

        @Override
        public Integer getInteger(String key) {
            return Utils.toInt(this.get(key));
        }

        @Override
        public Long getLong(String key) {
            return Utils.toLong(this.get(key));
        }

        @Override
        public Double getDouble(String key) {
            return Utils.toDouble(this.get(key));
        }

        @Override
        public String getString(String key) {
            return Utils.toString(this.get(key));
        }

        @Override
        public ObjectOps putAll(Map<String, Object> map) {
            ((Map)JsonModel.this.getTargetObject(this.jsonPath, Map.class)).putAll(map);
            return this;
        }

        @Override
        public ObjectOps remove(String key) {
            ((Map)JsonModel.this.getTargetObject(this.jsonPath, Map.class)).remove(key);
            return this;
        }

        @Override
        public ObjectOps transform(Transformer<Map<String, Object>> transformer) {
            Map targetObject = (Map)JsonModel.this.getTargetObject(this.jsonPath, Map.class);
            Object transformed = transformer.transform(targetObject, JsonModel.this.configuration);
            JsonModel.this.setTargetObject(this.jsonPath, transformed);
            return this;
        }

        @Override
        public <T> T to(Class<T> targetClass) {
            Map targetObject = (Map)JsonModel.this.getTargetObject(this.jsonPath, Map.class);
            return new DefaultMappingModelReader(targetObject).to(targetClass);
        }
    }

    public static interface ArrayOps {
        public List<Object> getTarget();

        public ArrayOps add(Object var1);

        public ArrayOps addAll(Collection<Object> var1);

        public ArrayOps remove(Object var1);

        public int size();

        public ArrayOps set(int var1, Object var2);

        public ArrayOps transform(Transformer<List<Object>> var1);

        public ArrayOps each(Transformer<Object> var1);

        public ListMappingModelReader toList();

        public <T> List<T> toListOf(Class<T> var1);

        public <T> Set<T> toSetOf(Class<T> var1);
    }

    public static interface ObjectOps {
        public Map<String, Object> getTarget();

        public boolean containsKey(String var1);

        public ObjectOps put(String var1, Object var2);

        public ObjectOps putIfAbsent(String var1, Object var2);

        public Object get(String var1);

        public Integer getInteger(String var1);

        public Long getLong(String var1);

        public Double getDouble(String var1);

        public String getString(String var1);

        public ObjectOps putAll(Map<String, Object> var1);

        public ObjectOps remove(String var1);

        public ObjectOps transform(Transformer<Map<String, Object>> var1);

        public <T> T to(Class<T> var1);
    }

    public static interface MappingModelReader
    extends ListMappingModelReader,
    ObjectMappingModelReader {
    }

    public static interface ListMappingModelReader {
        public <T> List<T> of(Class<T> var1);

        public ListMappingModelReader toList();

        public <T> List<T> toListOf(Class<T> var1);

        public <T> Set<T> toSetOf(Class<T> var1);
    }

    public static interface ObjectMappingModelReader {
        public <T> T to(Class<T> var1);
    }
}

