/*
 * Decompiled with CFR 0.152.
 */
package org.gbif.utils.file.tabular;

import com.google.common.base.CharMatcher;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import org.gbif.common.shaded.com.fasterxml.jackson.databind.MappingIterator;
import org.gbif.common.shaded.com.fasterxml.jackson.databind.SequenceWriter;
import org.gbif.common.shaded.com.fasterxml.jackson.dataformat.csv.CsvMapper;
import org.gbif.common.shaded.com.fasterxml.jackson.dataformat.csv.CsvParser;
import org.gbif.common.shaded.com.fasterxml.jackson.dataformat.csv.CsvSchema;
import org.gbif.utils.file.tabular.JacksonUtils;

public class TabularFileNormalizer {
    private static CharMatcher CONTROL_CHAR_MATCHER = CharMatcher.JAVA_ISO_CONTROL;
    public static String NORMALIZED_END_OF_LINE = "\n";

    public static int normalizeFile(Path source, Path destination, Charset sourceCharset, char delimiterChar, String endOfLineSymbols, Character quoteChar) throws IOException {
        Objects.requireNonNull(source, "source path shall be provided");
        Objects.requireNonNull(destination, "normalizedWriter shall be provided");
        int numberOfLine = 0;
        CsvMapper mapper = new CsvMapper();
        mapper.enable(CsvParser.Feature.WRAP_AS_ARRAY);
        CsvSchema readerSchema = JacksonUtils.buildCsvSchema(delimiterChar, endOfLineSymbols, quoteChar);
        CsvSchema writerSchema = JacksonUtils.buildCsvSchema(delimiterChar, NORMALIZED_END_OF_LINE, quoteChar);
        Charset charset = Optional.ofNullable(sourceCharset).orElse(StandardCharsets.UTF_8);
        try (BufferedReader sourceReader = Files.newBufferedReader(source, charset);
             BufferedWriter writer = Files.newBufferedWriter(destination, charset, new OpenOption[0]);
             MappingIterator it = mapper.readerFor(List.class).with(readerSchema).readValues(sourceReader);
             SequenceWriter csvWriter = mapper.writerFor(List.class).with(writerSchema).writeValues(writer);){
            while (it.hasNext()) {
                Optional<List<String>> line = TabularFileNormalizer.normalizeLine((List)it.next());
                if (!line.isPresent()) continue;
                csvWriter.write(line.get());
                ++numberOfLine;
            }
        }
        catch (IOException ioEx) {
            Files.deleteIfExists(destination);
            throw ioEx;
        }
        return numberOfLine;
    }

    private static Optional<List<String>> normalizeLine(List<String> line) {
        if (line == null || line.isEmpty()) {
            return Optional.empty();
        }
        return Optional.of(line.stream().map(s -> s == null ? "" : s).map(arg_0 -> ((CharMatcher)CONTROL_CHAR_MATCHER).removeFrom(arg_0)).collect(Collectors.toList()));
    }
}

