/*
 * Decompiled with CFR 0.152.
 */
package org.gbif.utils.file;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FileSplitter {
    private static final Logger LOG = LoggerFactory.getLogger(FileSplitter.class);
    public static final String SEPARATOR = "_";
    public static final int READ_AHEAD_BYTES = 256;

    public static List<Long> scanToChunk(File from, long chunkSizeBytes) throws IOException {
        ArrayList<Long> chunkBytes = new ArrayList<Long>();
        FileInputStream fis = new FileInputStream(from);
        FileChannel fcin = fis.getChannel();
        ByteBuffer bb = ByteBuffer.allocate(256);
        for (long byteCount = chunkSizeBytes; byteCount < fcin.size(); byteCount += chunkSizeBytes) {
            fcin.read(bb, byteCount);
            int i = 0;
            for (i = 0; i < bb.limit(); ++i) {
                if ((char)bb.get(i) != '\n') continue;
                ++i;
                break;
            }
            chunkBytes.add((long)i + byteCount);
        }
        fcin.close();
        fis.close();
        return chunkBytes;
    }

    public static List<File> split(File from, File targetDirectory, String suffix, long chunkSizeBytes) throws IOException {
        ArrayList<File> files = new ArrayList<File>();
        FileInputStream fis = new FileInputStream(from);
        FileChannel fcin = fis.getChannel();
        String filePartNamePrefix = "";
        String filePartNameSuffix = "";
        if (from.getName().contains(".")) {
            filePartNamePrefix = from.getName().substring(0, from.getName().indexOf("."));
            filePartNameSuffix = from.getName().substring(from.getName().indexOf("."));
        } else {
            filePartNamePrefix = from.getName();
        }
        long byteCount = 0L;
        int filePartCount = 0;
        while (byteCount < fcin.size()) {
            long time = System.currentTimeMillis();
            String fileName = filePartNamePrefix + SEPARATOR + suffix + SEPARATOR + filePartCount + filePartNameSuffix;
            File to = new File(targetDirectory, fileName);
            files.add(to);
            FileOutputStream fos = new FileOutputStream(to);
            FileChannel fcout = fos.getChannel();
            fcin.transferTo(byteCount, chunkSizeBytes, fcout);
            ByteBuffer bb = ByteBuffer.allocate(256);
            fcin.read(bb, byteCount += chunkSizeBytes);
            int i = 0;
            for (i = 0; i < bb.limit(); ++i) {
                if ((char)bb.get(i) != '\n') continue;
                ++i;
                break;
            }
            bb.rewind();
            bb.limit(i);
            fcout.write(bb);
            byteCount += (long)i;
            fcout.close();
            fos.close();
            ++filePartCount;
            LOG.debug("Filepart[" + fileName + "] created in " + (1L + System.currentTimeMillis() - time) / 1000L + " secs");
        }
        fcin.close();
        fis.close();
        return files;
    }

    private FileSplitter() {
        throw new UnsupportedOperationException("Can't initialize class");
    }
}

