/*
 * Decompiled with CFR 0.152.
 */
package org.gbif.utils.concurrent;

import java.util.concurrent.ExecutorService;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ExecutorUtils {
    private static final Logger LOG = LoggerFactory.getLogger(ExecutorUtils.class);

    public static void stop(ExecutorService exec) {
        ExecutorUtils.stop(exec, 1, TimeUnit.HOURS);
    }

    public static void stop(ExecutorService exec, int timeout, TimeUnit unit) {
        LOG.debug("Shutting down executor service {}", (Object)exec);
        exec.shutdown();
        try {
            if (!exec.awaitTermination(timeout, unit)) {
                LOG.warn("Forcing shut down of executor service, pending tasks will be lost! {}", (Object)exec);
                exec.shutdownNow();
            }
        }
        catch (InterruptedException ie) {
            LOG.warn("Forcing shut down of executor service, pending tasks will be lost! {}", (Object)exec);
            exec.shutdownNow();
            Thread.currentThread().interrupt();
        }
    }
}

