/*
 * Decompiled with CFR 0.152.
 */
package org.gbif.utils.collection;

import java.util.Collections;
import java.util.Comparator;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.Map;

public class MapUtils {
    private MapUtils() {
        throw new UnsupportedOperationException("Can't initialize class");
    }

    public static <K, V extends Comparable<? super V>> Map<K, V> sortByValue(Map<K, V> map) {
        return MapUtils.sortByValueInternal(map, new Comparator<Map.Entry<K, V>>(){

            @Override
            public int compare(Map.Entry<K, V> o1, Map.Entry<K, V> o2) {
                return ((Comparable)o1.getValue()).compareTo(o2.getValue());
            }
        });
    }

    public static <K, V> Map<K, V> sortByValue(Map<K, V> map, final Comparator<V> comparator) {
        return MapUtils.sortByValueInternal(map, new Comparator<Map.Entry<K, V>>(){

            @Override
            public int compare(Map.Entry<K, V> o1, Map.Entry<K, V> o2) {
                return comparator.compare(o1.getValue(), o2.getValue());
            }
        });
    }

    private static <K, V> Map<K, V> sortByValueInternal(Map<K, V> map, Comparator<Map.Entry<K, V>> comp) {
        LinkedList<Map.Entry<K, V>> list = new LinkedList<Map.Entry<K, V>>(map.entrySet());
        Collections.sort(list, comp);
        LinkedHashMap result = new LinkedHashMap(list.size());
        for (Map.Entry entry : list) {
            result.put(entry.getKey(), entry.getValue());
        }
        return result;
    }

    public static <K, V> V getOrDefault(Map<K, V> map, K key, V defaultValue) {
        return map.containsKey(key) ? map.get(key) : defaultValue;
    }
}

