/*
 * Decompiled with CFR 0.152.
 */
package org.gbif.dwc.extensions;

import java.net.MalformedURLException;
import java.net.URL;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;
import org.gbif.dwc.extensions.Vocabulary;
import org.gbif.dwc.extensions.VocabularyTerm;

public class VocabularyConcept
implements Comparable<VocabularyConcept> {
    private static final Comparator<VocabularyConcept> COMPARATOR = Comparator.comparing(VocabularyConcept::getVocabulary, Comparator.nullsFirst(Comparator.naturalOrder())).thenComparing(VocabularyConcept::getOrder).thenComparing(VocabularyConcept::getUri);
    private Vocabulary vocabulary;
    private String identifier;
    private String description;
    private String uri;
    private URL link;
    private int order = -1;
    private Set<VocabularyTerm> alternativeTerms = new HashSet<VocabularyTerm>();
    private Set<VocabularyTerm> preferredTerms = new HashSet<VocabularyTerm>();

    public void addAlternativeTerm(VocabularyTerm term) {
        this.alternativeTerms.add(term);
    }

    public void addPreferredTerm(VocabularyTerm term) {
        this.preferredTerms.add(term);
    }

    public Set<VocabularyTerm> getAlternativeTerms() {
        return this.alternativeTerms;
    }

    public String getDescription() {
        return this.description;
    }

    public String getIdentifier() {
        return this.identifier;
    }

    public URL getLink() {
        return this.link;
    }

    public Integer getOrder() {
        return this.order;
    }

    public VocabularyTerm getPreferredTerm(String lang) {
        VocabularyTerm tEN = null;
        for (VocabularyTerm t : this.preferredTerms) {
            if (t.getLang().equalsIgnoreCase(lang)) {
                return t;
            }
            if (!t.getLang().equalsIgnoreCase("en")) continue;
            tEN = t;
        }
        return tEN;
    }

    public Set<VocabularyTerm> getPreferredTerms() {
        return this.preferredTerms;
    }

    public Set<VocabularyTerm> getTerms() {
        HashSet<VocabularyTerm> t = new HashSet<VocabularyTerm>(this.preferredTerms);
        t.addAll(this.alternativeTerms);
        return t;
    }

    public String getUri() {
        return this.uri;
    }

    public Vocabulary getVocabulary() {
        return this.vocabulary;
    }

    public void setAlternativeTerms(Set<VocabularyTerm> alternativeTerms) {
        this.alternativeTerms = alternativeTerms;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public void setIdentifier(String identifier) {
        this.identifier = identifier;
    }

    public void setLink(String link) {
        try {
            this.link = new URL(link);
        }
        catch (MalformedURLException malformedURLException) {
            // empty catch block
        }
    }

    public void setLink(URL link) {
        this.link = link;
    }

    public void setOrder(int order) {
        this.order = order;
    }

    public void setPreferredTerms(Set<VocabularyTerm> preferredTerms) {
        this.preferredTerms = preferredTerms;
    }

    public void setUri(String uri) {
        this.uri = uri;
    }

    public void setVocabulary(Vocabulary vocabulary) {
        this.vocabulary = vocabulary;
    }

    public int hashCode() {
        return Objects.hash(this.vocabulary, this.identifier, this.uri);
    }

    @Override
    public int compareTo(VocabularyConcept object) {
        return COMPARATOR.compare(this, object);
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof VocabularyConcept)) {
            return false;
        }
        VocabularyConcept o = (VocabularyConcept)other;
        return Objects.equals(this.vocabulary, o.vocabulary) && Objects.equals(this.identifier, o.identifier) && Objects.equals(this.uri, o.uri);
    }

    public String toString() {
        return this.uri;
    }
}

