/*
 * Decompiled with CFR 0.152.
 */
package org.gbif.dwc.extensions;

import java.net.MalformedURLException;
import java.net.URL;
import java.util.Date;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import org.gbif.dwc.extensions.VocabularyConcept;

public class Vocabulary
implements Comparable<Vocabulary> {
    private String uri;
    private String title;
    private String description;
    private String subject;
    private URL link;
    private List<VocabularyConcept> concepts = new LinkedList<VocabularyConcept>();
    private Date lastUpdate = new Date();

    public void addConcept(VocabularyConcept concept) {
        concept.setVocabulary(this);
        if (concept.getOrder() == -1) {
            int maxOrder = 0;
            for (VocabularyConcept tc : this.concepts) {
                if (tc.getOrder() < 0 || maxOrder >= tc.getOrder()) continue;
                maxOrder = tc.getOrder();
            }
            concept.setOrder(maxOrder + 1);
        }
        this.concepts.add(concept);
    }

    public List<VocabularyConcept> getConcepts() {
        return this.concepts;
    }

    public void setConcepts(List<VocabularyConcept> concepts) {
        this.concepts = concepts;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public Date getLastUpdate() {
        return this.lastUpdate;
    }

    public void setLastUpdate(Date lastUpdate) {
        this.lastUpdate = lastUpdate;
    }

    public URL getLink() {
        return this.link;
    }

    public void setLink(URL link) {
        this.link = link;
    }

    public void setLink(String link) {
        try {
            URL url;
            this.link = url = new URL(link);
        }
        catch (MalformedURLException malformedURLException) {
            // empty catch block
        }
    }

    public String getSubject() {
        return this.subject;
    }

    public void setSubject(String subject) {
        this.subject = subject;
    }

    public String getTitle() {
        return this.title;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public String getUri() {
        return this.uri;
    }

    public void setUri(String uri) {
        this.uri = uri;
    }

    public String toString() {
        return this.uri;
    }

    @Override
    public int compareTo(Vocabulary object) {
        return Objects.compare(this.uri, object.uri, String::compareTo);
    }

    public int hashCode() {
        return Objects.hash(this.uri);
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof Vocabulary)) {
            return false;
        }
        Vocabulary o = (Vocabulary)other;
        return Objects.equals(this.uri, o.uri);
    }
}

