/*
 * Decompiled with CFR 0.152.
 */
package org.gbif.dwc.extensions;

import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Date;
import java.util.List;
import java.util.Objects;
import org.gbif.dwc.extensions.ExtensionProperty;
import org.gbif.dwc.terms.Term;
import org.gbif.dwc.terms.TermFactory;

public class Extension
implements Comparable<Extension> {
    private static final Comparator<Extension> COMPARATOR = Comparator.comparing(ext -> ext.getRowType() == null ? null : ext.getRowType().qualifiedName(), Comparator.nullsLast(Comparator.naturalOrder())).thenComparing(ext -> ext.getUrl() == null ? null : ext.getUrl().toString(), Comparator.nullsLast(Comparator.naturalOrder()));
    private String title;
    private String name;
    private URL url;
    private Term rowType;
    private String subject;
    private String description;
    private String namespace;
    private URL link;
    private boolean installed;
    private List<ExtensionProperty> properties = new ArrayList<ExtensionProperty>();
    private boolean core = false;
    private boolean dev = false;
    private Date modified = new Date();

    public Extension(URL url, boolean dev) {
        this.url = url;
        this.dev = dev;
    }

    public void addProperty(ExtensionProperty property) {
        property.setExtension(this);
        this.properties.add(property);
    }

    @Override
    public int compareTo(Extension object) {
        return COMPARATOR.compare(this, object);
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof Extension)) {
            return false;
        }
        Extension o = (Extension)other;
        return Objects.equals(this.rowType, o.rowType) && Objects.equals(this.url.toString(), o.url.toString());
    }

    public String getDescription() {
        return this.description;
    }

    public URL getLink() {
        return this.link;
    }

    public Date getModified() {
        return this.modified;
    }

    public String getName() {
        return this.name;
    }

    public String getNamespace() {
        return this.namespace;
    }

    public List<ExtensionProperty> getProperties() {
        return this.properties;
    }

    public ExtensionProperty getProperty(Term term) {
        return this.getProperty(term.qualifiedName());
    }

    public ExtensionProperty getProperty(String term) {
        if (term == null) {
            return null;
        }
        for (ExtensionProperty p : this.properties) {
            if (!term.equalsIgnoreCase(p.getQualname())) continue;
            return p;
        }
        return null;
    }

    public Term getRowType() {
        return this.rowType;
    }

    public String getSubject() {
        return this.subject;
    }

    public String getTitle() {
        return this.title;
    }

    public URL getUrl() {
        return this.url;
    }

    public int hashCode() {
        return Objects.hash(this.rowType, this.url);
    }

    public boolean hasProperty(Term term) {
        return this.getProperty(term) != null;
    }

    public boolean hasProperty(String term) {
        return this.getProperty(term) != null;
    }

    public boolean isCore() {
        return this.core;
    }

    public boolean isDev() {
        return this.dev;
    }

    public boolean isInstalled() {
        return this.installed;
    }

    public void setCore(boolean core) {
        this.core = core;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public void setInstalled(boolean installed) {
        this.installed = installed;
    }

    public void setLink(String link) {
        try {
            URL url;
            this.link = url = new URL(link);
        }
        catch (MalformedURLException malformedURLException) {
            // empty catch block
        }
    }

    public void setLink(URL link) {
        this.link = link;
    }

    public void setModified(Date modified) {
        this.modified = modified;
    }

    public void setName(String name) {
        this.name = name.replaceAll("\\s", "_");
    }

    public void setNamespace(String namespace) {
        this.namespace = namespace;
    }

    public void setProperties(List<ExtensionProperty> properties) {
        this.properties = properties;
    }

    public void setRowType(String rowType) {
        this.setRowType(TermFactory.instance().findTerm(rowType));
    }

    public void setRowType(Term rowType) {
        this.rowType = rowType;
    }

    public void setSubject(String subject) {
        this.subject = subject;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public String toString() {
        return "name:" + this.name + (", rowType:" + this.rowType);
    }
}

