/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.gml3.bindings.ext;

import com.vividsolutions.jts.geom.CoordinateList;
import com.vividsolutions.jts.geom.CoordinateSequenceFactory;
import com.vividsolutions.jts.geom.GeometryFactory;
import com.vividsolutions.jts.geom.LineString;
import com.vividsolutions.jts.geom.MultiLineString;
import java.util.List;
import javax.xml.namespace.QName;
import org.geotools.gml3.GML;
import org.geotools.gml3.bindings.LineStringTypeBinding;
import org.geotools.xml.ElementInstance;
import org.geotools.xml.Node;

public class CompositeCurveTypeBinding
extends LineStringTypeBinding {
    private final GeometryFactory gFactory;

    public CompositeCurveTypeBinding(GeometryFactory gFactory, CoordinateSequenceFactory csFactory) {
        super(gFactory, csFactory);
        this.gFactory = gFactory;
    }

    @Override
    public QName getTarget() {
        return GML.CompositeCurveType;
    }

    @Override
    public Class getType() {
        return LineString.class;
    }

    @Override
    public Object parse(ElementInstance instance, Node node, Object value) throws Exception {
        CoordinateList clist = CompositeCurveTypeBinding.extractCurveMemberCoordinates(node);
        LineString lineString = this.gFactory.createLineString(clist.toCoordinateArray());
        return lineString;
    }

    public static CoordinateList extractCurveMemberCoordinates(Node node) {
        List curveMembers = node.getChildren("curveMember");
        CoordinateList clist = new CoordinateList();
        for (int i = 0; i < curveMembers.size(); ++i) {
            List curves = ((Node)curveMembers.get(i)).getChildren(MultiLineString.class);
            for (int j = 0; j < curves.size(); ++j) {
                MultiLineString mls = (MultiLineString)((Node)curves.get(j)).getValue();
                clist.add(mls.getCoordinates(), false);
            }
        }
        return clist;
    }
}

