/*
 * Decompiled with CFR 0.152.
 */
package org.rev6.scf;

import com.jcraft.jsch.ChannelExec;
import com.jcraft.jsch.JSchException;
import com.jcraft.jsch.Session;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.logging.Logger;
import org.rev6.scf.SshException;

public abstract class SshTask {
    protected final Logger logger = Logger.getLogger(this.getClass().getPackage().getName());

    int checkAck(InputStream in) throws IOException {
        int b = in.read();
        if (b == 0) {
            return b;
        }
        if (b == -1) {
            return b;
        }
        if (b == 1 || b == 2) {
            int c;
            StringBuffer sb = new StringBuffer();
            do {
                c = in.read();
                sb.append((char)c);
            } while (c != 10);
            if (b == 1) {
                this.logger.severe("scp failed with an error - reason: " + sb.toString());
            }
            if (b == 2) {
                this.logger.severe("scp failed with a fatal error - reason: " + sb.toString());
            }
        }
        return b;
    }

    void sendAck(OutputStream out) throws IOException {
        out.write(0);
        out.flush();
    }

    ChannelExec setUpChannel(Session sshSession, String cmd) throws JSchException {
        ChannelExec channel = (ChannelExec)sshSession.openChannel("exec");
        channel.setCommand(cmd);
        return channel;
    }

    abstract void execute(Session var1) throws SshException;
}

