/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.renderer.style;

import java.awt.Shape;
import java.awt.geom.Rectangle2D;
import org.geotools.geometry.jts.TransformedShape;
import org.geotools.renderer.style.PolygonStyle2D;
import org.geotools.resources.Classes;

public class MarkStyle2D
extends PolygonStyle2D {
    static boolean maxMarkSizeEnabled = Boolean.getBoolean("org.geotools.maxMarkSizeEnabled");
    Shape shape;
    double size;
    float rotation;

    public float getRotation() {
        return this.rotation;
    }

    public Shape getShape() {
        return this.shape;
    }

    public Shape getTransformedShape(float x, float y) {
        return this.getTransformedShape(x, y, this.rotation);
    }

    public Shape getTransformedShape(float x, float y, float rotation) {
        if (this.shape != null) {
            Rectangle2D bounds = this.shape.getBounds2D();
            double shapeSize = maxMarkSizeEnabled ? Math.max(bounds.getWidth(), bounds.getHeight()) : bounds.getHeight();
            double scale = this.size / shapeSize;
            TransformedShape ts = new TransformedShape();
            ts.shape = this.shape;
            ts.translate(x, y);
            ts.rotate(rotation);
            ts.scale(scale, -scale);
            return ts;
        }
        return null;
    }

    public double getSize() {
        return this.size;
    }

    public void setRotation(float f) {
        this.rotation = f;
    }

    public void setShape(Shape shape) {
        this.shape = shape;
    }

    public void setSize(double i) {
        this.size = i;
    }

    @Override
    public String toString() {
        return Classes.getShortClassName((Object)this) + '[' + this.shape + ']';
    }

    public static boolean isMaxMarkSizeEnabled() {
        return maxMarkSizeEnabled;
    }

    public static void setMaxMarkSizeEnabled(boolean useMaxMarkSize) {
        maxMarkSizeEnabled = useMaxMarkSize;
    }
}

