/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.renderer.crs;

import com.vividsolutions.jts.geom.Envelope;
import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.geom.GeometryCollection;
import com.vividsolutions.jts.geom.Polygon;
import com.vividsolutions.jts.precision.EnhancedPrecisionOp;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.logging.Logger;
import org.geotools.geometry.jts.JTS;
import org.geotools.geometry.jts.ReferencedEnvelope;
import org.geotools.referencing.CRS;
import org.geotools.referencing.crs.DefaultGeographicCRS;
import org.geotools.referencing.operation.transform.ConcatenatedTransform;
import org.geotools.referencing.operation.transform.GeocentricTransform;
import org.geotools.renderer.crs.GeographicOffsetWrapper;
import org.geotools.renderer.crs.ProjectionHandlerFinder;
import org.geotools.util.logging.Logging;
import org.opengis.metadata.extent.GeographicBoundingBox;
import org.opengis.referencing.FactoryException;
import org.opengis.referencing.crs.CoordinateReferenceSystem;
import org.opengis.referencing.crs.GeographicCRS;
import org.opengis.referencing.crs.SingleCRS;
import org.opengis.referencing.operation.MathTransform;
import org.opengis.referencing.operation.TransformException;

public class ProjectionHandler {
    protected static final Logger LOGGER = Logging.getLogger(ProjectionHandler.class);
    ReferencedEnvelope renderingEnvelope;
    final Envelope validAreaBounds;
    final Geometry validArea;
    final CoordinateReferenceSystem sourceCRS;
    final CoordinateReferenceSystem targetCRS;

    public ProjectionHandler(CoordinateReferenceSystem sourceCRS, Envelope validAreaBounds, ReferencedEnvelope renderingEnvelope) throws FactoryException {
        this.renderingEnvelope = renderingEnvelope;
        this.sourceCRS = sourceCRS;
        this.targetCRS = renderingEnvelope.getCoordinateReferenceSystem();
        this.validAreaBounds = validAreaBounds;
        this.validArea = null;
    }

    public ProjectionHandler(CoordinateReferenceSystem sourceCRS, Geometry validArea, ReferencedEnvelope renderingEnvelope) throws FactoryException {
        if (validArea.isRectangle()) {
            this.renderingEnvelope = renderingEnvelope;
            this.sourceCRS = sourceCRS;
            this.targetCRS = renderingEnvelope.getCoordinateReferenceSystem();
            this.validAreaBounds = validArea.getEnvelopeInternal();
            this.validArea = null;
        } else {
            this.renderingEnvelope = renderingEnvelope;
            this.sourceCRS = sourceCRS;
            this.targetCRS = renderingEnvelope.getCoordinateReferenceSystem();
            this.validAreaBounds = validArea.getEnvelopeInternal();
            this.validArea = validArea;
        }
    }

    public ReferencedEnvelope getRenderingEnvelope() {
        return this.renderingEnvelope;
    }

    public CoordinateReferenceSystem getSourceCRS() {
        return this.sourceCRS;
    }

    public List<ReferencedEnvelope> getQueryEnvelopes() throws TransformException, FactoryException {
        CoordinateReferenceSystem renderingCRS = this.renderingEnvelope.getCoordinateReferenceSystem();
        if (renderingCRS instanceof GeographicCRS && !CRS.equalsIgnoreMetadata((Object)renderingCRS, (Object)DefaultGeographicCRS.WGS84)) {
            ReferencedEnvelope re = this.renderingEnvelope;
            ArrayList<ReferencedEnvelope> envelopes = new ArrayList<ReferencedEnvelope>();
            envelopes.add(re);
            if (CRS.getAxisOrder((CoordinateReferenceSystem)renderingCRS) == CRS.AxisOrder.NORTH_EAST) {
                if (re.getMinY() >= -180.0 && re.getMaxY() <= 180.0) {
                    return Collections.singletonList(this.transformEnvelope(this.renderingEnvelope, this.sourceCRS));
                }
                if (re.getMinY() < -180.0) {
                    envelopes.add(new ReferencedEnvelope(re.getMinY() + 360.0, 180.0, re.getMinX(), re.getMaxX(), re.getCoordinateReferenceSystem()));
                }
                if (re.getMaxY() > 180.0) {
                    envelopes.add(new ReferencedEnvelope(-180.0, re.getMaxY() - 360.0, re.getMinX(), re.getMaxX(), re.getCoordinateReferenceSystem()));
                }
            } else {
                if (re.getMinX() >= -180.0 && re.getMaxX() <= 180.0) {
                    return Collections.singletonList(this.transformEnvelope(this.renderingEnvelope, this.sourceCRS));
                }
                if (re.getMinX() < -180.0) {
                    envelopes.add(new ReferencedEnvelope(re.getMinX() + 360.0, 180.0, re.getMinY(), re.getMaxY(), re.getCoordinateReferenceSystem()));
                }
                if (re.getMaxX() > 180.0) {
                    envelopes.add(new ReferencedEnvelope(-180.0, re.getMaxX() - 360.0, re.getMinY(), re.getMaxY(), re.getCoordinateReferenceSystem()));
                }
            }
            this.mergeEnvelopes(envelopes);
            this.reprojectEnvelopes(this.sourceCRS, envelopes);
            return envelopes;
        }
        ReferencedEnvelope re = this.transformEnvelope(this.renderingEnvelope, (CoordinateReferenceSystem)DefaultGeographicCRS.WGS84);
        if (re.getMinX() >= -180.0 && re.getMaxX() <= 180.0) {
            return Collections.singletonList(this.transformEnvelope(this.renderingEnvelope, this.sourceCRS));
        }
        ArrayList<ReferencedEnvelope> envelopes = new ArrayList<ReferencedEnvelope>();
        envelopes.add(re);
        if (re.getMinX() < -180.0) {
            envelopes.add(new ReferencedEnvelope(re.getMinX() + 360.0, 180.0, re.getMinY(), re.getMaxY(), re.getCoordinateReferenceSystem()));
        }
        if (re.getMaxX() > 180.0) {
            envelopes.add(new ReferencedEnvelope(-180.0, re.getMaxX() - 360.0, re.getMinY(), re.getMaxY(), re.getCoordinateReferenceSystem()));
        }
        this.mergeEnvelopes(envelopes);
        this.reprojectEnvelopes(this.sourceCRS, envelopes);
        return envelopes;
    }

    private ReferencedEnvelope transformEnvelope(ReferencedEnvelope envelope, CoordinateReferenceSystem targetCRS) throws TransformException, FactoryException {
        try {
            return envelope.transform(targetCRS, true, 10);
        }
        catch (Exception e) {
            GeographicBoundingBox bbox;
            LOGGER.fine("Failed to reproject the envelope " + envelope + " to " + targetCRS + " trying an area restriction");
            ReferencedEnvelope envWGS84 = envelope.transform((CoordinateReferenceSystem)DefaultGeographicCRS.WGS84, true);
            ProjectionHandler handler = ProjectionHandlerFinder.getHandler(envelope, envelope.getCoordinateReferenceSystem(), false);
            if (handler != null && handler.validAreaBounds != null) {
                Envelope intersection = envWGS84.intersection(this.validAreaBounds);
                if (intersection.isNull()) {
                    return null;
                }
                try {
                    return ReferencedEnvelope.reference(intersection).transform(targetCRS, true);
                }
                catch (Exception e2) {
                    LOGGER.fine("Failed to reproject the restricted envelope " + intersection + " to " + targetCRS);
                }
            }
            if ((bbox = CRS.getGeographicBoundingBox((CoordinateReferenceSystem)targetCRS)) != null) {
                ReferencedEnvelope restriction = new ReferencedEnvelope(bbox.getEastBoundLongitude(), bbox.getWestBoundLongitude(), bbox.getSouthBoundLatitude(), bbox.getNorthBoundLatitude(), (CoordinateReferenceSystem)DefaultGeographicCRS.WGS84);
                Envelope intersection = envWGS84.intersection(restriction);
                if (intersection.isNull()) {
                    return null;
                }
                try {
                    return ReferencedEnvelope.reference(intersection).transform(targetCRS, true);
                }
                catch (Exception e2) {
                    LOGGER.fine("Failed to reproject the restricted envelope " + intersection + " to " + targetCRS);
                }
            }
            throw new TransformException("All attemptsto reproject the envelope " + envelope + " to " + targetCRS + " failed");
        }
    }

    private void reprojectEnvelopes(CoordinateReferenceSystem queryCRS, List<ReferencedEnvelope> envelopes) throws TransformException, FactoryException {
        for (int i = 0; i < envelopes.size(); ++i) {
            envelopes.set(i, this.transformEnvelope(envelopes.get(i), queryCRS));
        }
    }

    private void mergeEnvelopes(List<ReferencedEnvelope> envelopes) {
        boolean merged = true;
        while (merged && envelopes.size() > 1) {
            merged = false;
            for (int i = 0; i < envelopes.size() - 1; ++i) {
                ReferencedEnvelope curr = envelopes.get(i);
                int j = i + 1;
                while (j < envelopes.size()) {
                    ReferencedEnvelope next = envelopes.get(j);
                    if (curr.intersects(next)) {
                        curr.expandToInclude(next);
                        envelopes.remove(j);
                        merged = true;
                        continue;
                    }
                    ++j;
                }
            }
        }
    }

    public boolean requiresProcessing(Geometry geometry) {
        if (this.validAreaBounds == null) {
            return false;
        }
        return !CRS.equalsIgnoreMetadata((Object)this.sourceCRS, (Object)this.renderingEnvelope.getCoordinateReferenceSystem());
    }

    public Geometry preProcess(Geometry geometry) throws TransformException, FactoryException {
        Geometry mask;
        if (this.validAreaBounds == null) {
            return geometry;
        }
        SingleCRS geometryCRS = CRS.getHorizontalCRS((CoordinateReferenceSystem)this.sourceCRS);
        if (geometryCRS == null || CRS.equalsIgnoreMetadata((Object)geometryCRS, (Object)this.renderingEnvelope.getCoordinateReferenceSystem())) {
            return geometry;
        }
        if (this.validArea == null) {
            ReferencedEnvelope ge = new ReferencedEnvelope(geometry.getEnvelopeInternal(), (CoordinateReferenceSystem)geometryCRS);
            ReferencedEnvelope geWGS84 = ge.transform((CoordinateReferenceSystem)DefaultGeographicCRS.WGS84, true);
            if (this.validAreaBounds.contains(geWGS84)) {
                return geometry;
            }
            ReferencedEnvelope envIntWgs84 = new ReferencedEnvelope(this.validAreaBounds.intersection(geWGS84), (CoordinateReferenceSystem)DefaultGeographicCRS.WGS84);
            if (envIntWgs84.isEmpty()) {
                return null;
            }
            ReferencedEnvelope envInt = envIntWgs84.transform((CoordinateReferenceSystem)geometryCRS, true);
            mask = JTS.toGeometry((Envelope)envInt);
        } else {
            ReferencedEnvelope ge = new ReferencedEnvelope(geometry.getEnvelopeInternal(), (CoordinateReferenceSystem)geometryCRS);
            ReferencedEnvelope geWGS84 = ge.transform((CoordinateReferenceSystem)DefaultGeographicCRS.WGS84, true);
            ReferencedEnvelope envIntWgs84 = new ReferencedEnvelope(this.validAreaBounds.intersection(geWGS84), (CoordinateReferenceSystem)DefaultGeographicCRS.WGS84);
            if (envIntWgs84.isEmpty()) {
                return null;
            }
            Polygon polyIntWgs84 = JTS.toGeometry(envIntWgs84);
            Geometry maskWgs84 = this.intersect(this.validArea, polyIntWgs84);
            if (maskWgs84 == null || maskWgs84.isEmpty()) {
                return null;
            }
            mask = JTS.transform(maskWgs84, CRS.findMathTransform((CoordinateReferenceSystem)DefaultGeographicCRS.WGS84, (CoordinateReferenceSystem)geometryCRS));
        }
        return this.intersect(geometry, mask);
    }

    private Geometry intersect(Geometry geometry, Geometry mask) {
        Geometry result;
        try {
            result = geometry.intersection(mask);
        }
        catch (Exception e1) {
            try {
                result = EnhancedPrecisionOp.intersection(geometry, mask);
            }
            catch (Exception e2) {
                result = geometry;
            }
        }
        if (result instanceof GeometryCollection && ((GeometryCollection)result).isEmpty()) {
            return null;
        }
        return result;
    }

    public MathTransform getRenderingTransform(MathTransform mt) throws FactoryException {
        ArrayList<MathTransform> elements = new ArrayList<MathTransform>();
        this.accumulateTransforms(mt, elements);
        ArrayList<MathTransform> wrapped = new ArrayList<MathTransform>();
        ArrayList<MathTransform> datumShiftChain = null;
        boolean datumShiftDetected = false;
        for (MathTransform element : elements) {
            if (datumShiftChain != null) {
                datumShiftChain.add(element);
                if (!element.getClass().getName().equals(GeocentricTransform.class.getName() + "$Inverse")) continue;
                datumShiftDetected = true;
                MathTransform combined = this.concatenateTransforms(datumShiftChain);
                GeographicOffsetWrapper wrapper = new GeographicOffsetWrapper(combined);
                wrapped.add(wrapper);
                datumShiftChain = null;
                continue;
            }
            if (element instanceof GeocentricTransform) {
                datumShiftChain = new ArrayList<MathTransform>();
                datumShiftChain.add(element);
                continue;
            }
            wrapped.add(element);
        }
        if (datumShiftDetected) {
            if (datumShiftChain != null) {
                wrapped.addAll(datumShiftChain);
            }
            return this.concatenateTransforms(wrapped);
        }
        return mt;
    }

    private MathTransform concatenateTransforms(List<MathTransform> datumShiftChain) {
        if (datumShiftChain.size() == 1) {
            return datumShiftChain.get(0);
        }
        MathTransform mt = ConcatenatedTransform.create((MathTransform)datumShiftChain.get(0), (MathTransform)datumShiftChain.get(1));
        for (int i = 2; i < datumShiftChain.size(); ++i) {
            MathTransform curr = datumShiftChain.get(i);
            mt = ConcatenatedTransform.create((MathTransform)mt, (MathTransform)curr);
        }
        return mt;
    }

    private void accumulateTransforms(MathTransform mt, List<MathTransform> elements) {
        if (mt instanceof ConcatenatedTransform) {
            ConcatenatedTransform ct = (ConcatenatedTransform)mt;
            this.accumulateTransforms(ct.transform1, elements);
            this.accumulateTransforms(ct.transform2, elements);
        } else {
            elements.add(mt);
        }
    }

    public Geometry postProcess(MathTransform mt, Geometry geometry) {
        return geometry;
    }
}

