/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.shef.wit.simmetrics.similaritymetrics;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashSet;
import uk.ac.shef.wit.simmetrics.similaritymetrics.AbstractStringMetric;
import uk.ac.shef.wit.simmetrics.tokenisers.InterfaceTokeniser;
import uk.ac.shef.wit.simmetrics.tokenisers.TokeniserWhitespace;

public final class OverlapCoefficient
extends AbstractStringMetric
implements Serializable {
    private final float ESTIMATEDTIMINGCONST = 1.4E-4f;
    private final InterfaceTokeniser tokeniser;

    public OverlapCoefficient() {
        this.tokeniser = new TokeniserWhitespace();
    }

    public OverlapCoefficient(InterfaceTokeniser tokeniserToUse) {
        this.tokeniser = tokeniserToUse;
    }

    @Override
    public String getShortDescriptionString() {
        return "OverlapCoefficient";
    }

    @Override
    public String getLongDescriptionString() {
        return "Implements the Overlap Coefficient algorithm providing a similarity measure between two string where it is determined to what degree a string is a subset of another";
    }

    @Override
    public String getSimilarityExplained(String string1, String string2) {
        return null;
    }

    @Override
    public float getSimilarityTimingEstimated(String string1, String string2) {
        float str1Tokens = this.tokeniser.tokenizeToArrayList(string1).size();
        float str2Tokens = this.tokeniser.tokenizeToArrayList(string2).size();
        return str1Tokens * str2Tokens * 1.4E-4f;
    }

    @Override
    public float getSimilarity(String string1, String string2) {
        ArrayList<String> str1Tokens = this.tokeniser.tokenizeToArrayList(string1);
        ArrayList<String> str2Tokens = this.tokeniser.tokenizeToArrayList(string2);
        HashSet<String> allTokens = new HashSet<String>();
        allTokens.addAll(str1Tokens);
        int termsInString1 = allTokens.size();
        HashSet<String> secondStringTokens = new HashSet<String>();
        secondStringTokens.addAll(str2Tokens);
        int termsInString2 = secondStringTokens.size();
        allTokens.addAll(secondStringTokens);
        int commonTerms = termsInString1 + termsInString2 - allTokens.size();
        return (float)commonTerms / (float)Math.min(termsInString1, termsInString2);
    }

    @Override
    public float getUnNormalisedSimilarity(String string1, String string2) {
        return this.getSimilarity(string1, string2);
    }
}

