/*
 * Decompiled with CFR 0.152.
 */
package com.mockrunner.mock.web;

import com.mockrunner.mock.web.MockRequestDispatcher;
import com.mockrunner.util.common.ArrayUtil;
import com.mockrunner.util.common.StreamUtil;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Vector;
import javax.servlet.RequestDispatcher;
import javax.servlet.Servlet;
import javax.servlet.ServletContext;
import javax.servlet.ServletContextAttributeEvent;
import javax.servlet.ServletContextAttributeListener;
import javax.servlet.ServletException;

public class MockServletContext
implements ServletContext {
    private Map attributes;
    private Map requestDispatchers;
    private Map subContexts;
    private Map initParameters;
    private Map mimeTypes;
    private Map realPaths;
    private Map resources;
    private Map resourcePaths;
    private Map resourceStreams;
    private String servletContextName;
    private List attributeListener;

    public MockServletContext() {
        this.resetAll();
    }

    public synchronized void resetAll() {
        this.attributes = new HashMap();
        this.requestDispatchers = new HashMap();
        this.subContexts = new HashMap();
        this.initParameters = new HashMap();
        this.mimeTypes = new HashMap();
        this.realPaths = new HashMap();
        this.resources = new HashMap();
        this.resourcePaths = new HashMap();
        this.resourceStreams = new HashMap();
        this.attributeListener = new ArrayList();
    }

    public synchronized void addAttributeListener(ServletContextAttributeListener servletContextAttributeListener) {
        this.attributeListener.add(servletContextAttributeListener);
    }

    public synchronized void clearAttributes() {
        this.attributes.clear();
    }

    public synchronized Object getAttribute(String string) {
        return this.attributes.get(string);
    }

    public synchronized Enumeration getAttributeNames() {
        Vector vector = new Vector(this.attributes.keySet());
        return vector.elements();
    }

    public synchronized void removeAttribute(String string) {
        Object v = this.attributes.get(string);
        this.attributes.remove(string);
        if (null != v) {
            this.callAttributeListenersRemovedMethod(string, v);
        }
    }

    public synchronized void setAttribute(String string, Object object) {
        Object v = this.attributes.get(string);
        if (null == object) {
            this.attributes.remove(string);
        } else {
            this.attributes.put(string, object);
        }
        this.handleAttributeListenerCalls(string, object, v);
    }

    public synchronized RequestDispatcher getNamedDispatcher(String string) {
        return this.getRequestDispatcher(string);
    }

    public synchronized RequestDispatcher getRequestDispatcher(String string) {
        RequestDispatcher requestDispatcher = (RequestDispatcher)this.requestDispatchers.get(string);
        if (null == requestDispatcher) {
            requestDispatcher = new MockRequestDispatcher();
            this.setRequestDispatcher(string, requestDispatcher);
        }
        return requestDispatcher;
    }

    public synchronized Map getRequestDispatcherMap() {
        return Collections.unmodifiableMap(this.requestDispatchers);
    }

    public synchronized void clearRequestDispatcherMap() {
        this.requestDispatchers.clear();
    }

    public synchronized void setRequestDispatcher(String string, RequestDispatcher requestDispatcher) {
        if (requestDispatcher instanceof MockRequestDispatcher) {
            ((MockRequestDispatcher)requestDispatcher).setPath(string);
        }
        this.requestDispatchers.put(string, requestDispatcher);
    }

    public synchronized ServletContext getContext(String string) {
        return (ServletContext)this.subContexts.get(string);
    }

    public synchronized void setContext(String string, ServletContext servletContext) {
        this.subContexts.put(string, servletContext);
    }

    public synchronized void clearInitParameters() {
        this.initParameters.clear();
    }

    public synchronized String getInitParameter(String string) {
        return (String)this.initParameters.get(string);
    }

    public synchronized void setInitParameter(String string, String string2) {
        this.initParameters.put(string, string2);
    }

    public synchronized Enumeration getInitParameterNames() {
        return new Vector(this.initParameters.keySet()).elements();
    }

    public synchronized int getMajorVersion() {
        return 2;
    }

    public synchronized int getMinorVersion() {
        return 3;
    }

    public synchronized String getMimeType(String string) {
        return (String)this.mimeTypes.get(string);
    }

    public synchronized void setMimeType(String string, String string2) {
        this.mimeTypes.put(string, string2);
    }

    public synchronized String getRealPath(String string) {
        return (String)this.realPaths.get(string);
    }

    public synchronized void setRealPath(String string, String string2) {
        this.realPaths.put(string, string2);
    }

    public synchronized URL getResource(String string) throws MalformedURLException {
        return (URL)this.resources.get(string);
    }

    public synchronized void setResource(String string, URL uRL) {
        this.resources.put(string, uRL);
    }

    public synchronized InputStream getResourceAsStream(String string) {
        byte[] byArray = (byte[])this.resourceStreams.get(string);
        if (null == byArray) {
            return null;
        }
        return new ByteArrayInputStream(byArray);
    }

    public synchronized void setResourceAsStream(String string, InputStream inputStream) {
        this.setResourceAsStream(string, StreamUtil.getStreamAsByteArray(inputStream));
    }

    public synchronized void setResourceAsStream(String string, byte[] byArray) {
        byte[] byArray2 = (byte[])ArrayUtil.copyArray(byArray);
        this.resourceStreams.put(string, byArray2);
    }

    public synchronized Set getResourcePaths(String string) {
        Set set = (Set)this.resourcePaths.get(string);
        if (null == set) {
            return null;
        }
        return Collections.unmodifiableSet(set);
    }

    public synchronized void addResourcePaths(String string, Collection collection) {
        HashSet hashSet = (HashSet)this.resourcePaths.get(string);
        if (null == hashSet) {
            hashSet = new HashSet();
            this.resourcePaths.put(string, hashSet);
        }
        hashSet.addAll(collection);
    }

    public synchronized void addResourcePath(String string, String string2) {
        ArrayList<String> arrayList = new ArrayList<String>();
        arrayList.add(string2);
        this.addResourcePaths(string, arrayList);
    }

    public synchronized String getServerInfo() {
        return "Mockrunner Server";
    }

    public synchronized Servlet getServlet(String string) throws ServletException {
        return null;
    }

    public synchronized String getServletContextName() {
        return this.servletContextName;
    }

    public synchronized void setServletContextName(String string) {
        this.servletContextName = string;
    }

    public synchronized Enumeration getServletNames() {
        return new Vector().elements();
    }

    public synchronized Enumeration getServlets() {
        return new Vector().elements();
    }

    public synchronized void log(Exception exception, String string) {
    }

    public synchronized void log(String string, Throwable throwable) {
    }

    public synchronized void log(String string) {
    }

    private synchronized void handleAttributeListenerCalls(String string, Object object, Object object2) {
        if (null != object2) {
            if (object != null) {
                this.callAttributeListenersReplacedMethod(string, object2);
            } else {
                this.callAttributeListenersRemovedMethod(string, object2);
            }
        } else if (object != null) {
            this.callAttributeListenersAddedMethod(string, object);
        }
    }

    private synchronized void callAttributeListenersAddedMethod(String string, Object object) {
        for (int i = 0; i < this.attributeListener.size(); ++i) {
            ServletContextAttributeEvent servletContextAttributeEvent = new ServletContextAttributeEvent((ServletContext)this, string, object);
            ((ServletContextAttributeListener)this.attributeListener.get(i)).attributeAdded(servletContextAttributeEvent);
        }
    }

    private synchronized void callAttributeListenersReplacedMethod(String string, Object object) {
        for (int i = 0; i < this.attributeListener.size(); ++i) {
            ServletContextAttributeEvent servletContextAttributeEvent = new ServletContextAttributeEvent((ServletContext)this, string, object);
            ((ServletContextAttributeListener)this.attributeListener.get(i)).attributeReplaced(servletContextAttributeEvent);
        }
    }

    private synchronized void callAttributeListenersRemovedMethod(String string, Object object) {
        for (int i = 0; i < this.attributeListener.size(); ++i) {
            ServletContextAttributeEvent servletContextAttributeEvent = new ServletContextAttributeEvent((ServletContext)this, string, object);
            ((ServletContextAttributeListener)this.attributeListener.get(i)).attributeRemoved(servletContextAttributeEvent);
        }
    }
}

