/*
 * Decompiled with CFR 0.152.
 */
package org.gbif.ecat.cfg;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import org.gbif.ecat.cfg.DataDirConfig;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DataDirConfigFactory {
    protected static final Logger log = LoggerFactory.getLogger(DataDirConfigFactory.class);
    private static final String PROPERTY_FILE = "application.properties";
    private static DataDirConfig ref;

    public static final DataDirConfig getDefault() {
        if (ref == null) {
            try {
                InputStream propStream = null;
                URL url = Thread.currentThread().getContextClassLoader().getResource(PROPERTY_FILE);
                if (url != null) {
                    log.info("Building DataDirConfig singleton from properties: " + url.toURI());
                    try {
                        propStream = url.openStream();
                        ref = new DataDirConfig(propStream);
                    }
                    catch (IOException e) {
                        log.warn("Error reading DataDirConfig properties", (Throwable)e);
                    }
                } else {
                    log.info("Couldn't find the application.properties resource for building a AppConfig singleton.");
                }
            }
            catch (Exception e) {
                throw new IllegalStateException("Cannot read application configuration application.properties", e);
            }
        }
        return ref;
    }

    public static void main(String[] args) {
        DataDirConfigFactory f = new DataDirConfigFactory();
        DataDirConfig cfg = f.getCfg();
        DataDirConfig cfg2 = DataDirConfigFactory.getDefault();
    }

    public final synchronized DataDirConfig getCfg() {
        if (ref == null) {
            try {
                InputStream propStream = null;
                URL url = this.getClass().getClassLoader().getResource(PROPERTY_FILE);
                if (url != null) {
                    try {
                        propStream = url.openStream();
                        log.info("Building DataDirConfig singleton from properties: " + url.toURI());
                        ref = new DataDirConfig(propStream);
                    }
                    catch (IOException e) {
                        log.warn("Error reading DataDirConfig properties", (Throwable)e);
                        ref = DataDirConfigFactory.getDefault();
                    }
                }
            }
            catch (Exception e) {
                throw new IllegalStateException("Cannot read application configuration application.properties", e);
            }
        }
        return ref;
    }
}

