/*
 * Decompiled with CFR 0.152.
 */
package org.gbif.crawler.util;

import freemarker.template.Configuration;
import freemarker.template.Template;
import freemarker.template.TemplateException;
import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TemplateUtils {
    private static final Logger LOG = LoggerFactory.getLogger(TemplateUtils.class);
    private static final Configuration CONFIGURATION = new Configuration();

    public static String getAndProcess(String location, Map<String, Object> parameters) throws IOException, TemplateException {
        Template template = TemplateUtils.getTemplate(location);
        return TemplateUtils.process(template, parameters);
    }

    public static Template getTemplate(String location) throws IOException {
        return CONFIGURATION.getTemplate(location);
    }

    public static String process(Template template, Map<String, Object> parameters) throws IOException, TemplateException {
        StringWriter writer = new StringWriter();
        template.process(parameters, (Writer)writer);
        return writer.toString();
    }

    private TemplateUtils() {
        throw new UnsupportedOperationException("Can't initialize class");
    }

    static {
        CONFIGURATION.setClassForTemplateLoading(TemplateUtils.class, "/");
    }
}

