/*
 * Decompiled with CFR 0.152.
 */
package org.gbif.api.vocabulary;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.gbif.api.vocabulary.NomenclaturalCode;

public enum Rank {
    DOMAIN("dom."),
    SUPERKINGDOM("superreg."),
    KINGDOM("reg."),
    SUBKINGDOM("subreg."),
    INFRAKINGDOM("infrareg."),
    SUPERPHYLUM("superphyl."),
    PHYLUM("phyl."),
    SUBPHYLUM("subphyl."),
    INFRAPHYLUM("infraphyl."),
    SUPERCLASS("supercl."),
    CLASS("cl."),
    SUBCLASS("subcl."),
    INFRACLASS("infracl."),
    PARVCLASS("parvcl."),
    SUPERLEGION("superleg."),
    LEGION("leg."),
    SUBLEGION("subleg."),
    INFRALEGION("infraleg."),
    SUPERCOHORT("supercohort"),
    COHORT("cohort"),
    SUBCOHORT("subcohort"),
    INFRACOHORT("infracohort"),
    MAGNORDER("magnord."),
    SUPERORDER("superord."),
    GRANDORDER("grandord."),
    ORDER("ord."),
    SUBORDER("subord."),
    INFRAORDER("infraord."),
    PARVORDER("parvord."),
    SUPERFAMILY("superfam."),
    FAMILY("fam."),
    SUBFAMILY("subfam."),
    INFRAFAMILY("infrafam."),
    SUPERTRIBE("supertrib."),
    TRIBE("trib."),
    SUBTRIBE("subtrib."),
    INFRATRIBE("infratrib."),
    SUPRAGENERIC_NAME("supragen."),
    GENUS("gen."),
    SUBGENUS("subgen."),
    INFRAGENUS("infragen."),
    SECTION("sect."),
    SUBSECTION("subsect."),
    SERIES("ser."),
    SUBSERIES("subser."),
    INFRAGENERIC_NAME("infrageneric"),
    SPECIES_AGGREGATE("agg."),
    SPECIES("sp."),
    INFRASPECIFIC_NAME("infrasp."),
    GREX("grex"),
    SUBSPECIES("subsp."),
    CULTIVAR_GROUP,
    CONVARIETY("convar."),
    INFRASUBSPECIFIC_NAME("infrasubsp."),
    PROLES("prol."),
    RACE("race"),
    NATIO("natio"),
    ABERRATION("ab."),
    MORPH("morph"),
    VARIETY("var."),
    SUBVARIETY("subvar."),
    FORM("f."),
    SUBFORM("subf."),
    PATHOVAR("pv."),
    BIOVAR("biovar"),
    CHEMOVAR("chemovar"),
    MORPHOVAR("morphovar"),
    PHAGOVAR("phagovar"),
    SEROVAR("serovar"),
    CHEMOFORM("chemoform"),
    FORMA_SPECIALIS("f.sp."),
    CULTIVAR("cv."),
    STRAIN("strain"),
    OTHER,
    UNRANKED;

    public static final List<Rank> LINNEAN_RANKS;
    public static final List<Rank> DWC_RANKS;
    private static final Set<Rank> UNCOMPARABLE_RANKS;
    private static final Set<Rank> LEGACY_RANKS;
    private static final Map<Rank, NomenclaturalCode> RANK2CODE;
    private final String marker;

    private Rank() {
        this(null);
    }

    private Rank(String marker) {
        this.marker = marker;
    }

    public String getMarker() {
        return this.marker;
    }

    public boolean isInfraspecific() {
        return this != SPECIES && this.isSpeciesOrBelow();
    }

    public boolean isInfrasubspecific() {
        return this.ordinal() > SUBSPECIES.ordinal() && this.notOtherOrUnknown();
    }

    public boolean isInfrageneric() {
        return this.ordinal() > GENUS.ordinal() && this.notOtherOrUnknown();
    }

    public boolean isLinnean() {
        for (Rank r : LINNEAN_RANKS) {
            if (r != this) continue;
            return true;
        }
        return false;
    }

    public boolean isSpeciesOrBelow() {
        return this.ordinal() >= SPECIES.ordinal() && this.notOtherOrUnknown();
    }

    public boolean notOtherOrUnknown() {
        return this != OTHER && this != UNRANKED;
    }

    public boolean isSuprageneric() {
        return this.ordinal() < GENUS.ordinal();
    }

    public boolean isSupraspecific() {
        return this.ordinal() < SPECIES.ordinal();
    }

    public boolean isUncomparable() {
        return UNCOMPARABLE_RANKS.contains((Object)this);
    }

    public boolean isLegacy() {
        return LEGACY_RANKS.contains((Object)this);
    }

    public NomenclaturalCode isRestrictedToCode() {
        return RANK2CODE.get((Object)this);
    }

    public boolean higherThan(Rank other) {
        return this.ordinal() < other.ordinal();
    }

    static {
        LINNEAN_RANKS = ImmutableList.of((Object)((Object)KINGDOM), (Object)((Object)PHYLUM), (Object)((Object)CLASS), (Object)((Object)ORDER), (Object)((Object)FAMILY), (Object)((Object)GENUS), (Object)((Object)SPECIES));
        DWC_RANKS = ImmutableList.of((Object)((Object)KINGDOM), (Object)((Object)PHYLUM), (Object)((Object)CLASS), (Object)((Object)ORDER), (Object)((Object)FAMILY), (Object)((Object)GENUS), (Object)((Object)SUBGENUS), (Object)((Object)SPECIES));
        UNCOMPARABLE_RANKS = ImmutableSet.of((Object)((Object)INFRAGENERIC_NAME), (Object)((Object)INFRASPECIFIC_NAME), (Object)((Object)INFRASUBSPECIFIC_NAME), (Object)((Object)OTHER), (Object)((Object)UNRANKED));
        LEGACY_RANKS = ImmutableSet.of((Object)((Object)MORPH), (Object)((Object)ABERRATION), (Object)((Object)NATIO), (Object)((Object)RACE), (Object)((Object)PROLES), (Object)((Object)CONVARIETY), (Object[])new Rank[0]);
        RANK2CODE = ImmutableMap.builder().put((Object)PARVCLASS, (Object)NomenclaturalCode.ZOOLOGICAL).put((Object)MAGNORDER, (Object)NomenclaturalCode.ZOOLOGICAL).put((Object)GRANDORDER, (Object)NomenclaturalCode.ZOOLOGICAL).put((Object)PARVORDER, (Object)NomenclaturalCode.ZOOLOGICAL).put((Object)SUPERLEGION, (Object)NomenclaturalCode.ZOOLOGICAL).put((Object)LEGION, (Object)NomenclaturalCode.ZOOLOGICAL).put((Object)SUBLEGION, (Object)NomenclaturalCode.ZOOLOGICAL).put((Object)INFRALEGION, (Object)NomenclaturalCode.ZOOLOGICAL).put((Object)SUPERCOHORT, (Object)NomenclaturalCode.ZOOLOGICAL).put((Object)COHORT, (Object)NomenclaturalCode.ZOOLOGICAL).put((Object)SUBCOHORT, (Object)NomenclaturalCode.ZOOLOGICAL).put((Object)INFRACOHORT, (Object)NomenclaturalCode.ZOOLOGICAL).put((Object)MORPH, (Object)NomenclaturalCode.ZOOLOGICAL).put((Object)ABERRATION, (Object)NomenclaturalCode.ZOOLOGICAL).put((Object)NATIO, (Object)NomenclaturalCode.ZOOLOGICAL).put((Object)RACE, (Object)NomenclaturalCode.BOTANICAL).put((Object)PROLES, (Object)NomenclaturalCode.BOTANICAL).put((Object)SECTION, (Object)NomenclaturalCode.BOTANICAL).put((Object)SUBSECTION, (Object)NomenclaturalCode.BOTANICAL).put((Object)SERIES, (Object)NomenclaturalCode.BOTANICAL).put((Object)SUBSERIES, (Object)NomenclaturalCode.BOTANICAL).put((Object)CULTIVAR, (Object)NomenclaturalCode.CULTIVARS).put((Object)CULTIVAR_GROUP, (Object)NomenclaturalCode.CULTIVARS).put((Object)CONVARIETY, (Object)NomenclaturalCode.CULTIVARS).put((Object)GREX, (Object)NomenclaturalCode.CULTIVARS).put((Object)PATHOVAR, (Object)NomenclaturalCode.BACTERIAL).put((Object)BIOVAR, (Object)NomenclaturalCode.BACTERIAL).put((Object)CHEMOVAR, (Object)NomenclaturalCode.BACTERIAL).put((Object)MORPHOVAR, (Object)NomenclaturalCode.BACTERIAL).put((Object)PHAGOVAR, (Object)NomenclaturalCode.BACTERIAL).put((Object)SEROVAR, (Object)NomenclaturalCode.BACTERIAL).put((Object)CHEMOFORM, (Object)NomenclaturalCode.BACTERIAL).put((Object)FORMA_SPECIALIS, (Object)NomenclaturalCode.BACTERIAL).build();
    }
}

