/*
 * Decompiled with CFR 0.152.
 */
package org.gbif.api.vocabulary;

import org.gbif.api.util.VocabularyUtils;

public enum Continent {
    AFRICA("Africa"),
    ANTARCTICA("Antarctica"),
    ASIA("Asia"),
    OCEANIA("Oceania"),
    EUROPE("Europe"),
    NORTH_AMERICA("North America"),
    SOUTH_AMERICA("South America");

    private final String title;

    private Continent(String title) {
        this.title = title;
    }

    public String getTitle() {
        return this.title;
    }

    public static Continent fromString(String continent) {
        try {
            return VocabularyUtils.lookupEnum(continent, Continent.class);
        }
        catch (IllegalArgumentException e) {
            return null;
        }
    }
}

