/*
 * Decompiled with CFR 0.152.
 */
package org.gbif.api.util.iterables;

import java.util.UUID;
import javax.annotation.Nullable;
import org.gbif.api.model.common.paging.PagingRequest;
import org.gbif.api.model.common.paging.PagingResponse;
import org.gbif.api.model.registry.Dataset;
import org.gbif.api.service.registry.InstallationService;
import org.gbif.api.util.iterables.DatasetBasePager;
import org.gbif.api.vocabulary.DatasetType;

public class InstallationPager
extends DatasetBasePager {
    private final InstallationService service;
    private final UUID installationKey;

    public InstallationPager(InstallationService service, UUID installationKey, @Nullable DatasetType type, int pageSize) {
        super(type, pageSize);
        this.service = service;
        this.installationKey = installationKey;
    }

    @Override
    PagingResponse<Dataset> nextPage(PagingRequest page) {
        return this.service.getHostedDatasets(this.installationKey, page);
    }
}

