/*
 * Decompiled with CFR 0.152.
 */
package org.gbif.api.util;

import com.google.common.base.Optional;
import com.google.common.base.Strings;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.reflect.ClassPath;
import java.util.Map;
import org.gbif.api.vocabulary.ContactType;
import org.gbif.api.vocabulary.EndpointType;
import org.gbif.api.vocabulary.IdentifierType;
import org.gbif.api.vocabulary.TechnicalInstallationType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class VocabularyUtils {
    private static final Logger LOG = LoggerFactory.getLogger(VocabularyUtils.class);

    public static ContactType parseContactType(String type) {
        return VocabularyUtils.lookupEnum(type, ContactType.class);
    }

    public static EndpointType parseEndpointType(String type) {
        return VocabularyUtils.lookupEnum(type, EndpointType.class);
    }

    public static IdentifierType parseIdentifierType(String type) {
        return VocabularyUtils.lookupEnum(type, IdentifierType.class);
    }

    public static TechnicalInstallationType parseTechnicalInstallationType(String type) {
        return VocabularyUtils.lookupEnum(type, TechnicalInstallationType.class);
    }

    public static <T extends Enum<?>> T lookupEnum(String name, Class<T> vocab) {
        if (Strings.isNullOrEmpty((String)name)) {
            return null;
        }
        String normedType = name.toUpperCase().replaceAll("[. _-]", "");
        Enum[] values = (Enum[])vocab.getEnumConstants();
        if (values != null) {
            for (Enum val : values) {
                String normedVal = val.name().toUpperCase().replaceAll("[. _-]", "");
                if (!normedType.equals(normedVal)) continue;
                return (T)val;
            }
        }
        throw new IllegalArgumentException("Cannot parse " + name + " into a known " + vocab.getSimpleName());
    }

    public static <T extends Enum<?>> Optional<T> lookup(String name, Class<T> vocab) {
        Object result = null;
        try {
            result = VocabularyUtils.lookupEnum(name, vocab);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        return Optional.fromNullable(result);
    }

    public static Class<? extends Enum<?>> lookupVocabulary(String fullyQualifiedClassName) {
        if (!Strings.isNullOrEmpty((String)fullyQualifiedClassName)) {
            try {
                Class<?> cl = Class.forName(fullyQualifiedClassName);
                if (Enum.class.isAssignableFrom(cl)) {
                    return cl;
                }
            }
            catch (Exception e) {
                throw new IllegalArgumentException("Unable to lookup the vocabulary: " + fullyQualifiedClassName, e);
            }
        }
        return null;
    }

    public static Map<String, Enum<?>[]> listEnumerations(String packageName) {
        try {
            ClassPath cp = ClassPath.from((ClassLoader)VocabularyUtils.class.getClassLoader());
            ImmutableMap.Builder builder = ImmutableMap.builder();
            ImmutableList infos = cp.getTopLevelClasses(packageName).asList();
            for (ClassPath.ClassInfo info : infos) {
                Class<Enum<?>> vocab = VocabularyUtils.lookupVocabulary(info.getName());
                if (vocab == null || vocab.getEnumConstants() == null) continue;
                builder.put((Object)info.getSimpleName(), vocab.getEnumConstants());
            }
            return builder.build();
        }
        catch (Exception e) {
            LOG.error("Unable to read the classpath for enumerations", (Throwable)e);
            return ImmutableMap.of();
        }
    }

    private VocabularyUtils() {
    }
}

