/*
 * Decompiled with CFR 0.152.
 */
package org.gbif.api.util;

import com.google.common.base.Joiner;
import com.google.common.base.Strings;
import com.google.common.collect.Maps;
import java.util.LinkedHashMap;
import javax.annotation.Nullable;
import javax.validation.constraints.NotNull;
import org.gbif.api.model.common.LinneanClassification;
import org.gbif.api.model.common.LinneanClassificationKeys;
import org.gbif.api.vocabulary.Rank;

public class ClassificationUtils {
    private static final Joiner JOINER = Joiner.on((String)", ").skipNulls();

    @Nullable
    public static String getHigherClassification(LinneanClassification lc) {
        return Strings.emptyToNull((String)JOINER.join((Object)lc.getKingdom(), (Object)lc.getPhylum(), new Object[]{lc.getClazz(), lc.getOrder(), lc.getFamily(), lc.getGenus()}));
    }

    @Nullable
    public static String getHigherRank(LinneanClassification lc, Rank rank) {
        switch (rank) {
            case KINGDOM: {
                return lc.getKingdom();
            }
            case PHYLUM: {
                return lc.getPhylum();
            }
            case CLASS: {
                return lc.getClazz();
            }
            case ORDER: {
                return lc.getOrder();
            }
            case FAMILY: {
                return lc.getFamily();
            }
            case GENUS: {
                return lc.getGenus();
            }
            case SUBGENUS: {
                return lc.getSubgenus();
            }
            case SPECIES: {
                return lc.getSpecies();
            }
        }
        return null;
    }

    public static void setHigherRank(LinneanClassification lc, Rank rank, String name) {
        switch (rank) {
            case KINGDOM: {
                lc.setKingdom(name);
                break;
            }
            case PHYLUM: {
                lc.setPhylum(name);
                break;
            }
            case CLASS: {
                lc.setClazz(name);
                break;
            }
            case ORDER: {
                lc.setOrder(name);
                break;
            }
            case FAMILY: {
                lc.setFamily(name);
                break;
            }
            case GENUS: {
                lc.setGenus(name);
                break;
            }
            case SUBGENUS: {
                lc.setSubgenus(name);
                break;
            }
            case SPECIES: {
                lc.setSpecies(name);
            }
        }
    }

    @NotNull
    public static <T extends LinneanClassification & LinneanClassificationKeys> LinkedHashMap<Integer, String> getHigherClassificationMap(T lc) {
        return ClassificationUtils.getHigherClassificationBaseMap(lc);
    }

    @NotNull
    public static <T extends LinneanClassification & LinneanClassificationKeys> LinkedHashMap<Integer, String> getHigherClassificationMap(T lc, int key, Integer parentKey, String parent) {
        LinkedHashMap<Integer, String> map = ClassificationUtils.getHigherClassificationBaseMap(lc);
        if (parentKey != null) {
            map.put(parentKey, parent);
        }
        map.remove(key);
        return map;
    }

    private static <T extends LinneanClassification & LinneanClassificationKeys> LinkedHashMap<Integer, String> getHigherClassificationBaseMap(T lc) {
        LinkedHashMap map = Maps.newLinkedHashMap();
        if (((LinneanClassificationKeys)lc).getKingdomKey() != null) {
            map.put(((LinneanClassificationKeys)lc).getKingdomKey(), lc.getKingdom());
        }
        if (((LinneanClassificationKeys)lc).getPhylumKey() != null) {
            map.put(((LinneanClassificationKeys)lc).getPhylumKey(), lc.getPhylum());
        }
        if (((LinneanClassificationKeys)lc).getClassKey() != null) {
            map.put(((LinneanClassificationKeys)lc).getClassKey(), lc.getClazz());
        }
        if (((LinneanClassificationKeys)lc).getOrderKey() != null) {
            map.put(((LinneanClassificationKeys)lc).getOrderKey(), lc.getOrder());
        }
        if (((LinneanClassificationKeys)lc).getFamilyKey() != null) {
            map.put(((LinneanClassificationKeys)lc).getFamilyKey(), lc.getFamily());
        }
        if (((LinneanClassificationKeys)lc).getGenusKey() != null) {
            map.put(((LinneanClassificationKeys)lc).getGenusKey(), lc.getGenus());
        }
        if (((LinneanClassificationKeys)lc).getSpeciesKey() != null) {
            map.put(((LinneanClassificationKeys)lc).getSpeciesKey(), lc.getSpecies());
        }
        return map;
    }

    @Nullable
    public static Integer getHigherRankKey(LinneanClassificationKeys lck, Rank rank) {
        switch (rank) {
            case KINGDOM: {
                return lck.getKingdomKey();
            }
            case PHYLUM: {
                return lck.getPhylumKey();
            }
            case CLASS: {
                return lck.getClassKey();
            }
            case ORDER: {
                return lck.getOrderKey();
            }
            case FAMILY: {
                return lck.getFamilyKey();
            }
            case GENUS: {
                return lck.getGenusKey();
            }
            case SUBGENUS: {
                return lck.getSubgenusKey();
            }
            case SPECIES: {
                return lck.getSpeciesKey();
            }
        }
        return null;
    }

    public static void setHigherRankKey(LinneanClassificationKeys lck, Rank rank, Integer usageKey) {
        switch (rank) {
            case KINGDOM: {
                lck.setKingdomKey(usageKey);
                break;
            }
            case PHYLUM: {
                lck.setPhylumKey(usageKey);
                break;
            }
            case CLASS: {
                lck.setClassKey(usageKey);
                break;
            }
            case ORDER: {
                lck.setOrderKey(usageKey);
                break;
            }
            case FAMILY: {
                lck.setFamilyKey(usageKey);
                break;
            }
            case GENUS: {
                lck.setGenusKey(usageKey);
                break;
            }
            case SUBGENUS: {
                lck.setSubgenusKey(usageKey);
                break;
            }
            case SPECIES: {
                lck.setSpeciesKey(usageKey);
            }
        }
    }

    public static <T extends LinneanClassification & LinneanClassificationKeys> void setHigherRank(T lc, Rank rank, String name, Integer usageKey) {
        ClassificationUtils.setHigherRank(lc, rank, name);
        ClassificationUtils.setHigherRankKey(lc, rank, usageKey);
    }

    public static boolean hasContent(LinneanClassification lc) {
        for (Rank qr : Rank.DWC_RANKS) {
            if (Strings.isNullOrEmpty((String)ClassificationUtils.getHigherRank(lc, qr))) continue;
            return true;
        }
        return false;
    }

    public static void copyLinneanClassificationKeys(LinneanClassificationKeys source, LinneanClassificationKeys target) {
        for (Rank r : Rank.DWC_RANKS) {
            ClassificationUtils.setHigherRankKey(target, r, source.getHigherRankKey(r));
        }
    }

    public static void copyLinneanClassification(LinneanClassification source, LinneanClassification target) {
        for (Rank r : Rank.DWC_RANKS) {
            ClassificationUtils.setHigherRank(target, r, source.getHigherRank(r));
        }
    }

    private ClassificationUtils() {
    }
}

