/*
 * Decompiled with CFR 0.152.
 */
package org.gbif.api.model.registry;

import com.google.common.base.Objects;
import com.google.common.collect.Lists;
import java.net.URI;
import java.util.Date;
import java.util.List;
import javax.annotation.Nullable;
import javax.validation.constraints.Min;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Null;
import javax.validation.constraints.Size;
import org.gbif.api.model.registry.LenientEquals;
import org.gbif.api.model.registry.MachineTag;
import org.gbif.api.model.registry.MachineTaggable;
import org.gbif.api.model.registry.PostPersist;
import org.gbif.api.model.registry.PrePersist;
import org.gbif.api.vocabulary.EndpointType;

public class Endpoint
implements MachineTaggable,
LenientEquals<Endpoint> {
    private Integer key;
    private EndpointType type;
    private URI url;
    private String description;
    private String createdBy;
    private String modifiedBy;
    private Date created;
    private Date modified;
    private List<MachineTag> machineTags = Lists.newArrayList();

    @Null(groups={PrePersist.class})
    @NotNull(groups={PostPersist.class})
    @Min(value=1L)
    public Integer getKey() {
        return this.key;
    }

    public void setKey(Integer key) {
        this.key = key;
    }

    @NotNull
    public EndpointType getType() {
        return this.type;
    }

    public void setType(EndpointType type) {
        this.type = type;
    }

    @Nullable
    public URI getUrl() {
        return this.url;
    }

    public void setUrl(URI url) {
        this.url = url;
    }

    @Nullable
    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    @Size(min=3)
    public String getCreatedBy() {
        return this.createdBy;
    }

    public void setCreatedBy(String createdBy) {
        this.createdBy = createdBy;
    }

    @Size(min=3)
    public String getModifiedBy() {
        return this.modifiedBy;
    }

    public void setModifiedBy(String modifiedBy) {
        this.modifiedBy = modifiedBy;
    }

    @Null(groups={PrePersist.class})
    @NotNull(groups={PostPersist.class})
    public Date getCreated() {
        return this.created;
    }

    public void setCreated(Date created) {
        this.created = created;
    }

    @Null(groups={PrePersist.class})
    @NotNull(groups={PostPersist.class})
    public Date getModified() {
        return this.modified;
    }

    public void setModified(Date modified) {
        this.modified = modified;
    }

    @Override
    public List<MachineTag> getMachineTags() {
        return this.machineTags;
    }

    @Override
    public void setMachineTags(List<MachineTag> machineTags) {
        this.machineTags = machineTags;
    }

    @Override
    public void addMachineTag(MachineTag machineTag) {
        this.machineTags.add(machineTag);
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.key, this.type, this.url, this.description, this.createdBy, this.modifiedBy, this.created, this.modified, this.machineTags});
    }

    public boolean equals(Object object) {
        if (object instanceof Endpoint) {
            Endpoint that = (Endpoint)object;
            return Objects.equal((Object)this.key, (Object)that.key) && Objects.equal((Object)((Object)this.type), (Object)((Object)that.type)) && Objects.equal((Object)this.url, (Object)that.url) && Objects.equal((Object)this.description, (Object)that.description) && Objects.equal((Object)this.createdBy, (Object)that.createdBy) && Objects.equal((Object)this.modifiedBy, (Object)that.modifiedBy) && Objects.equal((Object)this.created, (Object)that.created) && Objects.equal((Object)this.modified, (Object)that.modified) && Objects.equal(this.machineTags, that.machineTags);
        }
        return false;
    }

    public String toString() {
        return Objects.toStringHelper((Object)this).add("key", (Object)this.key).add("type", (Object)this.type).add("url", (Object)this.url).add("description", (Object)this.description).add("createdBy", (Object)this.createdBy).add("modifiedBy", (Object)this.modifiedBy).add("created", (Object)this.created).add("modified", (Object)this.modified).add("machineTags", this.machineTags).toString();
    }

    @Override
    public boolean lenientEquals(Endpoint other) {
        if (this == other) {
            return true;
        }
        return Objects.equal((Object)((Object)this.type), (Object)((Object)other.type)) && Objects.equal((Object)this.url, (Object)other.url) && Objects.equal((Object)this.description, (Object)other.description);
    }
}

