/*
 * Decompiled with CFR 0.152.
 */
package org.gbif.api.model.registry;

import com.google.common.base.Objects;
import com.google.common.base.Strings;
import com.google.common.collect.Lists;
import java.net.URI;
import java.util.Date;
import java.util.List;
import javax.annotation.Nullable;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Null;
import javax.validation.constraints.Size;
import org.gbif.api.model.registry.Address;
import org.gbif.api.model.registry.LenientEquals;
import org.gbif.api.model.registry.PostPersist;
import org.gbif.api.model.registry.PrePersist;
import org.gbif.api.vocabulary.ContactType;
import org.gbif.api.vocabulary.Country;

public class Contact
implements Address,
LenientEquals<Contact> {
    private Integer key;
    private ContactType type;
    private boolean primary;
    private List<String> userId = Lists.newArrayList();
    private String firstName;
    private String lastName;
    private List<String> position = Lists.newArrayList();
    private String description;
    private List<String> email = Lists.newArrayList();
    private List<String> phone = Lists.newArrayList();
    private List<URI> homepage = Lists.newArrayList();
    private String organization;
    private List<String> address = Lists.newArrayList();
    private String city;
    private String province;
    private Country country;
    private String postalCode;
    private String createdBy;
    private String modifiedBy;
    private Date created;
    private Date modified;

    @Null(groups={PrePersist.class})
    @NotNull(groups={PostPersist.class})
    public Integer getKey() {
        return this.key;
    }

    public void setKey(Integer key) {
        this.key = key;
    }

    @Nullable
    public ContactType getType() {
        return this.type;
    }

    public void setType(ContactType type) {
        this.type = type;
    }

    public boolean isPrimary() {
        return this.primary;
    }

    public void setPrimary(boolean primary) {
        this.primary = primary;
    }

    @Nullable
    public List<String> getUserId() {
        return this.userId;
    }

    public void setUserId(List<String> userId) {
        this.userId = userId;
    }

    public void addUserId(String userId) {
        this.userId.add(userId);
    }

    public void addUserId(String directory, String id) {
        if (!Strings.isNullOrEmpty((String)id)) {
            if (Strings.isNullOrEmpty((String)directory)) {
                this.userId.add(id);
            } else {
                URI dir = URI.create(directory);
                if (dir.isAbsolute()) {
                    String dir2 = dir.toString();
                    if (!dir2.endsWith("/") && !dir2.endsWith("=")) {
                        dir2 = dir2 + "/";
                    }
                    this.userId.add(dir2 + id);
                } else {
                    this.userId.add(dir + ":" + id);
                }
            }
        }
    }

    @Nullable
    @Size(min=1)
    public String getFirstName() {
        return this.firstName;
    }

    public void setFirstName(String firstName) {
        this.firstName = firstName;
    }

    @Nullable
    @Size(min=1)
    public String getLastName() {
        return this.lastName;
    }

    public void setLastName(String lastName) {
        this.lastName = lastName;
    }

    public List<String> getPosition() {
        return this.position;
    }

    public void setPosition(List<String> position) {
        this.position = position;
    }

    public void addPosition(String position) {
        this.position.add(position);
    }

    @Nullable
    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    @Override
    @Nullable
    public List<String> getEmail() {
        return this.email;
    }

    @Override
    public void setEmail(List<String> email) {
        this.email = email;
    }

    public void addEmail(String email) {
        this.email.add(email);
    }

    @Override
    @Nullable
    public List<String> getPhone() {
        return this.phone;
    }

    @Override
    public void setPhone(List<String> phone) {
        this.phone = phone;
    }

    public void addPhone(String phone) {
        this.phone.add(phone);
    }

    @Override
    public List<String> getAddress() {
        return this.address;
    }

    @Override
    public void setAddress(List<String> address) {
        this.address = address;
    }

    public void addAddress(String address) {
        this.address.add(address);
    }

    @Override
    public String getCity() {
        return this.city;
    }

    @Override
    public void setCity(String city) {
        this.city = city;
    }

    @Override
    public String getProvince() {
        return this.province;
    }

    @Override
    public void setProvince(String province) {
        this.province = province;
    }

    @Override
    public Country getCountry() {
        return this.country;
    }

    @Override
    public void setCountry(Country country) {
        this.country = country;
    }

    @Override
    public String getPostalCode() {
        return this.postalCode;
    }

    @Override
    public void setPostalCode(String postalCode) {
        this.postalCode = postalCode;
    }

    @Override
    @Nullable
    @Size(min=2)
    public String getOrganization() {
        return this.organization;
    }

    @Override
    public void setOrganization(String organization) {
        this.organization = organization;
    }

    @Override
    public List<URI> getHomepage() {
        return this.homepage;
    }

    @Override
    public void setHomepage(List<URI> homepage) {
        this.homepage = homepage;
    }

    public void addHomepage(URI homepage) {
        this.homepage.add(homepage);
    }

    @Size(min=3)
    public String getCreatedBy() {
        return this.createdBy;
    }

    public void setCreatedBy(String createdBy) {
        this.createdBy = createdBy;
    }

    @Size(min=3)
    public String getModifiedBy() {
        return this.modifiedBy;
    }

    public void setModifiedBy(String modifiedBy) {
        this.modifiedBy = modifiedBy;
    }

    @Null(groups={PrePersist.class})
    @NotNull(groups={PostPersist.class})
    public Date getCreated() {
        return this.created;
    }

    public void setCreated(Date created) {
        this.created = created;
    }

    @Null(groups={PrePersist.class})
    @NotNull(groups={PostPersist.class})
    public Date getModified() {
        return this.modified;
    }

    public void setModified(Date modified) {
        this.modified = modified;
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.key, this.type, this.primary, this.userId, this.firstName, this.lastName, this.position, this.description, this.email, this.phone, this.homepage, this.organization, this.address, this.city, this.province, this.country, this.postalCode, this.createdBy, this.modifiedBy, this.created, this.modified});
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object instanceof Contact) {
            Contact that = (Contact)object;
            return this.lenientEquals(that) && Objects.equal((Object)this.key, (Object)that.key) && Objects.equal((Object)this.primary, (Object)that.primary) && Objects.equal((Object)this.createdBy, (Object)that.createdBy) && Objects.equal((Object)this.modifiedBy, (Object)that.modifiedBy) && Objects.equal((Object)this.created, (Object)that.created) && Objects.equal((Object)this.modified, (Object)that.modified);
        }
        return false;
    }

    public String toString() {
        return Objects.toStringHelper((Object)this).add("key", (Object)this.key).add("type", (Object)this.type).add("primary", this.primary).add("userId", this.userId).add("firstName", (Object)this.firstName).add("lastName", (Object)this.lastName).add("position", this.position).add("description", (Object)this.description).add("email", this.email).add("phone", this.phone).add("homepage", this.homepage).add("organization", (Object)this.organization).add("address", this.address).add("city", (Object)this.city).add("province", (Object)this.province).add("country", (Object)this.country).add("postalCode", (Object)this.postalCode).add("createdBy", (Object)this.createdBy).add("modifiedBy", (Object)this.modifiedBy).add("created", (Object)this.created).add("modified", (Object)this.modified).toString();
    }

    @Override
    public boolean lenientEquals(Contact contact) {
        if (this == contact) {
            return true;
        }
        return Objects.equal((Object)((Object)this.type), (Object)((Object)contact.type)) && Objects.equal((Object)this.primary, (Object)contact.primary) && Objects.equal(this.userId, contact.userId) && Objects.equal((Object)this.firstName, (Object)contact.firstName) && Objects.equal((Object)this.lastName, (Object)contact.lastName) && Objects.equal(this.position, contact.position) && Objects.equal((Object)this.description, (Object)contact.description) && Objects.equal(this.email, contact.email) && Objects.equal(this.phone, contact.phone) && Objects.equal(this.homepage, contact.homepage) && Objects.equal((Object)this.organization, (Object)contact.organization) && Objects.equal(this.address, contact.address) && Objects.equal((Object)this.city, (Object)contact.city) && Objects.equal((Object)this.province, (Object)contact.province) && Objects.equal((Object)((Object)this.country), (Object)((Object)contact.country)) && Objects.equal((Object)this.postalCode, (Object)contact.postalCode);
    }
}

