/*
 * Decompiled with CFR 0.152.
 */
package org.gbif.api.model.occurrence.predicate;

import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import java.util.Collection;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Size;
import org.codehaus.jackson.annotate.JsonCreator;
import org.codehaus.jackson.annotate.JsonProperty;
import org.gbif.api.model.occurrence.predicate.Predicate;
import org.gbif.api.model.occurrence.search.OccurrenceSearchParameter;
import org.gbif.api.util.SearchTypeValidator;

public class InPredicate
implements Predicate {
    @NotNull
    private final OccurrenceSearchParameter key;
    @NotNull
    @Size(min=1)
    private final Collection<String> values;

    @JsonCreator
    public InPredicate(@JsonProperty(value="key") OccurrenceSearchParameter key, @JsonProperty(value="values") Collection<String> values) {
        Preconditions.checkNotNull((Object)key, (Object)"<key> may not be null");
        Preconditions.checkNotNull(values, (Object)"<values> may not be null");
        Preconditions.checkArgument((!values.isEmpty() ? 1 : 0) != 0, (Object)"<values> may not be empty");
        for (String value : values) {
            SearchTypeValidator.validate(key, value);
        }
        this.key = key;
        this.values = ImmutableList.copyOf(values);
    }

    public OccurrenceSearchParameter getKey() {
        return this.key;
    }

    public Collection<String> getValues() {
        return this.values;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof InPredicate)) {
            return false;
        }
        InPredicate that = (InPredicate)obj;
        return Objects.equal((Object)this.key, (Object)that.getKey()) && Objects.equal(this.values, that.getValues());
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.key, this.values});
    }

    public String toString() {
        return Objects.toStringHelper((Object)this).add("key", (Object)this.key).add("values", this.values).toString();
    }
}

