/*
 * Decompiled with CFR 0.152.
 */
package org.gbif.api.model.common;

import com.google.common.base.Objects;
import com.google.common.collect.Sets;
import java.util.Date;
import java.util.Set;
import javax.annotation.Nullable;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Pattern;
import javax.validation.constraints.Size;
import org.codehaus.jackson.annotate.JsonIgnore;
import org.gbif.api.vocabulary.UserRole;

public class User {
    private static final String EMAIL_PATTERN = "^[_A-Za-z0-9-\\+]+(\\.[_A-Za-z0-9-]+)*@[A-Za-z0-9-]+(\\.[A-Za-z0-9]+)*(\\.[A-Za-z]{2,})$";
    private Integer key;
    private String userName;
    private String firstName;
    private String lastName;
    private String email;
    private String passwordHash;
    private Set<UserRole> roles = Sets.newHashSet();
    private Date lastLogin;

    @NotNull
    public Integer getKey() {
        return this.key;
    }

    public void setKey(Integer key) {
        this.key = key;
    }

    @NotNull
    @Pattern(regexp="^[_A-Za-z0-9-\\+]+(\\.[_A-Za-z0-9-]+)*@[A-Za-z0-9-]+(\\.[A-Za-z0-9]+)*(\\.[A-Za-z]{2,})$")
    public String getEmail() {
        return this.email;
    }

    public void setEmail(String email) {
        this.email = email;
    }

    @Nullable
    public Date getLastLogin() {
        return this.lastLogin;
    }

    public void setLastLogin(Date lastLogin) {
        this.lastLogin = lastLogin;
    }

    @NotNull
    @Pattern(regexp="^[a-z0-9_.-]+$")
    @Size(min=3, max=64)
    public String getUserName() {
        return this.userName;
    }

    public void setUserName(String userName) {
        this.userName = userName;
    }

    @NotNull
    public String getFirstName() {
        return this.firstName;
    }

    public void setFirstName(String firstName) {
        this.firstName = firstName;
    }

    @NotNull
    public String getLastName() {
        return this.lastName;
    }

    public void setLastName(String lastName) {
        this.lastName = lastName;
    }

    @NotNull
    @JsonIgnore
    public String getName() {
        return this.firstName + " " + this.lastName;
    }

    public String getPasswordHash() {
        return this.passwordHash;
    }

    public void setPasswordHash(String passwordHash) {
        this.passwordHash = passwordHash;
    }

    @NotNull
    public Set<UserRole> getRoles() {
        return this.roles;
    }

    public void setRoles(Set<UserRole> roles) {
        this.roles = roles;
    }

    public void addRole(UserRole role) {
        this.roles.add(role);
    }

    public boolean hasRole(UserRole role) {
        return role != null && this.roles.contains((Object)role);
    }

    public boolean isAdmin() {
        return this.roles.contains((Object)UserRole.ADMIN);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof User)) {
            return false;
        }
        User that = (User)obj;
        return Objects.equal((Object)this.key, (Object)that.key) && Objects.equal((Object)this.userName, (Object)that.userName) && Objects.equal((Object)this.firstName, (Object)that.firstName) && Objects.equal((Object)this.lastName, (Object)that.lastName) && Objects.equal((Object)this.email, (Object)that.email) && Objects.equal(this.roles, that.roles) && Objects.equal((Object)this.lastLogin, (Object)that.lastLogin) && Objects.equal((Object)this.passwordHash, (Object)that.passwordHash);
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.key, this.userName, this.firstName, this.lastName, this.email, this.roles, this.lastLogin, this.passwordHash});
    }

    public String toString() {
        return Objects.toStringHelper((Object)this).add("key", (Object)this.key).add("accountName", (Object)this.userName).add("firstName", (Object)this.firstName).add("lastName", (Object)this.lastName).add("email", (Object)this.email).add("roles", this.roles).add("lastLogin", (Object)this.lastLogin).add("passwordHash", (Object)this.passwordHash).toString();
    }
}

