/*
 * Decompiled with CFR 0.152.
 */
package org.gbif.api.model.common;

import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import java.net.URI;
import javax.annotation.Nullable;
import javax.validation.constraints.NotNull;
import org.codehaus.jackson.annotate.JsonCreator;
import org.codehaus.jackson.annotate.JsonProperty;
import org.gbif.api.model.common.DoiStatus;

public class DoiData {
    private final DoiStatus status;
    private final URI target;

    @JsonCreator
    public DoiData(@JsonProperty(value="status") DoiStatus status, @JsonProperty(value="target") URI target) {
        this.status = (DoiStatus)((Object)Preconditions.checkNotNull((Object)((Object)status), (Object)"DOI status is required"));
        this.target = target;
    }

    public DoiData(String ezidStatus, URI target) {
        this.status = (DoiStatus)((Object)Preconditions.checkNotNull((Object)((Object)DoiStatus.fromString(ezidStatus))));
        this.target = target;
    }

    @NotNull
    public DoiStatus getStatus() {
        return this.status;
    }

    @Nullable
    public URI getTarget() {
        return this.target;
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.status, this.target});
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        DoiData other = (DoiData)obj;
        return Objects.equal((Object)((Object)this.status), (Object)((Object)other.status)) && Objects.equal((Object)this.target, (Object)other.target);
    }

    public String toString() {
        return Objects.toStringHelper((Object)this).add("status", (Object)this.status).add("target", (Object)this.target).toString();
    }
}

