/*
 * Decompiled with CFR 0.152.
 */
package org.gbif.api.model.common;

import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import java.io.IOException;
import java.net.URI;
import java.util.Objects;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.validation.constraints.NotNull;
import org.codehaus.jackson.JsonGenerator;
import org.codehaus.jackson.JsonParser;
import org.codehaus.jackson.map.DeserializationContext;
import org.codehaus.jackson.map.JsonDeserializer;
import org.codehaus.jackson.map.SerializerProvider;
import org.codehaus.jackson.map.annotate.JsonDeserialize;
import org.codehaus.jackson.map.annotate.JsonSerialize;
import org.codehaus.jackson.map.ser.std.SerializerBase;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@JsonSerialize(using=Serializer.class)
@JsonDeserialize(using=Deserializer.class)
public class DOI {
    private static final Logger LOG = LoggerFactory.getLogger(DOI.class);
    public static final String GBIF_PREFIX = "10.15468";
    public static final String TEST_PREFIX = "10.5072";
    private static final Pattern HTTP = Pattern.compile("^https?://(dx\\.)?doi\\.org/(urn:)?(doi:)?", 2);
    private static final Pattern PARSER = Pattern.compile("^(?:urn:)?(?:doi:)?(10(?:\\.[0-9]+)+)/(.+)$", 2);
    private static String RESOLVER = "http://doi.org/";
    private static String SCHEME = "doi:";
    private String prefix;
    private String suffix;

    public static boolean isParsable(String source) {
        if (!Strings.isNullOrEmpty((String)source)) {
            try {
                return PARSER.matcher(DOI.decodeUrl(source)).find();
            }
            catch (IllegalArgumentException iaEx) {
                LOG.debug("Can not decode URL from the following DOI: {}", (Object)source);
            }
        }
        return false;
    }

    public DOI() {
    }

    public DOI(String doi) {
        Preconditions.checkNotNull((Object)doi, (Object)"DOI required");
        Matcher m = PARSER.matcher(DOI.decodeUrl(doi));
        if (!m.find()) {
            throw new IllegalArgumentException(doi + " is not a valid DOI");
        }
        this.prefix = m.group(1).toLowerCase();
        this.suffix = m.group(2).toLowerCase();
    }

    public DOI(String prefix, String suffix) {
        this.prefix = ((String)Preconditions.checkNotNull((Object)prefix, (Object)"DOI prefix required")).toLowerCase();
        Preconditions.checkArgument((boolean)prefix.startsWith("10."));
        this.suffix = ((String)Preconditions.checkNotNull((Object)suffix, (Object)"DOI suffix required")).toLowerCase();
    }

    private static String decodeUrl(@NotNull String doi) {
        Matcher m = HTTP.matcher(doi);
        if (m.find()) {
            doi = m.replaceFirst("");
            return URI.create(doi).getPath();
        }
        return doi;
    }

    public String getPrefix() {
        return this.prefix;
    }

    public void setPrefix(String prefix) {
        this.prefix = prefix;
    }

    public String getSuffix() {
        return this.suffix;
    }

    public void setSuffix(String suffix) {
        this.suffix = suffix;
    }

    public URI getUrl() {
        return URI.create(RESOLVER + this.prefix + '/' + this.suffix);
    }

    public String getDoiName() {
        return this.prefix + '/' + this.suffix;
    }

    public String toString() {
        return SCHEME + this.prefix + '/' + this.suffix;
    }

    public int hashCode() {
        return Objects.hash(this.prefix, this.suffix);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        DOI other = (DOI)obj;
        return Objects.equals(this.prefix, other.prefix) && Objects.equals(this.suffix, other.suffix);
    }

    public static class Deserializer
    extends JsonDeserializer<DOI> {
        public DOI deserialize(JsonParser jp, DeserializationContext ctxt) throws IOException {
            if (jp != null && jp.getTextLength() > 0) {
                return new DOI(jp.getText());
            }
            return null;
        }
    }

    public static class Serializer
    extends SerializerBase<DOI> {
        public Serializer() {
            super(DOI.class);
        }

        public void serialize(DOI value, JsonGenerator jgen, SerializerProvider provider) throws IOException {
            jgen.writeString(value.toString());
        }
    }
}

