/*
 * Decompiled with CFR 0.152.
 */
package org.gbif.api.model.checklistbank.search;

import com.google.common.base.Objects;
import java.util.LinkedHashMap;
import javax.validation.constraints.NotNull;
import org.codehaus.jackson.annotate.JsonProperty;
import org.gbif.api.model.common.LinneanClassification;
import org.gbif.api.model.common.LinneanClassificationKeys;
import org.gbif.api.util.ClassificationUtils;
import org.gbif.api.vocabulary.Rank;
import org.gbif.api.vocabulary.TaxonomicStatus;

public class NameUsageSuggestResult
implements LinneanClassification,
LinneanClassificationKeys {
    private Integer key;
    private Integer nameKey;
    private String kingdom;
    private String phylum;
    @JsonProperty(value="class")
    private String clazz;
    private String order;
    private String family;
    private String genus;
    private String subgenus;
    private String species;
    private Integer kingdomKey;
    private Integer phylumKey;
    private Integer classKey;
    private Integer orderKey;
    private Integer familyKey;
    private Integer genusKey;
    private Integer subgenusKey;
    private Integer speciesKey;
    private String parent;
    private Integer parentKey;
    private Integer nubKey;
    private String scientificName;
    private String canonicalName;
    private Rank rank;
    private TaxonomicStatus status;

    public Integer getNameKey() {
        return this.nameKey;
    }

    public void setNameKey(Integer nameKey) {
        this.nameKey = nameKey;
    }

    public boolean isSynonym() {
        return this.status != null && this.status.isSynonym();
    }

    public String getScientificName() {
        return this.scientificName;
    }

    public void setScientificName(String scientificName) {
        this.scientificName = scientificName;
    }

    public TaxonomicStatus getStatus() {
        return this.status;
    }

    public void setStatus(TaxonomicStatus status) {
        this.status = status;
    }

    public Integer getNubKey() {
        return this.nubKey;
    }

    public void setNubKey(Integer nubKey) {
        this.nubKey = nubKey;
    }

    public Integer getKey() {
        return this.key;
    }

    @Override
    public String getKingdom() {
        return this.kingdom;
    }

    @Override
    public String getPhylum() {
        return this.phylum;
    }

    @Override
    public String getClazz() {
        return this.clazz;
    }

    @Override
    public String getOrder() {
        return this.order;
    }

    @Override
    public String getFamily() {
        return this.family;
    }

    @Override
    public String getGenus() {
        return this.genus;
    }

    @Override
    public String getSubgenus() {
        return this.subgenus;
    }

    @Override
    public String getSpecies() {
        return this.species;
    }

    @Override
    public Integer getKingdomKey() {
        return this.kingdomKey;
    }

    @Override
    public Integer getPhylumKey() {
        return this.phylumKey;
    }

    @Override
    public Integer getClassKey() {
        return this.classKey;
    }

    @Override
    public Integer getOrderKey() {
        return this.orderKey;
    }

    @Override
    public Integer getFamilyKey() {
        return this.familyKey;
    }

    @Override
    public Integer getGenusKey() {
        return this.genusKey;
    }

    @Override
    public Integer getSubgenusKey() {
        return this.subgenusKey;
    }

    @Override
    public Integer getSpeciesKey() {
        return this.speciesKey;
    }

    public String getCanonicalName() {
        return this.canonicalName;
    }

    public void setCanonicalName(String canonicalName) {
        this.canonicalName = canonicalName;
    }

    @Override
    public void setClassKey(Integer classKey) {
        this.classKey = classKey;
    }

    @Override
    public void setClazz(String clazz) {
        this.clazz = clazz;
    }

    @Override
    public void setFamily(String family) {
        this.family = family;
    }

    @Override
    public void setFamilyKey(Integer familyKey) {
        this.familyKey = familyKey;
    }

    @Override
    public void setGenus(String genus) {
        this.genus = genus;
    }

    @Override
    public void setGenusKey(Integer genusKey) {
        this.genusKey = genusKey;
    }

    public void setKey(Integer key) {
        this.key = key;
    }

    @Override
    public void setKingdom(String kingdom) {
        this.kingdom = kingdom;
    }

    @Override
    public void setKingdomKey(Integer kingdomKey) {
        this.kingdomKey = kingdomKey;
    }

    @Override
    public void setOrder(String order) {
        this.order = order;
    }

    @Override
    public void setOrderKey(Integer orderKey) {
        this.orderKey = orderKey;
    }

    @Override
    public void setPhylum(String phylum) {
        this.phylum = phylum;
    }

    @Override
    public void setPhylumKey(Integer phylumKey) {
        this.phylumKey = phylumKey;
    }

    @Override
    public void setSpecies(String species) {
        this.species = species;
    }

    @Override
    public void setSpeciesKey(Integer speciesKey) {
        this.speciesKey = speciesKey;
    }

    @Override
    public void setSubgenus(String subgenus) {
        this.subgenus = subgenus;
    }

    @Override
    public void setSubgenusKey(Integer subgenusKey) {
        this.subgenusKey = subgenusKey;
    }

    public String getParent() {
        return this.parent;
    }

    public Integer getParentKey() {
        return this.parentKey;
    }

    public void setParent(String parent) {
        this.parent = parent;
    }

    public void setParentKey(Integer parentKey) {
        this.parentKey = parentKey;
    }

    public Rank getRank() {
        return this.rank;
    }

    public void setRank(Rank rank) {
        this.rank = rank;
    }

    @Override
    public String getHigherRank(Rank rank) {
        return ClassificationUtils.getHigherRank(this, rank);
    }

    @Override
    public Integer getHigherRankKey(Rank rank) {
        return ClassificationUtils.getHigherRankKey(this, rank);
    }

    @NotNull
    public LinkedHashMap<Integer, String> getHigherClassificationMap() {
        return ClassificationUtils.getHigherClassificationMap(this, this.key, this.parentKey, this.parent);
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.key, this.nameKey, this.parentKey, this.parent, this.kingdom, this.phylum, this.clazz, this.order, this.family, this.genus, this.subgenus, this.species, this.kingdomKey, this.phylumKey, this.classKey, this.orderKey, this.familyKey, this.genusKey, this.subgenusKey, this.speciesKey, this.scientificName, this.canonicalName, this.rank, this.status, this.nubKey});
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        NameUsageSuggestResult other = (NameUsageSuggestResult)obj;
        return Objects.equal((Object)this.key, (Object)other.key) && Objects.equal((Object)this.nameKey, (Object)other.nameKey) && Objects.equal((Object)this.parentKey, (Object)other.parentKey) && Objects.equal((Object)this.parent, (Object)other.parent) && Objects.equal((Object)this.kingdom, (Object)other.kingdom) && Objects.equal((Object)this.phylum, (Object)other.phylum) && Objects.equal((Object)this.clazz, (Object)other.clazz) && Objects.equal((Object)this.order, (Object)other.order) && Objects.equal((Object)this.family, (Object)other.family) && Objects.equal((Object)this.genus, (Object)other.genus) && Objects.equal((Object)this.subgenus, (Object)other.subgenus) && Objects.equal((Object)this.species, (Object)other.species) && Objects.equal((Object)this.kingdomKey, (Object)other.kingdomKey) && Objects.equal((Object)this.phylumKey, (Object)other.phylumKey) && Objects.equal((Object)this.classKey, (Object)other.classKey) && Objects.equal((Object)this.orderKey, (Object)other.orderKey) && Objects.equal((Object)this.familyKey, (Object)other.familyKey) && Objects.equal((Object)this.genusKey, (Object)other.genusKey) && Objects.equal((Object)this.subgenusKey, (Object)other.subgenusKey) && Objects.equal((Object)this.speciesKey, (Object)other.speciesKey) && Objects.equal((Object)this.scientificName, (Object)other.scientificName) && Objects.equal((Object)this.canonicalName, (Object)other.canonicalName) && Objects.equal((Object)((Object)this.rank), (Object)((Object)other.rank)) && Objects.equal((Object)((Object)this.status), (Object)((Object)other.status)) && Objects.equal((Object)this.nubKey, (Object)other.nubKey);
    }

    public String toString() {
        return "NameUsageSearchResult{key=" + this.key + ", nameKey=" + this.nameKey + ", parentKey=" + this.parentKey + ", parent='" + this.parent + '\'' + ", kingdom='" + this.kingdom + '\'' + ", phylum='" + this.phylum + '\'' + ", clazz='" + this.clazz + '\'' + ", order='" + this.order + '\'' + ", family='" + this.family + '\'' + ", genus='" + this.genus + '\'' + ", subgenus='" + this.subgenus + '\'' + ", species='" + this.species + '\'' + ", kingdomKey=" + this.kingdomKey + ", phylumKey=" + this.phylumKey + ", classKey=" + this.classKey + ", orderKey=" + this.orderKey + ", familyKey=" + this.familyKey + ", genusKey=" + this.genusKey + ", subgenusKey=" + this.subgenusKey + ", speciesKey=" + this.speciesKey + ", scientificName='" + this.scientificName + '\'' + ", canonicalName='" + this.canonicalName + '\'' + ", rank=" + (Object)((Object)this.rank) + ", status=" + (Object)((Object)this.status) + ", nubKey=" + this.nubKey + '}';
    }
}

