/*
 * Decompiled with CFR 0.152.
 */
package org.gbif.api.model.checklistbank;

import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import com.google.common.collect.Maps;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import javax.validation.constraints.NotNull;
import org.codehaus.jackson.annotate.JsonAnyGetter;
import org.codehaus.jackson.annotate.JsonAnySetter;
import org.codehaus.jackson.annotate.JsonIgnore;
import org.codehaus.jackson.map.annotate.JsonDeserialize;
import org.codehaus.jackson.map.annotate.JsonSerialize;
import org.gbif.api.jackson.ExtensionKeyDeserializer;
import org.gbif.api.jackson.ExtensionSerializer;
import org.gbif.api.jackson.TermMapListDeserializer;
import org.gbif.api.jackson.TermMapListSerializer;
import org.gbif.api.vocabulary.Extension;
import org.gbif.dwc.terms.Term;
import org.gbif.dwc.terms.TermFactory;

public class VerbatimNameUsage {
    private Integer key;
    private Map<Term, String> fields = Maps.newHashMap();
    private Map<Extension, List<Map<Term, String>>> extensions = Maps.newHashMap();
    private Date lastCrawled;

    @NotNull
    public Integer getKey() {
        return this.key;
    }

    public void setKey(Integer key) {
        this.key = key;
    }

    @NotNull
    @JsonSerialize(keyUsing=ExtensionSerializer.class, contentUsing=TermMapListSerializer.class)
    @JsonDeserialize(keyUsing=ExtensionKeyDeserializer.class, contentUsing=TermMapListDeserializer.class)
    public Map<Extension, List<Map<Term, String>>> getExtensions() {
        return this.extensions;
    }

    public void setExtensions(Map<Extension, List<Map<Term, String>>> extensions) {
        this.extensions = extensions;
    }

    @NotNull
    @JsonIgnore
    public Map<Term, String> getFields() {
        return this.fields;
    }

    public void setFields(Map<Term, String> fields) {
        this.fields = fields;
    }

    @Nullable
    public Date getLastCrawled() {
        return this.lastCrawled == null ? null : new Date(this.lastCrawled.getTime());
    }

    public void setLastCrawled(@Nullable Date lastCrawled) {
        this.lastCrawled = lastCrawled == null ? null : new Date(lastCrawled.getTime());
    }

    @Nullable
    public String getCoreField(Term term) {
        Preconditions.checkNotNull((Object)term, (Object)"term can't be null");
        return this.fields.get(term);
    }

    public boolean hasCoreField(Term term) {
        Preconditions.checkNotNull((Object)term, (Object)"term can't be null");
        return !Strings.isNullOrEmpty((String)this.fields.get(term));
    }

    public boolean hasExtension(Extension extension) {
        return this.extensions.containsKey((Object)extension) && !this.extensions.get((Object)extension).isEmpty();
    }

    public boolean hasExtension(Term term) {
        Preconditions.checkNotNull((Object)term, (Object)"term can't be null");
        Extension ext = Extension.fromRowType(term.qualifiedName());
        return ext == null ? false : this.hasExtension(ext);
    }

    public void setCoreField(Term term, @Nullable String fieldValue) {
        Preconditions.checkNotNull((Object)term, (Object)"term can't be null");
        this.fields.put(term, fieldValue);
    }

    @JsonAnySetter
    private void addJsonVerbatimField(String key, String value) {
        Term t = TermFactory.instance().findTerm(key);
        this.fields.put(t, value);
    }

    @JsonAnyGetter
    private Map<String, String> jsonVerbatimFields() {
        HashMap extendedProps = Maps.newHashMap();
        for (Map.Entry<Term, String> prop : this.fields.entrySet()) {
            extendedProps.put(prop.getKey().qualifiedName(), prop.getValue());
        }
        return extendedProps;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof VerbatimNameUsage)) {
            return false;
        }
        VerbatimNameUsage that = (VerbatimNameUsage)object;
        return Objects.equal((Object)this.key, (Object)that.key) && Objects.equal(this.fields, that.fields) && Objects.equal(this.extensions, that.extensions) && Objects.equal((Object)this.lastCrawled, (Object)that.lastCrawled);
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.key, this.fields, this.extensions, this.lastCrawled});
    }

    public String toString() {
        return Objects.toStringHelper((Object)this).add("key", (Object)this.key).add("fields", this.fields).add("extensions", this.extensions).add("lastCrawled", (Object)this.lastCrawled).toString();
    }
}

