/*
 * Decompiled with CFR 0.152.
 */
package org.gbif.api.model.checklistbank;

import com.google.common.base.Objects;
import com.google.common.base.Strings;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.List;
import java.util.Map;
import org.codehaus.jackson.annotate.JsonIgnore;
import org.gbif.api.vocabulary.Language;

public class TableOfContents {
    private static final String DEFAULT_TOPIC = "general";
    private final Map<Language, Map<String, List<Integer>>> toc = Maps.newTreeMap();

    public void addDescription(int key, Language lang, String topic) {
        String string = topic = Strings.isNullOrEmpty((String)topic) ? DEFAULT_TOPIC : topic.toLowerCase().trim();
        if (lang == null) {
            lang = Language.ENGLISH;
        }
        if (!this.toc.containsKey((Object)lang)) {
            this.toc.put(lang, Maps.newTreeMap());
        }
        if (!this.toc.get((Object)lang).containsKey(topic)) {
            this.toc.get((Object)lang).put(topic, Lists.newArrayList());
        }
        this.toc.get((Object)lang).get(topic).add(key);
    }

    @JsonIgnore
    public boolean isEmpty() {
        return this.toc.isEmpty();
    }

    @JsonIgnore
    public List<Language> listLanguages() {
        return Lists.newArrayList(this.toc.keySet());
    }

    @JsonIgnore
    public Map<String, List<Integer>> listTopicEntries(Language lang) {
        if (this.toc.containsKey((Object)lang)) {
            return this.toc.get((Object)lang);
        }
        return Maps.newHashMap();
    }

    public Map<Language, Map<String, List<Integer>>> getToc() {
        return this.toc;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof TableOfContents)) {
            return false;
        }
        TableOfContents that = (TableOfContents)object;
        return Objects.equal(this.toc, that.toc);
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.toc});
    }

    public String toString() {
        return Objects.toStringHelper((Object)this).add("toc", this.toc).toString();
    }
}

