/*
 * Decompiled with CFR 0.152.
 */
package org.scale7.cassandra.pelops.pool;

import org.scale7.cassandra.pelops.Mutator;
import org.scale7.cassandra.pelops.RowDeletor;
import org.scale7.cassandra.pelops.Selector;
import org.scale7.cassandra.pelops.pool.IThriftPool;

public abstract class ThriftPoolBase
implements IThriftPool {
    @Override
    public Selector createSelector() {
        this.validateKeyspaceSet();
        return new Selector(this);
    }

    @Override
    public Mutator createMutator() {
        this.validateKeyspaceSet();
        return new Mutator(this);
    }

    @Override
    public Mutator createMutator(long timestamp) {
        return this.createMutator(timestamp, this.getOperandPolicy().isDeleteIfNull());
    }

    @Override
    public Mutator createMutator(long timestamp, int ttl) {
        return this.createMutator(timestamp, this.getOperandPolicy().isDeleteIfNull(), ttl);
    }

    @Override
    public Mutator createMutator(long timestamp, boolean deleteIfNull) {
        this.validateKeyspaceSet();
        return new Mutator(this, timestamp, deleteIfNull);
    }

    @Override
    public Mutator createMutator(long timestamp, boolean deleteIfNull, int ttl) {
        this.validateKeyspaceSet();
        return new Mutator(this, timestamp, this.getOperandPolicy().isDeleteIfNull(), ttl);
    }

    @Override
    public RowDeletor createRowDeletor() {
        this.validateKeyspaceSet();
        return new RowDeletor(this);
    }

    @Override
    public RowDeletor createRowDeletor(long timestamp) {
        this.validateKeyspaceSet();
        return new RowDeletor(this, timestamp);
    }

    private void validateKeyspaceSet() throws IllegalStateException {
        if (this.getKeyspace() == null && this.getKeyspace().isEmpty()) {
            throw new IllegalStateException("A keyspace must be provided in order to use this function.");
        }
    }
}

