/*
 * Decompiled with CFR 0.152.
 */
package org.scale7.cassandra.pelops.pool;

import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.scale7.cassandra.pelops.JmxMBeanManager;
import org.scale7.cassandra.pelops.pool.CommonsBackedPool;
import org.scale7.cassandra.pelops.pool.PooledNodeMBean;
import org.scale7.portability.SystemProxy;
import org.slf4j.Logger;

public class PooledNode
implements PooledNodeMBean {
    private static final Logger logger = SystemProxy.getLoggerFromFactory(CommonsBackedPool.class);
    private CommonsBackedPool pool;
    private String address;
    private CommonsBackedPool.INodeSuspensionState suspensionState;
    private final ReentrantReadWriteLock suspensionStateLock = new ReentrantReadWriteLock();
    private final Lock suspensionStateReadLock = this.suspensionStateLock.readLock();
    private final Lock suspensionStateWriteLock = this.suspensionStateLock.writeLock();
    private AtomicInteger suspensions;
    private AtomicInteger connectionsCorrupted;
    private AtomicInteger connectionsCreated;
    private AtomicInteger connectionsDestroyed;
    private AtomicInteger connectionsBorrowedTotal;
    private AtomicInteger connectionsReleasedTotal;

    PooledNode(CommonsBackedPool pool, String address) {
        this.pool = pool;
        this.address = address;
        this.suspensions = new AtomicInteger();
        this.connectionsCorrupted = new AtomicInteger();
        this.connectionsCreated = new AtomicInteger();
        this.connectionsDestroyed = new AtomicInteger();
        this.connectionsBorrowedTotal = new AtomicInteger();
        this.connectionsReleasedTotal = new AtomicInteger();
        String beanName = this.getMBeanName();
        if (JmxMBeanManager.getInstance().isRegistered(beanName)) {
            logger.warn("MBean '{}' is already registered, removing...", (Object)beanName);
            JmxMBeanManager.getInstance().unregisterMBean(beanName);
        }
        logger.info("Registering MBean '{}'...", (Object)beanName);
        JmxMBeanManager.getInstance().registerMBean(this, beanName);
    }

    public void decommission() {
        String beanName = this.getMBeanName();
        logger.info("Removing MBean '{}'...", (Object)beanName);
        if (JmxMBeanManager.getInstance().isRegistered(beanName)) {
            JmxMBeanManager.getInstance().unregisterMBean(beanName);
        }
    }

    @Override
    public String getAddress() {
        return this.address;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CommonsBackedPool.INodeSuspensionState getSuspensionState() {
        try {
            this.suspensionStateReadLock.lock();
            CommonsBackedPool.INodeSuspensionState iNodeSuspensionState = this.suspensionState;
            return iNodeSuspensionState;
        }
        finally {
            this.suspensionStateReadLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setSuspensionState(CommonsBackedPool.INodeSuspensionState suspensionState) {
        try {
            this.suspensionStateWriteLock.lock();
            this.suspensionState = suspensionState;
        }
        finally {
            this.suspensionStateWriteLock.unlock();
        }
    }

    void reportSuspension() {
        this.suspensions.incrementAndGet();
    }

    @Override
    public int getSuspensions() {
        return this.suspensions.get();
    }

    @Override
    public int getNumActive() {
        return this.pool.getUnderlyingPool().getNumActive((Object)this.address);
    }

    @Override
    public int getNumIdle() {
        return this.pool.getUnderlyingPool().getNumIdle((Object)this.address);
    }

    void reportConnectionCorrupted() {
        this.connectionsCorrupted.incrementAndGet();
    }

    @Override
    public int getConnectionsCorrupted() {
        return this.connectionsCorrupted.get();
    }

    void reportConnectionCreated() {
        this.connectionsCreated.incrementAndGet();
    }

    @Override
    public int getConnectionsCreated() {
        return this.connectionsCreated.get();
    }

    void reportConnectionDestroyed() {
        this.connectionsDestroyed.incrementAndGet();
    }

    @Override
    public int getConnectionsDestroyed() {
        return this.connectionsDestroyed.get();
    }

    void reportConnectionBorrowed() {
        this.connectionsBorrowedTotal.incrementAndGet();
    }

    @Override
    public int getConnectionsBorrowedTotal() {
        return this.connectionsBorrowedTotal.get();
    }

    void reportConnectionReleased() {
        this.connectionsReleasedTotal.incrementAndGet();
    }

    @Override
    public int getConnectionsReleasedTotal() {
        return this.connectionsReleasedTotal.get();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isSuspended() {
        try {
            this.suspensionStateReadLock.lock();
            CommonsBackedPool.INodeSuspensionState state = this.getSuspensionState();
            boolean bl = state != null && state.isSuspended();
            return bl;
        }
        finally {
            this.suspensionStateReadLock.unlock();
        }
    }

    @Override
    public void suspendIndefinetily() {
        this.setSuspensionState(TimeBasedSuspensionState.indefinetily());
        this.reportSuspension();
    }

    @Override
    public void suspendForMillis(long nodeSuspensionMillis) {
        this.setSuspensionState(TimeBasedSuspensionState.millisFromNow(nodeSuspensionMillis));
        this.reportSuspension();
    }

    @Override
    public void clearSuspensionState() {
        this.setSuspensionState(null);
    }

    private String getMBeanName() {
        return "com.scale7.cassandra.pelops.pool:type=PooledNode-" + this.pool.getKeyspace() + "-" + this.getAddress();
    }

    public static class TimeBasedSuspensionState
    implements CommonsBackedPool.INodeSuspensionState {
        private long suspendedUntil;

        private TimeBasedSuspensionState(long suspendedUntil) {
            this.suspendedUntil = suspendedUntil;
        }

        @Override
        public boolean isSuspended() {
            return this.suspendedUntil >= System.currentTimeMillis();
        }

        public static CommonsBackedPool.INodeSuspensionState millisFromNow(long millisFromNow) {
            return new TimeBasedSuspensionState(System.currentTimeMillis() + millisFromNow);
        }

        public static CommonsBackedPool.INodeSuspensionState indefinetily() {
            return new TimeBasedSuspensionState(Long.MAX_VALUE);
        }
    }
}

