/*
 * Decompiled with CFR 0.152.
 */
package org.scale7.cassandra.pelops;

import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import org.apache.cassandra.thrift.ConsistencyLevel;
import org.apache.cassandra.thrift.SlicePredicate;
import org.scale7.cassandra.pelops.Bytes;
import org.scale7.cassandra.pelops.Selector;

public abstract class RowIterator<E>
implements Iterator<Map.Entry<Bytes, List<E>>> {
    protected final Selector selector;
    protected final String columnFamily;
    protected Bytes startBeyondKey;
    protected final int batchSize;
    protected final SlicePredicate colPredicate;
    protected final ConsistencyLevel cLevel;
    private boolean isFirstBatch = true;
    private boolean isMoreToFetch = false;
    private Iterator<Map.Entry<Bytes, List<E>>> currentBatchIterator;

    protected RowIterator(Selector selector, String columnFamily, Bytes startBeyondKey, int batchSize, SlicePredicate colPredicate, ConsistencyLevel cLevel) {
        this.selector = selector;
        this.columnFamily = columnFamily;
        this.startBeyondKey = startBeyondKey;
        this.batchSize = batchSize;
        this.colPredicate = colPredicate;
        this.cLevel = cLevel;
    }

    private void fetchNextBatchInternal() {
        LinkedHashMap<Bytes, List<E>> batch = this.fetchNextBatch();
        boolean bl = this.isMoreToFetch = batch.size() == this.batchSize;
        if (this.isFirstBatch) {
            this.isFirstBatch = false;
        } else {
            batch.remove(this.startBeyondKey);
        }
        this.currentBatchIterator = batch.entrySet().iterator();
    }

    protected abstract LinkedHashMap<Bytes, List<E>> fetchNextBatch();

    @Override
    public boolean hasNext() {
        boolean isMoreInBatch;
        if (this.currentBatchIterator == null) {
            this.fetchNextBatchInternal();
        }
        if (!(isMoreInBatch = this.currentBatchIterator.hasNext()) && this.isMoreToFetch) {
            this.fetchNextBatchInternal();
            return this.hasNext();
        }
        return isMoreInBatch;
    }

    @Override
    public Map.Entry<Bytes, List<E>> next() {
        if (this.currentBatchIterator == null) {
            this.fetchNextBatchInternal();
        }
        Map.Entry<Bytes, List<E>> row = null;
        try {
            row = this.currentBatchIterator.next();
            if (row != null) {
                this.startBeyondKey = row.getKey();
            }
        }
        catch (NoSuchElementException e) {
            if (this.isMoreToFetch) {
                this.fetchNextBatchInternal();
                return this.next();
            }
            throw e;
        }
        return row;
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException();
    }
}

