/*
 * Decompiled with CFR 0.152.
 */
package org.scale7.cassandra.pelops;

import java.util.concurrent.ConcurrentHashMap;
import org.scale7.cassandra.pelops.Cluster;
import org.scale7.cassandra.pelops.ClusterManager;
import org.scale7.cassandra.pelops.ColumnFamilyManager;
import org.scale7.cassandra.pelops.KeyspaceManager;
import org.scale7.cassandra.pelops.Mutator;
import org.scale7.cassandra.pelops.OperandPolicy;
import org.scale7.cassandra.pelops.RowDeletor;
import org.scale7.cassandra.pelops.Selector;
import org.scale7.cassandra.pelops.pool.CommonsBackedPool;
import org.scale7.cassandra.pelops.pool.IThriftPool;
import org.scale7.portability.SystemProxy;
import org.slf4j.Logger;

public class Pelops {
    private static final Logger logger = SystemProxy.getLoggerFromFactory(Pelops.class);
    private static ConcurrentHashMap<String, IThriftPool> poolMap = new ConcurrentHashMap();

    public static void addPool(String poolName, Cluster cluster, String keyspace) {
        CommonsBackedPool pool = new CommonsBackedPool(cluster, keyspace);
        Pelops.addPool(poolName, pool);
    }

    public static void addPool(String poolName, Cluster cluster, String keyspace, CommonsBackedPool.Policy policy, OperandPolicy operandPolicy) {
        CommonsBackedPool pool = new CommonsBackedPool(cluster, keyspace, policy, operandPolicy);
        Pelops.addPool(poolName, pool);
    }

    public static void addPool(String poolName, IThriftPool thriftPool) {
        logger.info("Pelops adds new pool {}", (Object)poolName);
        poolMap.put(poolName, thriftPool);
    }

    public static void removePool(String poolName) {
        logger.info("Pelops removes pool {}", (Object)poolName);
        IThriftPool pool = poolMap.remove(poolName);
        if (pool != null) {
            pool.shutdown();
        }
    }

    public static void shutdown() {
        logger.info("Pelops starting to shutdown...");
        for (IThriftPool pool : poolMap.values()) {
            pool.shutdown();
        }
        logger.info("Pelops has shutdown");
    }

    public static Selector createSelector(String poolName) {
        return poolMap.get(poolName).createSelector();
    }

    public static Mutator createMutator(String poolName) {
        return poolMap.get(poolName).createMutator();
    }

    public static Mutator createMutator(String poolName, long timestamp) {
        return poolMap.get(poolName).createMutator(timestamp);
    }

    public static Mutator createMutator(String poolName, long timestamp, boolean deleteIfNull) {
        return poolMap.get(poolName).createMutator(timestamp, deleteIfNull);
    }

    public static RowDeletor createRowDeletor(String poolName) {
        return poolMap.get(poolName).createRowDeletor();
    }

    public static RowDeletor createRowDeletor(String poolName, long timestamp) {
        return poolMap.get(poolName).createRowDeletor(timestamp);
    }

    public static ClusterManager createClusterManager(Cluster cluster) {
        return new ClusterManager(cluster);
    }

    public static KeyspaceManager createKeyspaceManager(Cluster cluster) {
        return new KeyspaceManager(cluster);
    }

    public static ColumnFamilyManager createColumnFamilyManager(Cluster cluster, String keyspace) {
        return new ColumnFamilyManager(cluster, keyspace);
    }

    public static IThriftPool getDbConnPool(String poolName) {
        return poolMap.get(poolName);
    }
}

