/*
 * Decompiled with CFR 0.152.
 */
package org.scale7.cassandra.pelops;

import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import org.apache.cassandra.thrift.ConsistencyLevel;
import org.scale7.cassandra.pelops.Bytes;
import org.scale7.cassandra.pelops.Selector;

public abstract class PageOfIterator<E>
implements Iterator<E> {
    protected final Selector selector;
    protected final String columnFamily;
    protected final Bytes rowKey;
    protected final boolean reversed;
    protected final int batchSize;
    protected final ConsistencyLevel cLevel;
    protected Bytes startBeyondName;
    private boolean isMoreToFetch = false;
    private Iterator<E> currentBatchIterator;

    public PageOfIterator(Selector selector, String columnFamily, Bytes rowKey, Bytes startBeyondName, boolean reversed, int batchSize, ConsistencyLevel cLevel) {
        this.batchSize = batchSize;
        this.rowKey = rowKey;
        this.cLevel = cLevel;
        this.reversed = reversed;
        this.columnFamily = columnFamily;
        this.startBeyondName = startBeyondName;
        this.selector = selector;
    }

    private void fetchNextBatchInternal() {
        List<E> batch = this.fetchNextBatch();
        this.currentBatchIterator = batch.iterator();
        this.startBeyondName = this.nextStartBeyondName(batch);
        this.isMoreToFetch = batch.size() == this.batchSize;
    }

    protected abstract List<E> fetchNextBatch();

    protected abstract Bytes nextStartBeyondName(List<E> var1);

    @Override
    public boolean hasNext() {
        boolean isMoreInBatch;
        if (this.currentBatchIterator == null) {
            this.fetchNextBatchInternal();
        }
        if (!(isMoreInBatch = this.currentBatchIterator.hasNext()) && this.isMoreToFetch) {
            this.fetchNextBatchInternal();
            return this.hasNext();
        }
        return isMoreInBatch;
    }

    @Override
    public E next() {
        if (this.currentBatchIterator == null) {
            this.fetchNextBatchInternal();
        }
        E column = null;
        try {
            column = this.currentBatchIterator.next();
        }
        catch (NoSuchElementException e) {
            if (this.isMoreToFetch) {
                this.fetchNextBatchInternal();
                return this.next();
            }
            throw e;
        }
        return column;
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException();
    }
}

