/*
 * Decompiled with CFR 0.152.
 */
package org.gbif.common.parsers.utils;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.HashSet;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class BlacklistedNames {
    private static final Logger LOGGER = LoggerFactory.getLogger(BlacklistedNames.class);
    private static final Set<String> NAMES = new HashSet<String>();
    private static final String BLACKLIST_FILE = "utils/blacklistedNames.txt";

    private BlacklistedNames() {
        throw new UnsupportedOperationException("Can't initialize class");
    }

    public static boolean contains(String s) {
        return NAMES.contains(s.toUpperCase());
    }

    public static synchronized void init(Reader reader) {
        NAMES.clear();
        BufferedReader br = new BufferedReader(reader);
        try {
            String line = br.readLine();
            while (line != null) {
                LOGGER.debug("Blacklisting: {}", (Object)line);
                NAMES.add(line.toUpperCase());
                line = br.readLine();
            }
        }
        catch (IOException e) {
            LOGGER.debug("Exception thrown", (Throwable)e);
        }
        finally {
            try {
                br.close();
            }
            catch (IOException iOException) {}
        }
    }

    public static synchronized void init(String filepath) {
        BlacklistedNames.init(new InputStreamReader(BlacklistedNames.class.getClassLoader().getResourceAsStream(filepath)));
    }

    static {
        BlacklistedNames.init(BLACKLIST_FILE);
    }
}

