/*
 * Decompiled with CFR 0.152.
 */
package org.gbif.common.parsers.date;

import com.google.common.base.Joiner;
import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import javax.annotation.Nullable;
import org.apache.commons.lang3.StringUtils;
import org.gbif.common.parsers.core.ParseResult;
import org.gbif.common.parsers.date.DateFormatHint;
import org.gbif.common.parsers.date.DateTimeMultiParser;
import org.gbif.common.parsers.date.DateTimeParser;
import org.gbif.common.parsers.date.DateTimeParserBuilder;
import org.gbif.common.parsers.date.DateTimeSeparatorNormalizer;
import org.gbif.common.parsers.date.TemporalParser;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.threeten.bp.LocalDate;
import org.threeten.bp.LocalDateTime;
import org.threeten.bp.Year;
import org.threeten.bp.YearMonth;
import org.threeten.bp.ZonedDateTime;
import org.threeten.bp.format.DateTimeFormatter;
import org.threeten.bp.format.DateTimeFormatterBuilder;
import org.threeten.bp.format.DateTimeParseException;
import org.threeten.bp.format.ResolverStyle;
import org.threeten.bp.format.SignStyle;
import org.threeten.bp.temporal.ChronoField;
import org.threeten.bp.temporal.TemporalAccessor;
import org.threeten.bp.temporal.TemporalField;
import org.threeten.bp.temporal.TemporalQuery;

class ThreeTenNumericalDateParser
implements TemporalParser {
    private static final Logger LOGGER = LoggerFactory.getLogger(ThreeTenNumericalDateParser.class);
    static final Pattern OPTIONAL_PATTERN_PART = Pattern.compile("\\[.*\\]");
    static final char CHAR_HYPHEN = '-';
    static final char CHAR_MINUS = '\u2212';
    private static final Map<DateFormatHint, List<DateTimeParser>> FORMATTERS_BY_HINT = Maps.newHashMap();
    private static final DateTimeFormatter ISO_PARSER = new DateTimeFormatterBuilder().appendValue((TemporalField)ChronoField.YEAR, 2, 4, SignStyle.NEVER).optionalStart().appendLiteral('-').appendValue((TemporalField)ChronoField.MONTH_OF_YEAR, 1, 2, SignStyle.NEVER).optionalStart().appendLiteral('-').appendValue((TemporalField)ChronoField.DAY_OF_MONTH, 1, 2, SignStyle.NEVER).optionalEnd().optionalEnd().toFormatter().withResolverStyle(ResolverStyle.STRICT);
    private static final List<DateTimeParser> BASE_PARSER_LIST = ImmutableList.copyOf(DateTimeParserBuilder.newParserListBuilder().appendDateTimeParser("uuuuMMdd", DateFormatHint.YMD).appendDateTimeParser("uuuu-M-d[ HH:mm:ss]", DateFormatHint.YMDT, String.valueOf('-'), String.valueOf('\u2212') + ".").appendDateTimeParser("uuuu-M-d'T'HH[:mm[:ss]]", DateFormatHint.YMDT).appendDateTimeParser("uuuu-M-d'T'HHmm[ss]", DateFormatHint.YMDT).appendDateTimeParser("uuuu-M-d'T'HH:mm:ssZ", DateFormatHint.YMDT).appendDateTimeParser("uuuu-M-d'T'HH:mm:ssxxx", DateFormatHint.YMDT).appendDateTimeParser("uuuu-M-d'T'HH:mm:ss'Z'", DateFormatHint.YMDT).appendDateTimeParser("uuuu-M", DateFormatHint.YM).appendDateTimeParser("uuuu", DateFormatHint.Y).appendDateTimeParser("uuuu\u5e74MM\u6708dd\u65e5", DateFormatHint.HAN).appendDateTimeParser("uuuu\u5e74M\u6708d\u65e5", DateFormatHint.HAN).appendDateTimeParser("uu\u5e74M\u6708d\u65e5", DateFormatHint.HAN).build());
    private static final List<DateTimeMultiParser> MULTIPARSER_PARSER_LIST = ImmutableList.of((Object)DateTimeParserBuilder.newMultiParserListBuilder().preferredDateTimeParser("d.M.uuuu", DateFormatHint.DMY).appendDateTimeParser("M.d.uuuu", DateFormatHint.MDY).build(), (Object)DateTimeParserBuilder.newMultiParserListBuilder().appendDateTimeParser("d/M/uuuu", DateFormatHint.DMY, "/", String.valueOf('-') + String.valueOf('\u2212')).appendDateTimeParser("M/d/uuuu", DateFormatHint.MDY, "/", String.valueOf('-') + String.valueOf('\u2212')).build(), (Object)DateTimeParserBuilder.newMultiParserListBuilder().appendDateTimeParser("ddMMuuuu", DateFormatHint.DMY).appendDateTimeParser("MMdduuuu", DateFormatHint.MDY).build(), (Object)DateTimeParserBuilder.newMultiParserListBuilder().appendDateTimeParser("d\\M\\uuuu", DateFormatHint.DMY, "\\", "_").appendDateTimeParser("M\\d\\uuuu", DateFormatHint.MDY, "\\", "_").build());
    private final Map<DateFormatHint, List<DateTimeParser>> activeFormattersByHint;
    private final List<DateTimeMultiParser> activeMultiParserList;

    public static ThreeTenNumericalDateParser newInstance() {
        return new ThreeTenNumericalDateParser();
    }

    public static ThreeTenNumericalDateParser newInstance(Year baseYear) {
        return new ThreeTenNumericalDateParser(baseYear);
    }

    private ThreeTenNumericalDateParser() {
        this.activeFormattersByHint = ImmutableMap.copyOf(FORMATTERS_BY_HINT);
        this.activeMultiParserList = MULTIPARSER_PARSER_LIST;
    }

    private ThreeTenNumericalDateParser(Year baseYear) {
        Preconditions.checkState((baseYear.getValue() <= LocalDate.now().getYear() ? 1 : 0) != 0, (Object)"Base year is less or equals to the current year");
        HashMap formattersByHint = Maps.newHashMap(FORMATTERS_BY_HINT);
        ArrayList multiParserList = Lists.newArrayList(MULTIPARSER_PARSER_LIST);
        multiParserList.addAll(Lists.newArrayList((Object[])new DateTimeMultiParser[]{DateTimeParserBuilder.newMultiParserListBuilder().preferredDateTimeParser("d.M.uu", DateFormatHint.DMY, baseYear).appendDateTimeParser("M.d.uu", DateFormatHint.MDY, baseYear).build(), DateTimeParserBuilder.newMultiParserListBuilder().appendDateTimeParser("d/M/uu", DateFormatHint.DMY, "/", String.valueOf('-') + String.valueOf('\u2212'), baseYear).appendDateTimeParser("M/d/uu", DateFormatHint.MDY, "/", String.valueOf('-') + String.valueOf('\u2212'), baseYear).build(), DateTimeParserBuilder.newMultiParserListBuilder().appendDateTimeParser("ddMMuu", DateFormatHint.DMY, baseYear).appendDateTimeParser("MMdduu", DateFormatHint.MDY, baseYear).build(), DateTimeParserBuilder.newMultiParserListBuilder().appendDateTimeParser("d\\M\\uu", DateFormatHint.DMY, "\\", "_", baseYear).appendDateTimeParser("M\\d\\uu", DateFormatHint.MDY, "\\", "_", baseYear).build()}));
        for (DateTimeMultiParser multiParser : multiParserList) {
            for (DateTimeParser parser : multiParser.getAllParsers()) {
                if (!formattersByHint.containsKey((Object)parser.getHint())) {
                    formattersByHint.put(parser.getHint(), new ArrayList());
                }
                ((List)formattersByHint.get((Object)parser.getHint())).add(parser);
            }
        }
        this.activeMultiParserList = ImmutableList.copyOf((Collection)multiParserList);
        this.activeFormattersByHint = ImmutableMap.copyOf((Map)formattersByHint);
    }

    @Override
    public ParseResult<TemporalAccessor> parse(String input) {
        return this.parse(input, DateFormatHint.NONE);
    }

    @Override
    public ParseResult<TemporalAccessor> parse(String input, @Nullable DateFormatHint hint) {
        if (StringUtils.isBlank((CharSequence)input)) {
            return ParseResult.fail();
        }
        if (hint == null) {
            hint = DateFormatHint.NONE;
        }
        List<DateTimeParser> parserList = this.activeFormattersByHint.containsKey((Object)hint) ? this.activeFormattersByHint.get((Object)hint) : BASE_PARSER_LIST;
        for (DateTimeParser parser : parserList) {
            TemporalAccessor parsedTemporalAccessor = parser.parse(input);
            if (parsedTemporalAccessor == null) continue;
            return ParseResult.success(ParseResult.CONFIDENCE.DEFINITE, parsedTemporalAccessor);
        }
        if (hint != DateFormatHint.NONE) {
            return ParseResult.fail();
        }
        int numberOfPossiblyAmbiguousMatch = 0;
        TemporalAccessor lastParsedSuccess = null;
        TemporalAccessor lastParsedPreferred = null;
        boolean lastParsedSuccessOtherResultsEqual = false;
        for (DateTimeMultiParser parserAmbiguity : this.activeMultiParserList) {
            DateTimeMultiParser.MultipleParseResult result = parserAmbiguity.parse(input);
            numberOfPossiblyAmbiguousMatch += result.getNumberParsed();
            if (result.getNumberParsed() <= 0) continue;
            lastParsedSuccess = result.getResult();
            if (lastParsedSuccessOtherResultsEqual) {
                LOGGER.warn("Issue with DateTimeMultiParser configuration: Input {} produces more results even if lastParsedSuccessEqual is set to true.", (Object)input);
            }
            lastParsedSuccessOtherResultsEqual = false;
            if (result.getPreferredResult() != null) {
                if (lastParsedPreferred != null) {
                    LOGGER.warn("Issue with DateTimeMultiParser configuration: Input {} produces 2 preferred results", (Object)input);
                }
                lastParsedPreferred = result.getPreferredResult();
                continue;
            }
            if (result.getOtherResults() == null || result.getOtherResults().size() <= 1) continue;
            lastParsedSuccessOtherResultsEqual = ThreeTenNumericalDateParser.allEquals(result.getOtherResults());
        }
        if (numberOfPossiblyAmbiguousMatch == 1) {
            return ParseResult.success(ParseResult.CONFIDENCE.DEFINITE, lastParsedSuccess);
        }
        if (numberOfPossiblyAmbiguousMatch > 1) {
            if (lastParsedSuccessOtherResultsEqual) {
                return ParseResult.success(ParseResult.CONFIDENCE.DEFINITE, lastParsedSuccess);
            }
            if (lastParsedPreferred != null) {
                return ParseResult.success(ParseResult.CONFIDENCE.PROBABLE, lastParsedPreferred);
            }
        }
        LOGGER.debug("Number of matches for {} : {}", (Object)input, (Object)numberOfPossiblyAmbiguousMatch);
        return ParseResult.fail();
    }

    @Override
    public ParseResult<TemporalAccessor> parse(@Nullable String year, @Nullable String month, @Nullable String day) {
        if (StringUtils.isBlank((CharSequence)month) && StringUtils.isNotBlank((CharSequence)day)) {
            return ParseResult.fail();
        }
        String date = Joiner.on((char)'-').skipNulls().join((Object)Strings.emptyToNull((String)year), (Object)Strings.emptyToNull((String)month), new Object[]{Strings.emptyToNull((String)day)});
        TemporalAccessor tp = ThreeTenNumericalDateParser.tryParse(date, ISO_PARSER, null);
        if (tp != null) {
            return ParseResult.success(ParseResult.CONFIDENCE.DEFINITE, tp);
        }
        return ParseResult.fail();
    }

    @Override
    public ParseResult<TemporalAccessor> parse(@Nullable Integer year, @Nullable Integer month, @Nullable Integer day) {
        if (month == null && day != null) {
            return ParseResult.fail();
        }
        String date = Joiner.on((char)'-').skipNulls().join((Object)year, (Object)month, new Object[]{day});
        TemporalAccessor tp = ThreeTenNumericalDateParser.tryParse(date, ISO_PARSER, null);
        if (tp != null) {
            return ParseResult.success(ParseResult.CONFIDENCE.DEFINITE, tp);
        }
        return ParseResult.fail();
    }

    private static TemporalAccessor tryParse(String input, DateTimeFormatter formatter, DateTimeSeparatorNormalizer normalizer) {
        if (normalizer != null) {
            input = normalizer.normalize(input);
        }
        try {
            return formatter.parseBest((CharSequence)input, new TemporalQuery[]{ZonedDateTime.FROM, LocalDateTime.FROM, LocalDate.FROM, YearMonth.FROM, Year.FROM});
        }
        catch (DateTimeParseException dateTimeParseException) {
            return null;
        }
    }

    private static boolean allEquals(List<TemporalAccessor> taList) {
        if (taList == null || taList.isEmpty()) {
            return false;
        }
        TemporalAccessor reference = null;
        boolean allEqual = false;
        for (TemporalAccessor ta : taList) {
            if (reference == null) {
                reference = ta;
            }
            allEqual = reference.equals(ta);
        }
        return allEqual;
    }

    static {
        for (DateTimeParser parser : BASE_PARSER_LIST) {
            if (!FORMATTERS_BY_HINT.containsKey((Object)parser.getHint())) {
                FORMATTERS_BY_HINT.put(parser.getHint(), new ArrayList());
            }
            FORMATTERS_BY_HINT.get((Object)parser.getHint()).add(parser);
        }
        for (DateTimeMultiParser parserAmbiguity : MULTIPARSER_PARSER_LIST) {
            for (DateTimeParser parser : parserAmbiguity.getAllParsers()) {
                if (!FORMATTERS_BY_HINT.containsKey((Object)parser.getHint())) {
                    FORMATTERS_BY_HINT.put(parser.getHint(), new ArrayList());
                }
                FORMATTERS_BY_HINT.get((Object)parser.getHint()).add(parser);
            }
        }
    }
}

