/*
 * Decompiled with CFR 0.152.
 */
package org.gbif.common.parsers.date;

import java.util.Date;
import javax.annotation.Nullable;
import org.gbif.common.parsers.date.AtomizedLocalDate;
import org.threeten.bp.DateTimeUtils;
import org.threeten.bp.Instant;
import org.threeten.bp.LocalDate;
import org.threeten.bp.LocalDateTime;
import org.threeten.bp.Year;
import org.threeten.bp.YearMonth;
import org.threeten.bp.ZoneId;
import org.threeten.bp.ZoneOffset;
import org.threeten.bp.ZonedDateTime;
import org.threeten.bp.temporal.ChronoField;
import org.threeten.bp.temporal.TemporalAccessor;
import org.threeten.bp.temporal.TemporalField;
import org.threeten.bp.temporal.TemporalQueries;

public class TemporalAccessorUtils {
    public static ZoneId UTC_ZONE_ID = ZoneOffset.UTC;

    public static Date toDate(TemporalAccessor temporalAccessor) {
        return TemporalAccessorUtils.toDate(temporalAccessor, false);
    }

    public static Date toDate(TemporalAccessor temporalAccessor, boolean ignoreOffset) {
        if (temporalAccessor == null) {
            return null;
        }
        if (!ignoreOffset && temporalAccessor.isSupported((TemporalField)ChronoField.OFFSET_SECONDS)) {
            return DateTimeUtils.toDate((Instant)((ZonedDateTime)temporalAccessor.query(ZonedDateTime.FROM)).toInstant());
        }
        if (temporalAccessor.isSupported((TemporalField)ChronoField.SECOND_OF_DAY)) {
            return DateTimeUtils.toDate((Instant)((LocalDateTime)temporalAccessor.query(LocalDateTime.FROM)).atZone(UTC_ZONE_ID).toInstant());
        }
        LocalDate localDate = (LocalDate)temporalAccessor.query(TemporalQueries.localDate());
        if (localDate == null && temporalAccessor.isSupported((TemporalField)ChronoField.MONTH_OF_YEAR)) {
            YearMonth yearMonth = YearMonth.from((TemporalAccessor)temporalAccessor);
            localDate = yearMonth.atDay(1);
        }
        if (localDate == null && temporalAccessor.isSupported((TemporalField)ChronoField.YEAR)) {
            Year year = Year.from((TemporalAccessor)temporalAccessor);
            localDate = year.atDay(1);
        }
        if (localDate != null) {
            return DateTimeUtils.toDate((Instant)localDate.atStartOfDay(UTC_ZONE_ID).toInstant());
        }
        return null;
    }

    public static TemporalAccessor getBestResolutionTemporalAccessor(@Nullable TemporalAccessor ta1, @Nullable TemporalAccessor ta2) {
        if (ta1 == null && ta2 == null) {
            return null;
        }
        if (ta1 == null) {
            return ta2;
        }
        if (ta2 == null) {
            return ta1;
        }
        AtomizedLocalDate ymd1 = AtomizedLocalDate.fromTemporalAccessor(ta1);
        AtomizedLocalDate ymd2 = AtomizedLocalDate.fromTemporalAccessor(ta2);
        if (ymd1.getYear() != null && ymd2.getYear() != null && !ymd1.getYear().equals(ymd2.getYear())) {
            return null;
        }
        if (ymd1.getMonth() != null && ymd2.getMonth() != null && !ymd1.getMonth().equals(ymd2.getMonth())) {
            return null;
        }
        if (ymd1.getDay() != null && ymd2.getDay() != null && !ymd1.getDay().equals(ymd2.getDay())) {
            return null;
        }
        if (ymd1.getResolution() > ymd2.getResolution()) {
            return ta1;
        }
        return ta2;
    }
}

