/*
 * Decompiled with CFR 0.152.
 */
package org.gbif.common.parsers.core;

import com.google.common.base.Charsets;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.regex.Pattern;
import org.apache.commons.lang3.StringUtils;
import org.gbif.common.parsers.core.DictionaryBackedParser;
import org.gbif.common.parsers.core.KeyValue;

public abstract class FileBasedDictionaryParser<T>
extends DictionaryBackedParser<T> {
    public FileBasedDictionaryParser(boolean caseSensitive) {
        super(caseSensitive);
    }

    protected void init(InputStream input) {
        this.init(input, null);
    }

    protected void init(InputStream input, String commentMarker) {
        this.init(new Source(input, commentMarker));
    }

    protected abstract T fromDictFile(String var1);

    class Source
    implements Iterator<KeyValue<String, T>> {
        private final BufferedReader r;
        private final Pattern tab = Pattern.compile("\t");
        private final String commentMarker;
        private String line = null;

        Source(InputStream file) {
            this(file, null);
        }

        Source(InputStream file, String commentMarker) {
            this.r = new BufferedReader(new InputStreamReader(file, Charsets.UTF_8));
            this.commentMarker = commentMarker;
        }

        @Override
        public boolean hasNext() {
            if (this.line != null) {
                return true;
            }
            try {
                do {
                    this.line = this.r.readLine();
                } while (this.line != null && !this.isValidLine(this.line));
            }
            catch (IOException ignored) {
                this.close();
                return false;
            }
            if (this.line == null) {
                this.close();
                return false;
            }
            return true;
        }

        private boolean isValidLine(String line) {
            if (line == null) {
                return false;
            }
            if (this.commentMarker != null && line.startsWith(this.commentMarker)) {
                return false;
            }
            return this.tab.split(line).length == 2;
        }

        @Override
        public KeyValue<String, T> next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            String[] atoms = this.tab.split(this.line);
            this.line = null;
            return new KeyValue(StringUtils.trimToNull((String)atoms[0]), FileBasedDictionaryParser.this.fromDictFile(StringUtils.trimToNull((String)atoms[1])));
        }

        @Override
        public void remove() {
        }

        public void close() {
            if (this.r != null) {
                try {
                    this.r.close();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
        }
    }
}

