/*
 * Decompiled with CFR 0.152.
 */
package org.gbif.common.parsers;

import com.google.common.base.Strings;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.text.ParsePosition;
import java.util.Locale;

public class NumberParser {
    private NumberParser() {
    }

    public static Double parseDouble(String x) {
        String trimmed;
        String string = trimmed = x == null ? null : x.trim();
        if (Strings.isNullOrEmpty((String)trimmed)) {
            return null;
        }
        try {
            return Double.parseDouble(x);
        }
        catch (NumberFormatException e) {
            NumberFormat format = DecimalFormat.getInstance(Locale.GERMANY);
            ParsePosition pos = new ParsePosition(0);
            Number num = format.parse(trimmed, pos);
            if (num != null && trimmed.length() == pos.getIndex()) {
                return num.doubleValue();
            }
            return null;
        }
    }

    public static Integer parseInteger(String x) {
        String trimmed;
        String string = trimmed = x == null ? null : x.trim();
        if (Strings.isNullOrEmpty((String)trimmed)) {
            return null;
        }
        try {
            return Integer.parseInt(x);
        }
        catch (NumberFormatException e) {
            NumberFormat format = DecimalFormat.getInstance(Locale.GERMANY);
            ParsePosition pos = new ParsePosition(0);
            Number num = format.parse(trimmed, pos);
            if (num != null && trimmed.length() == pos.getIndex()) {
                return num.intValue();
            }
            return null;
        }
    }
}

