/*
 * Decompiled with CFR 0.152.
 */
package org.gbif.registry.metadata.contact;

import com.google.common.base.Joiner;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import org.gbif.api.model.registry.Contact;
import org.gbif.api.vocabulary.ContactType;

public class ContactAdapter {
    private static final Joiner JOINER = Joiner.on((String)" ").skipNulls();
    private List<Contact> contactList;

    public ContactAdapter(List<Contact> contacts) {
        this.contactList = contacts;
    }

    public List<Contact> getAssociatedParties() {
        ArrayList contacts = Lists.newArrayList();
        for (Contact c : this.contactList) {
            if (c.isPrimary() || this.isPreferredContactType(c.getType())) continue;
            contacts.add(c);
        }
        return contacts;
    }

    private boolean isPreferredContactType(ContactType type) {
        return type != null && (type == ContactType.ORIGINATOR || type == ContactType.ADMINISTRATIVE_POINT_OF_CONTACT || type == ContactType.METADATA_AUTHOR);
    }

    public Contact getResourceCreator() {
        return this.getFirstPreferredType(ContactType.ORIGINATOR);
    }

    public static String formatContactName(Contact contact) {
        if (contact == null) {
            return "";
        }
        return JOINER.join((Object)contact.getFirstName(), (Object)contact.getLastName(), new Object[0]).trim();
    }

    public Contact getAdministrativeContact() {
        return this.getFirstPreferredType(ContactType.ADMINISTRATIVE_POINT_OF_CONTACT);
    }

    public List<Contact> getFilteredContacts(ContactType ... types) {
        ArrayList contacts = Lists.newArrayList();
        for (ContactType type : types) {
            Contact contact = this.getFirstPreferredType(type);
            if (contact == null) continue;
            contacts.add(contact);
        }
        return contacts;
    }

    public Contact getFirstPreferredType(ContactType type) {
        Contact pref = null;
        for (Contact c : this.contactList) {
            if (type != c.getType() || pref != null && !c.isPrimary()) continue;
            pref = c;
        }
        return pref;
    }

    public List<Contact> getCreators() {
        return this.getAllType(ContactType.ORIGINATOR);
    }

    public List<Contact> getContacts() {
        return this.getAllType(ContactType.ADMINISTRATIVE_POINT_OF_CONTACT);
    }

    public List<Contact> getMetadataProviders() {
        return this.getAllType(ContactType.METADATA_AUTHOR);
    }

    public List<Contact> getAllType(ContactType type) {
        ArrayList primary = Lists.newArrayList();
        for (Contact c : this.contactList) {
            if (type != c.getType()) continue;
            primary.add(c);
        }
        return primary;
    }
}

