/*
 * Decompiled with CFR 0.152.
 */
package org.gbif.registry.metadata;

import freemarker.cache.ClassTemplateLoader;
import freemarker.cache.TemplateLoader;
import freemarker.template.Configuration;
import freemarker.template.TemplateModelException;
import java.nio.charset.StandardCharsets;
import java.text.ChoiceFormat;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class DatasetXMLWriterConfigurationProvider {
    public static final String FM_UTILS_NAME = "fmUtil";
    private static final String TEMPLATE_PATH = "/";
    private static final Logger LOG = LoggerFactory.getLogger(DatasetXMLWriterConfigurationProvider.class);

    DatasetXMLWriterConfigurationProvider() {
    }

    public static Configuration provideFreemarker() {
        return DatasetXMLWriterConfigurationProvider.provideFreemarker(TEMPLATE_PATH);
    }

    public static Configuration provideFreemarker(String templatePath) {
        ClassTemplateLoader tl = new ClassTemplateLoader(DatasetXMLWriterConfigurationProvider.class, templatePath);
        Configuration fm = new Configuration();
        fm.setDefaultEncoding(StandardCharsets.UTF_8.toString());
        fm.setTemplateLoader((TemplateLoader)tl);
        try {
            fm.setSharedVariable(FM_UTILS_NAME, (Object)new FreemarkerUtils());
        }
        catch (TemplateModelException e) {
            LOG.error("Can't set sharedVariable in Freemarker Configuration", (Throwable)e);
        }
        return fm;
    }

    public static final class FreemarkerUtils {
        public String choiceFormat(String pattern, double number) {
            ChoiceFormat fmt = new ChoiceFormat(pattern);
            return fmt.format(number);
        }
    }
}

