/*
 * Decompiled with CFR 0.152.
 */
package au.org.ala.biocache.index.lucene;

import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;
import org.apache.lucene.analysis.TokenStream;
import org.apache.lucene.analysis.tokenattributes.BytesTermAttribute;
import org.apache.lucene.document.Field;
import org.apache.lucene.document.FieldType;
import org.apache.lucene.document.SortedDocValuesField;
import org.apache.lucene.document.SortedSetDocValuesField;
import org.apache.lucene.document.StoredField;
import org.apache.lucene.index.IndexableField;
import org.apache.lucene.spatial.prefix.CellToBytesRefIterator;
import org.apache.lucene.spatial.prefix.PrefixTreeStrategy;
import org.apache.lucene.spatial.prefix.tree.CellIterator;
import org.apache.lucene.spatial.prefix.tree.SpatialPrefixTree;
import org.apache.lucene.spatial.query.SpatialArgs;
import org.apache.lucene.util.BytesRef;
import org.apache.lucene.util.BytesRefIterator;
import org.apache.solr.schema.FieldType;
import org.apache.solr.schema.IndexSchema;
import org.apache.solr.schema.SchemaField;
import org.apache.solr.schema.SpatialRecursivePrefixTreeFieldType;
import org.apache.solr.schema.SpatialTermQueryPrefixTreeFieldType;
import org.apache.solr.schema.StrField;
import org.apache.solr.schema.TextField;
import org.apache.solr.schema.TrieDateField;
import org.apache.solr.schema.TrieField;
import org.apache.solr.util.DateMathParser;
import org.apache.solr.util.SpatialUtils;
import org.locationtech.spatial4j.context.SpatialContext;
import org.locationtech.spatial4j.io.WKTReader;
import org.locationtech.spatial4j.shape.Shape;

public class RecycleDoc
implements Iterable<IndexableField> {
    public static final Logger logger = Logger.getLogger(RecycleDoc.class);
    List<Boolean> fieldEnabled = new ArrayList<Boolean>();
    List<SchemaField> schemaFields = new ArrayList<SchemaField>();
    List<IndexableField> fields = new ArrayList<IndexableField>();
    Map<String, List<Integer>> fieldOrder = new HashMap<String, List<Integer>>();
    int size = 0;
    IndexSchema schema;

    public RecycleDoc(IndexSchema schema) {
        this.schema = schema;
    }

    public void add(SchemaField schemaField, IndexableField field) {
        List list = this.fieldOrder.computeIfAbsent(field.name(), k -> new ArrayList());
        list.add(this.fields.size());
        this.schemaFields.add(schemaField);
        this.fieldEnabled.add(true);
        this.fields.add(field);
        ++this.size;
    }

    public void reset() {
        for (int i = this.fieldEnabled.size() - 1; i >= 0; --i) {
            this.fieldEnabled.set(i, false);
        }
        this.size = 0;
    }

    public String[] get(String name) {
        List<Integer> idx = this.fieldOrder.get(name);
        if (idx != null) {
            int pos = 0;
            for (Integer i : idx) {
                if (!this.fieldEnabled.get(i).booleanValue()) continue;
                ++pos;
            }
            if (pos > 0) {
                String[] s = new String[pos];
                pos = 0;
                for (Integer i : idx) {
                    if (!this.fieldEnabled.get(i).booleanValue()) continue;
                    s[pos++] = this.fields.get(i).stringValue();
                }
                return s;
            }
        }
        return null;
    }

    public boolean setField(String name, Object value) {
        int count;
        boolean found = false;
        List<Integer> idx = this.fieldOrder.get(name);
        if (idx == null) {
            return false;
        }
        for (count = 0; count < idx.size() && this.fieldEnabled.get(idx.get(count)).booleanValue(); ++count) {
        }
        if (count < idx.size()) {
            int i = idx.get(count);
            SchemaField sf = this.schemaFields.get(i);
            FieldType ft = sf.getType();
            IndexableField f = this.fields.get(i);
            try {
                if (ft instanceof StrField) {
                    try {
                        if (this.isSortedDocValuesField(f)) {
                            this.setSortedDocValuesField(f, value);
                        } else {
                            ((Field)f).setStringValue(String.valueOf(value));
                        }
                        found = true;
                    }
                    catch (Exception e) {
                        logger.error((Object)("Problem setting field: " + f.name() + ", type: " + f.fieldType() + ", f: " + f.getClass().getCanonicalName() + ", error: " + e.getMessage()), (Throwable)e);
                    }
                } else if (ft instanceof TrieDateField) {
                    SimpleDateFormat dsf = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss'Z'");
                    Date theDate = dsf.parse((String)value);
                    ((Field)f).setLongValue(theDate.getTime());
                    found = true;
                } else if (ft instanceof TrieField) {
                    switch (((TrieField)ft).getNumericType().ordinal()) {
                        case 0: {
                            if (this.isSortedDocValuesField(f)) {
                                this.setSortedDocValuesField(f, value);
                            } else {
                                Integer valueAsInt = value instanceof Number ? ((Number)value).intValue() : Integer.parseInt((String)value);
                                ((Field)f).setIntValue(valueAsInt.intValue());
                            }
                            found = true;
                            break;
                        }
                        case 1: {
                            ((Field)f).setLongValue(value instanceof Number ? ((Number)value).longValue() : Long.parseLong((String)value));
                            found = true;
                            break;
                        }
                        case 2: {
                            ((Field)f).setFloatValue(value instanceof Number ? ((Number)value).floatValue() : Float.parseFloat((String)value));
                            found = true;
                            break;
                        }
                        case 3: {
                            ((Field)f).setDoubleValue(value instanceof Number ? ((Number)value).doubleValue() : Double.parseDouble((String)value));
                            found = true;
                            break;
                        }
                        case 4: {
                            ((Field)f).setLongValue(value instanceof Date ? ((Date)value).getTime() : DateMathParser.parseMath(null, (String)value.toString()).getTime());
                            found = true;
                            break;
                        }
                        default: {
                            FieldType.LegacyNumericType type = ((TrieField)ft).getNumericType();
                            throw new RuntimeException("TrieField not recognised or supported. Ordinal value: " + type.ordinal() + ", " + type.getClass().getName());
                        }
                    }
                } else if (ft instanceof TextField) {
                    ((Field)f).setStringValue((String)value);
                    found = true;
                } else if (ft instanceof SpatialTermQueryPrefixTreeFieldType || ft instanceof SpatialRecursivePrefixTreeFieldType) {
                    PrefixTreeStrategy strategy = ft instanceof SpatialTermQueryPrefixTreeFieldType ? (PrefixTreeStrategy)((SpatialTermQueryPrefixTreeFieldType)ft).getStrategy(name) : (PrefixTreeStrategy)((SpatialRecursivePrefixTreeFieldType)ft).getStrategy(name);
                    Double distErrPct = strategy.getDistErrPct();
                    SpatialPrefixTree grid = strategy.getGrid();
                    SpatialContext ctx = strategy.getSpatialContext();
                    String str = String.valueOf(value);
                    Object shape = value instanceof Shape ? (Shape)value : (str.length() > 0 && Character.isLetter(str.charAt(0)) ? ((WKTReader)ctx.getFormats().getWktReader()).parse(str) : SpatialUtils.parsePointSolrException((String)str, (SpatialContext)ctx));
                    if (shape != null) {
                        if (sf.indexed()) {
                            double distErr = SpatialArgs.calcDistanceFromErrPct((Shape)shape, (double)distErrPct, (SpatialContext)ctx);
                            int detailLevel = grid.getLevelForDistance(distErr);
                            CellIterator cells = grid.getTreeCellIterator(shape, detailLevel);
                            CellToBytesRefIterator cellToBytesRefIterator = new CellToBytesRefIterator();
                            cellToBytesRefIterator.reset((Iterator)cells);
                            SpatialTokenStream tokenStream = new SpatialTokenStream();
                            tokenStream.setBytesRefIterator((BytesRefIterator)cellToBytesRefIterator);
                            ((Field)f).setTokenStream((TokenStream)tokenStream);
                            this.fieldEnabled.set(idx.get(count), true);
                            ++count;
                        }
                        if (sf.stored()) {
                            if (count < idx.size()) {
                                i = idx.get(count);
                                sf = this.schemaFields.get(i);
                                ft = sf.getType();
                                f = this.fields.get(i);
                            }
                            ((StoredField)f).setStringValue(String.valueOf(str));
                        }
                        found = true;
                    }
                } else {
                    logger.error((Object)("MISSING FIELD " + name + " = " + value.toString() + ", " + ft.getClass().getName()));
                }
            }
            catch (NumberFormatException e) {
                logger.error((Object)("NumberFormatException setting field " + name + " = " + value.toString() + ", " + ft.getClass().getName() + " : " + e.getMessage()));
            }
            catch (Exception e) {
                logger.error((Object)("FIELD EXCEPTION " + name + " = " + value.toString() + ", " + ft.getClass().getName() + " : " + e.getMessage()), (Throwable)e);
            }
        }
        if (found) {
            this.fieldEnabled.set(idx.get(count), true);
        }
        return found;
    }

    public boolean isSortedDocValuesField(IndexableField f) {
        return f instanceof SortedSetDocValuesField || f instanceof SortedDocValuesField;
    }

    public void setSortedDocValuesField(IndexableField f, Object value) throws UnsupportedEncodingException {
        if (f instanceof SortedSetDocValuesField) {
            byte[] valueAsBytes = String.valueOf(value).getBytes("UTF-8");
            ((SortedSetDocValuesField)f).setBytesValue(valueAsBytes);
        } else if (f instanceof SortedDocValuesField) {
            byte[] valueAsBytes = String.valueOf(value).getBytes("UTF-8");
            ((SortedDocValuesField)f).setBytesValue(valueAsBytes);
        } else {
            throw new RuntimeException("Problem indexing field: " + f.name() + " : class not recognised: " + f.getClass().getName());
        }
    }

    @Override
    public Iterator<IndexableField> iterator() {
        int i;
        final int len = this.fieldEnabled.size();
        for (i = 0; i < len && !this.fieldEnabled.get(i).booleanValue(); ++i) {
        }
        final int start = i;
        return new Iterator<IndexableField>(){
            int pos;
            {
                this.pos = start;
            }

            @Override
            public boolean hasNext() {
                return this.pos < len;
            }

            @Override
            public IndexableField next() {
                IndexableField f = RecycleDoc.this.fields.get(this.pos);
                while (++this.pos < len && !RecycleDoc.this.fieldEnabled.get(this.pos).booleanValue()) {
                }
                return f;
            }

            @Override
            public void remove() {
            }
        };
    }

    static class SpatialTokenStream
    extends TokenStream {
        private final BytesTermAttribute bytesAtt = (BytesTermAttribute)this.addAttribute(BytesTermAttribute.class);
        private BytesRefIterator bytesIter = null;

        SpatialTokenStream() {
        }

        public BytesRefIterator getBytesRefIterator() {
            return this.bytesIter;
        }

        public SpatialTokenStream setBytesRefIterator(BytesRefIterator iter) {
            this.bytesIter = iter;
            return this;
        }

        public void reset() throws IOException {
            if (this.bytesIter == null) {
                throw new IllegalStateException("call setBytesRefIterator() before usage");
            }
        }

        public final boolean incrementToken() throws IOException {
            if (this.bytesIter == null) {
                throw new IllegalStateException("call setBytesRefIterator() before usage");
            }
            BytesRef bytes = this.bytesIter.next();
            if (bytes == null) {
                return false;
            }
            this.clearAttributes();
            this.bytesAtt.setBytesRef(bytes);
            return true;
        }
    }
}

