/*
 * Decompiled with CFR 0.152.
 */
package au.org.ala.biocache.export;

import au.com.bytecode.opencsv.CSVWriter;
import au.org.ala.biocache.Config$;
import au.org.ala.biocache.cmd.Tool;
import au.org.ala.biocache.cmd.Tool$class;
import au.org.ala.biocache.export.DwCACreator;
import au.org.ala.biocache.util.OptionParser;
import java.util.zip.DeflaterOutputStream;
import java.util.zip.ZipOutputStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.Option;
import scala.Predef$;
import scala.Serializable;
import scala.Tuple2;
import scala.collection.LinearSeqOptimized;
import scala.collection.MapLike;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.immutable.Map;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.StringBuilder;
import scala.io.Codec$;
import scala.io.Source$;
import scala.runtime.BoxedUnit;
import scala.runtime.ObjectRef;
import scala.util.matching.Regex;
import scala.util.parsing.json.JSON$;

public final class DwCACreator$
implements Tool {
    public static final DwCACreator$ MODULE$;
    private final Logger logger;
    private final List<String> defaultFields;
    private final Regex dataResourcePattern;

    static {
        new DwCACreator$();
    }

    @Override
    public String help() {
        return Tool$class.help(this);
    }

    @Override
    public String cmd() {
        return "create-dwc";
    }

    @Override
    public String desc() {
        return "Create Darwin Core Archive for a data resource";
    }

    public Logger logger() {
        return this.logger;
    }

    public List<String> defaultFields() {
        return this.defaultFields;
    }

    @Override
    public void main(String[] args) {
        ObjectRef resourceUid = new ObjectRef((Object)"");
        ObjectRef directory = new ObjectRef((Object)"");
        OptionParser parser = new OptionParser(resourceUid, directory){
            {
                this.arg("data-resource-uid", "The UID of the data resource to load or 'all' to generate for all", (Function1<String, BoxedUnit>)new Serializable(this, resourceUid$1){
                    public static final long serialVersionUID = 0L;
                    private final ObjectRef resourceUid$1;

                    public final void apply(String v) {
                        this.resourceUid$1.elem = v;
                    }
                    {
                        this.resourceUid$1 = resourceUid$1;
                    }
                });
                this.arg("directory-to-dump", "skip the download and use local file", (Function1<String, BoxedUnit>)new Serializable(this, directory$1){
                    public static final long serialVersionUID = 0L;
                    private final ObjectRef directory$1;

                    public final void apply(String v) {
                        this.directory$1.elem = v;
                    }
                    {
                        this.directory$1 = directory$1;
                    }
                });
            }
        };
        if (parser.parse((Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])args))) {
            DwCACreator dwcc = new DwCACreator();
            try {
                Map dataResource2OutputStreams = ((TraversableOnce)this.getDataResourceUids().map((Function1)new Serializable(directory, dwcc){
                    public static final long serialVersionUID = 0L;
                    private final ObjectRef directory$1;
                    private final DwCACreator dwcc$1;

                    public final Tuple2<String, Option<Tuple2<ZipOutputStream, CSVWriter>>> apply(String uid) {
                        return new Tuple2((Object)uid, this.dwcc$1.createOutputForCSV((String)this.directory$1.elem, uid));
                    }
                    {
                        this.directory$1 = directory$1;
                        this.dwcc$1 = dwcc$1;
                    }
                }, Seq$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.conforms());
                Config$.MODULE$.persistenceManager().pageOverSelect("occ", (Function2<String, Map<String, String>, Object>)new Serializable(dataResource2OutputStreams){
                    public static final long serialVersionUID = 0L;
                    private final Map dataResource2OutputStreams$1;

                    /*
                     * Unable to fully structure code
                     * Enabled aggressive block sorting
                     * Enabled unnecessary exception pruning
                     * Enabled aggressive exception aggregation
                     */
                    public final boolean apply(String key, Map<String, String> map) {
                        var3_3 = DwCACreator$.MODULE$;
                        synchronized (var3_3) {
                            block10: {
                                block9: {
                                    v0 = dr = (String)map.getOrElse((Object)"dataresourceuid", (Function0)new Serializable(this){
                                        public static final long serialVersionUID = 0L;

                                        public final String apply() {
                                            return "";
                                        }
                                    });
                                    var5_5 = "";
                                    if (v0 != null ? v0.equals(var5_5) == false : var5_5 != null) break block9;
                                    v1 = BoxedUnit.UNIT;
                                    break block10;
                                }
                                var7_6 = (Tuple2)((Option)this.dataResource2OutputStreams$1.get((Object)dr).get()).get();
                                if (var7_6 == null) {
                                    throw new MatchError((Object)var7_6);
                                }
                                zop = (ZipOutputStream)var7_6._1();
                                csv = (CSVWriter)var7_6._2();
                                var6_10 = var10_9 = new Tuple2((Object)zop, (Object)csv);
                                zop = (ZipOutputStream)var6_10._1();
                                csv = (CSVWriter)var6_10._2();
                                var13_13 = DwCACreator$.MODULE$;
                                synchronized (var13_13) {
                                    eventDate = (String)map.getOrElse((Object)"eventdate_p", (Function0)new Serializable(this){
                                        public static final long serialVersionUID = 0L;

                                        public final String apply() {
                                            return "";
                                        }
                                    });
                                    v2 = eventDateEnd = (String)map.getOrElse((Object)"eventdateend_p", (Function0)new Serializable(this){
                                        public static final long serialVersionUID = 0L;

                                        public final String apply() {
                                            return "";
                                        }
                                    });
                                    var18_16 = "";
                                    if (!(v2 == null ? var18_16 != null : v2.equals(var18_16) == false)) ** GOTO lbl-1000
                                    v3 = eventDate;
                                    var19_17 = "";
                                    if (!(v3 == null ? var19_17 != null : v3.equals(var19_17) == false)) ** GOTO lbl-1000
                                    v4 = eventDate;
                                    var20_18 = eventDateEnd;
                                    if (!(v4 != null ? v4.equals(var20_18) == false : var20_18 != null)) lbl-1000:
                                    // 3 sources

                                    {
                                        v5 = eventDate;
                                    } else {
                                        v5 = new StringBuilder().append((Object)eventDate).append((Object)"/").append((Object)eventDateEnd).toString();
                                    }
                                    eventDate = v5;
                                    csv.writeNext((String[])((Object[])new String[]{DwCACreator$.MODULE$.cleanValue((String)map.getOrElse((Object)"rowkey", (Function0)new Serializable(this){
                                        public static final long serialVersionUID = 0L;

                                        public final String apply() {
                                            return "";
                                        }
                                    })), DwCACreator$.MODULE$.cleanValue((String)map.getOrElse((Object)"catalognumber", (Function0)new Serializable(this){
                                        public static final long serialVersionUID = 0L;

                                        public final String apply() {
                                            return "";
                                        }
                                    })), DwCACreator$.MODULE$.cleanValue((String)map.getOrElse((Object)"collectioncode", (Function0)new Serializable(this){
                                        public static final long serialVersionUID = 0L;

                                        public final String apply() {
                                            return "";
                                        }
                                    })), DwCACreator$.MODULE$.cleanValue((String)map.getOrElse((Object)"institutioncode", (Function0)new Serializable(this){
                                        public static final long serialVersionUID = 0L;

                                        public final String apply() {
                                            return "";
                                        }
                                    })), DwCACreator$.MODULE$.cleanValue((String)map.getOrElse((Object)"recordnumber", (Function0)new Serializable(this){
                                        public static final long serialVersionUID = 0L;

                                        public final String apply() {
                                            return "";
                                        }
                                    })), DwCACreator$.MODULE$.cleanValue((String)map.getOrElse((Object)"basisofrecord_p", (Function0)new Serializable(this){
                                        public static final long serialVersionUID = 0L;

                                        public final String apply() {
                                            return "";
                                        }
                                    })), DwCACreator$.MODULE$.cleanValue((String)map.getOrElse((Object)"recordedby", (Function0)new Serializable(this){
                                        public static final long serialVersionUID = 0L;

                                        public final String apply() {
                                            return "";
                                        }
                                    })), DwCACreator$.MODULE$.cleanValue((String)map.getOrElse((Object)"occurrencestatus_p", (Function0)new Serializable(this){
                                        public static final long serialVersionUID = 0L;

                                        public final String apply() {
                                            return "";
                                        }
                                    })), DwCACreator$.MODULE$.cleanValue((String)map.getOrElse((Object)"individualcount", (Function0)new Serializable(this){
                                        public static final long serialVersionUID = 0L;

                                        public final String apply() {
                                            return "";
                                        }
                                    })), DwCACreator$.MODULE$.cleanValue((String)map.getOrElse((Object)"scientificname_p", (Function0)new Serializable(this){
                                        public static final long serialVersionUID = 0L;

                                        public final String apply() {
                                            return "";
                                        }
                                    })), DwCACreator$.MODULE$.cleanValue((String)map.getOrElse((Object)"taxonconceptid_p", (Function0)new Serializable(this){
                                        public static final long serialVersionUID = 0L;

                                        public final String apply() {
                                            return "";
                                        }
                                    })), DwCACreator$.MODULE$.cleanValue((String)map.getOrElse((Object)"taxonrank_p", (Function0)new Serializable(this){
                                        public static final long serialVersionUID = 0L;

                                        public final String apply() {
                                            return "";
                                        }
                                    })), DwCACreator$.MODULE$.cleanValue((String)map.getOrElse((Object)"kingdom_p", (Function0)new Serializable(this){
                                        public static final long serialVersionUID = 0L;

                                        public final String apply() {
                                            return "";
                                        }
                                    })), DwCACreator$.MODULE$.cleanValue((String)map.getOrElse((Object)"phylum_p", (Function0)new Serializable(this){
                                        public static final long serialVersionUID = 0L;

                                        public final String apply() {
                                            return "";
                                        }
                                    })), DwCACreator$.MODULE$.cleanValue((String)map.getOrElse((Object)"classs_p", (Function0)new Serializable(this){
                                        public static final long serialVersionUID = 0L;

                                        public final String apply() {
                                            return "";
                                        }
                                    })), DwCACreator$.MODULE$.cleanValue((String)map.getOrElse((Object)"order_p", (Function0)new Serializable(this){
                                        public static final long serialVersionUID = 0L;

                                        public final String apply() {
                                            return "";
                                        }
                                    })), DwCACreator$.MODULE$.cleanValue((String)map.getOrElse((Object)"family_p", (Function0)new Serializable(this){
                                        public static final long serialVersionUID = 0L;

                                        public final String apply() {
                                            return "";
                                        }
                                    })), DwCACreator$.MODULE$.cleanValue((String)map.getOrElse((Object)"genus_p", (Function0)new Serializable(this){
                                        public static final long serialVersionUID = 0L;

                                        public final String apply() {
                                            return "";
                                        }
                                    })), DwCACreator$.MODULE$.cleanValue((String)map.getOrElse((Object)"vernacularname_p", (Function0)new Serializable(this){
                                        public static final long serialVersionUID = 0L;

                                        public final String apply() {
                                            return "";
                                        }
                                    })), DwCACreator$.MODULE$.cleanValue((String)map.getOrElse((Object)"decimallatitude_p", (Function0)new Serializable(this){
                                        public static final long serialVersionUID = 0L;

                                        public final String apply() {
                                            return "";
                                        }
                                    })), DwCACreator$.MODULE$.cleanValue((String)map.getOrElse((Object)"decimallongitude_p", (Function0)new Serializable(this){
                                        public static final long serialVersionUID = 0L;

                                        public final String apply() {
                                            return "";
                                        }
                                    })), DwCACreator$.MODULE$.cleanValue((String)map.getOrElse((Object)"geodeticdatum_p", (Function0)new Serializable(this){
                                        public static final long serialVersionUID = 0L;

                                        public final String apply() {
                                            return "";
                                        }
                                    })), DwCACreator$.MODULE$.cleanValue((String)map.getOrElse((Object)"coordinateuncertaintyinmeters_p", (Function0)new Serializable(this){
                                        public static final long serialVersionUID = 0L;

                                        public final String apply() {
                                            return "";
                                        }
                                    })), DwCACreator$.MODULE$.cleanValue((String)map.getOrElse((Object)"maximumelevationinmeters", (Function0)new Serializable(this){
                                        public static final long serialVersionUID = 0L;

                                        public final String apply() {
                                            return "";
                                        }
                                    })), DwCACreator$.MODULE$.cleanValue((String)map.getOrElse((Object)"minimumelevationinmeters", (Function0)new Serializable(this){
                                        public static final long serialVersionUID = 0L;

                                        public final String apply() {
                                            return "";
                                        }
                                    })), DwCACreator$.MODULE$.cleanValue((String)map.getOrElse((Object)"minimumdepthinmeters", (Function0)new Serializable(this){
                                        public static final long serialVersionUID = 0L;

                                        public final String apply() {
                                            return "";
                                        }
                                    })), DwCACreator$.MODULE$.cleanValue((String)map.getOrElse((Object)"maximumdepthinmeters", (Function0)new Serializable(this){
                                        public static final long serialVersionUID = 0L;

                                        public final String apply() {
                                            return "";
                                        }
                                    })), DwCACreator$.MODULE$.cleanValue((String)map.getOrElse((Object)"country_p", (Function0)new Serializable(this){
                                        public static final long serialVersionUID = 0L;

                                        public final String apply() {
                                            return "";
                                        }
                                    })), DwCACreator$.MODULE$.cleanValue((String)map.getOrElse((Object)"stateprovince_p", (Function0)new Serializable(this){
                                        public static final long serialVersionUID = 0L;

                                        public final String apply() {
                                            return "";
                                        }
                                    })), DwCACreator$.MODULE$.cleanValue((String)map.getOrElse((Object)"locality", (Function0)new Serializable(this){
                                        public static final long serialVersionUID = 0L;

                                        public final String apply() {
                                            return "";
                                        }
                                    })), DwCACreator$.MODULE$.cleanValue((String)map.getOrElse((Object)"locationRemarks", (Function0)new Serializable(this){
                                        public static final long serialVersionUID = 0L;

                                        public final String apply() {
                                            return "";
                                        }
                                    })), DwCACreator$.MODULE$.cleanValue((String)map.getOrElse((Object)"year_p", (Function0)new Serializable(this){
                                        public static final long serialVersionUID = 0L;

                                        public final String apply() {
                                            return "";
                                        }
                                    })), DwCACreator$.MODULE$.cleanValue((String)map.getOrElse((Object)"month_p", (Function0)new Serializable(this){
                                        public static final long serialVersionUID = 0L;

                                        public final String apply() {
                                            return "";
                                        }
                                    })), DwCACreator$.MODULE$.cleanValue((String)map.getOrElse((Object)"day_p", (Function0)new Serializable(this){
                                        public static final long serialVersionUID = 0L;

                                        public final String apply() {
                                            return "";
                                        }
                                    })), DwCACreator$.MODULE$.cleanValue(eventDate), DwCACreator$.MODULE$.cleanValue((String)map.getOrElse((Object)"eventid", (Function0)new Serializable(this){
                                        public static final long serialVersionUID = 0L;

                                        public final String apply() {
                                            return "";
                                        }
                                    })), DwCACreator$.MODULE$.cleanValue((String)map.getOrElse((Object)"identifiedby", (Function0)new Serializable(this){
                                        public static final long serialVersionUID = 0L;

                                        public final String apply() {
                                            return "";
                                        }
                                    })), DwCACreator$.MODULE$.cleanValue((String)map.getOrElse((Object)"occurrenceremarks", (Function0)new Serializable(this){
                                        public static final long serialVersionUID = 0L;

                                        public final String apply() {
                                            return "";
                                        }
                                    })), DwCACreator$.MODULE$.cleanValue((String)map.getOrElse((Object)"datageneralizations_p", (Function0)new Serializable(this){
                                        public static final long serialVersionUID = 0L;

                                        public final String apply() {
                                            return "";
                                        }
                                    }))}));
                                    csv.flush();
                                    var14_20 = BoxedUnit.UNIT;
                                    // MONITOREXIT @DISABLED, blocks:[0, 1, 2, 3] lbl37 : MonitorExitStatement: MONITOREXIT : var13_13
                                    v1 = var14_20;
                                }
                            }
                            return true;
                        }
                    }
                    {
                        this.dataResource2OutputStreams$1 = dataResource2OutputStreams$1;
                    }
                }, 4, 1000, (Seq<String>)this.defaultFields());
                dataResource2OutputStreams.values().foreach((Function1)new Serializable(){
                    public static final long serialVersionUID = 0L;

                    public final void apply(Option<Tuple2<ZipOutputStream, CSVWriter>> zopAndCsv) {
                        ((DeflaterOutputStream)((Tuple2)zopAndCsv.get())._1()).flush();
                        ((ZipOutputStream)((Tuple2)zopAndCsv.get())._1()).closeEntry();
                        ((ZipOutputStream)((Tuple2)zopAndCsv.get())._1()).close();
                    }
                });
            }
            catch (Exception exception) {
                this.logger().error(exception.getMessage(), (Throwable)exception);
            }
        }
    }

    public String cleanValue(String input) {
        return input == null ? "" : input.replaceAll("[\\t\\n\\r]", " ").trim();
    }

    public Regex dataResourcePattern() {
        return this.dataResourcePattern;
    }

    public Seq<String> getDataResourceUids() {
        String url = new StringBuilder().append((Object)Config$.MODULE$.biocacheServiceUrl()).append((Object)"/occurrences/search?q=*:*&facets=data_resource_uid&pageSize=0&flimit=10000").toString();
        String jsonString = Source$.MODULE$.fromURL(url, Codec$.MODULE$.fallbackSystemCodec()).getLines().mkString();
        Map json = (Map)JSON$.MODULE$.parseFull(jsonString).get();
        List results = (List)((MapLike)((List)json.get((Object)"facetResults").get()).head()).get((Object)"fieldResult").get();
        return (Seq)((TraversableLike)results.map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final String apply(Map<String, String> facet) {
                String fq = (String)facet.get((Object)"fq").get();
                return DwCACreator$.MODULE$.parseFq(fq);
            }
        }, List$.MODULE$.canBuildFrom())).filterNot((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final boolean apply(String x$2) {
                return x$2.equals("Unknown");
            }
        });
    }

    public String parseFq(String fq) {
        String dr;
        String string = fq;
        Option option = this.dataResourcePattern().unapplySeq((Object)string);
        String string2 = !option.isEmpty() && option.get() != null && ((LinearSeqOptimized)option.get()).lengthCompare(1) == 0 ? (dr = (String)((LinearSeqOptimized)option.get()).apply(0)) : "Unknown";
        return string2;
    }

    private DwCACreator$() {
        MODULE$ = this;
        Tool$class.$init$(this);
        this.logger = LoggerFactory.getLogger((String)"DwCACreator");
        this.defaultFields = List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"rowkey", "dataresourceuid", "catalognumber", "collectioncode", "institutioncode", "scientificname_p", "recordedby", "taxonconceptid_p", "taxonrank_p", "kingdom_p", "phylum_p", "classs_p", "order_p", "family_p", "genus_p", "decimallatitude_p", "decimallongitude_p", "coordinateuncertaintyinmeters_p", "maximumelevationinmeters", "minimumelevationinmeters", "minimumdepthinmeters", "maximumdepthinmeters", "geodeticdatum_p", "country_p", "stateprovince_p", "locality", "occurrencestatus_p", "year_p", "month_p", "day_p", "eventdate_p", "eventdateend_p", "basisofrecord_p", "identifiedby", "occurrenceremarks", "locationremarks", "recordnumber", "vernacularname_p", "individualcount", "eventid", "datageneralizations_p"}));
        this.dataResourcePattern = new StringOps(Predef$.MODULE$.augmentString("(?:[\"]*)?(?:[a-z_]*_uid:\")([a-z0-9]*)(?:[\"]*)?")).r();
    }
}

