/*
 * Decompiled with CFR 0.152.
 */
package org.gbif.common.parsers.core;

import com.google.common.base.Strings;
import com.google.common.collect.Sets;
import java.io.InputStream;
import java.util.HashSet;
import java.util.regex.Pattern;
import org.gbif.api.util.VocabularyUtils;
import org.gbif.common.parsers.core.ASCIIParser;
import org.gbif.common.parsers.core.FileBasedDictionaryParser;
import org.gbif.common.parsers.core.ParseResult;

public class EnumParser<T extends Enum<T>>
extends FileBasedDictionaryParser<T> {
    private final Class<T> clazz;
    private final Pattern NORMALIZER;
    private final ASCIIParser ascii = ASCIIParser.getInstance();
    private final HashSet<String> notAvailable = Sets.newHashSet((Object[])new String[]{"N/A", "N/a", "n/a", "n/A", "n.a.", "N/K", "N/k", "n/k", "n/K", "n.k.", "UNK.", "Unk.", "unk.", "UNK", "Unk", "unk"});

    protected EnumParser(Class<T> clazz, boolean allowDigits, InputStream ... inputs) {
        super(false);
        this.NORMALIZER = allowDigits ? Pattern.compile("\\W+") : Pattern.compile("[^a-zA-Z]+");
        this.clazz = clazz;
        this.addEnumValues();
        if (inputs != null) {
            for (InputStream input : inputs) {
                this.init(input);
            }
        }
    }

    private void addEnumValues() {
        Enum[] values = (Enum[])this.clazz.getEnumConstants();
        if (values != null) {
            for (Enum val : values) {
                this.add(val.name(), val);
            }
        }
    }

    @Override
    protected String normalize(String value) {
        if (Strings.isNullOrEmpty((String)this.handleNotAvailable(value))) {
            return null;
        }
        ParseResult<String> asci = this.ascii.parse(value);
        return this.NORMALIZER.matcher(asci.getPayload()).replaceAll("").toUpperCase();
    }

    protected String handleNotAvailable(String value) {
        return this.notAvailable.contains(value) ? null : value;
    }

    @Override
    protected T fromDictFile(String value) {
        try {
            return (T)VocabularyUtils.lookupEnum((String)value, this.clazz);
        }
        catch (RuntimeException e) {
            return null;
        }
    }
}

