/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.index;

import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import org.apache.lucene.index.BinaryDocValues;
import org.apache.lucene.index.CompositeReader;
import org.apache.lucene.index.DocValues;
import org.apache.lucene.index.DocValuesType;
import org.apache.lucene.index.FieldInfo;
import org.apache.lucene.index.FieldInfos;
import org.apache.lucene.index.Fields;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.LeafReader;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.index.MultiDocValues;
import org.apache.lucene.index.MultiFields;
import org.apache.lucene.index.NumericDocValues;
import org.apache.lucene.index.PointValues;
import org.apache.lucene.index.SortedDocValues;
import org.apache.lucene.index.SortedNumericDocValues;
import org.apache.lucene.index.SortedSetDocValues;
import org.apache.lucene.index.StoredFieldVisitor;
import org.apache.lucene.search.Sort;
import org.apache.lucene.util.Bits;

@Deprecated
public final class SlowCompositeReaderWrapper
extends LeafReader {
    private final CompositeReader in;
    private final Fields fields;
    private final boolean merging;
    private final Map<String, MultiDocValues.OrdinalMap> cachedOrdMaps = new HashMap<String, MultiDocValues.OrdinalMap>();

    public static LeafReader wrap(IndexReader reader) throws IOException {
        if (reader instanceof CompositeReader) {
            return new SlowCompositeReaderWrapper((CompositeReader)reader, false);
        }
        assert (reader instanceof LeafReader);
        return (LeafReader)reader;
    }

    SlowCompositeReaderWrapper(CompositeReader reader, boolean merging) throws IOException {
        this.in = reader;
        if (this.getFieldInfos().hasPointValues()) {
            throw new IllegalArgumentException("cannot wrap points");
        }
        this.fields = MultiFields.getFields((IndexReader)this.in);
        this.in.registerParentReader((IndexReader)this);
        this.merging = merging;
    }

    public String toString() {
        return "SlowCompositeReaderWrapper(" + this.in + ")";
    }

    public void addCoreClosedListener(LeafReader.CoreClosedListener listener) {
        SlowCompositeReaderWrapper.addCoreClosedListenerAsReaderClosedListener((IndexReader)this.in, (LeafReader.CoreClosedListener)listener);
    }

    public void removeCoreClosedListener(LeafReader.CoreClosedListener listener) {
        SlowCompositeReaderWrapper.removeCoreClosedListenerAsReaderClosedListener((IndexReader)this.in, (LeafReader.CoreClosedListener)listener);
    }

    public Fields fields() {
        this.ensureOpen();
        return this.fields;
    }

    public NumericDocValues getNumericDocValues(String field) throws IOException {
        this.ensureOpen();
        return MultiDocValues.getNumericValues((IndexReader)this.in, (String)field);
    }

    public Bits getDocsWithField(String field) throws IOException {
        this.ensureOpen();
        return MultiDocValues.getDocsWithField((IndexReader)this.in, (String)field);
    }

    public BinaryDocValues getBinaryDocValues(String field) throws IOException {
        this.ensureOpen();
        return MultiDocValues.getBinaryValues((IndexReader)this.in, (String)field);
    }

    public SortedNumericDocValues getSortedNumericDocValues(String field) throws IOException {
        this.ensureOpen();
        return MultiDocValues.getSortedNumericValues((IndexReader)this.in, (String)field);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SortedDocValues getSortedDocValues(String field) throws IOException {
        this.ensureOpen();
        MultiDocValues.OrdinalMap map = null;
        Map<String, MultiDocValues.OrdinalMap> map2 = this.cachedOrdMaps;
        synchronized (map2) {
            map = this.cachedOrdMaps.get(field);
            if (map == null) {
                SortedDocValues dv = MultiDocValues.getSortedValues((IndexReader)this.in, (String)field);
                if (dv instanceof MultiDocValues.MultiSortedDocValues) {
                    map = ((MultiDocValues.MultiSortedDocValues)dv).mapping;
                    if (map.owner == this.getCoreCacheKey() && !this.merging) {
                        this.cachedOrdMaps.put(field, map);
                    }
                }
                return dv;
            }
        }
        int size = this.in.leaves().size();
        SortedDocValues[] values = new SortedDocValues[size];
        int[] starts = new int[size + 1];
        for (int i = 0; i < size; ++i) {
            LeafReaderContext context = (LeafReaderContext)this.in.leaves().get(i);
            LeafReader reader = context.reader();
            FieldInfo fieldInfo = reader.getFieldInfos().fieldInfo(field);
            if (fieldInfo != null && fieldInfo.getDocValuesType() != DocValuesType.SORTED) {
                return null;
            }
            SortedDocValues v = reader.getSortedDocValues(field);
            if (v == null) {
                v = DocValues.emptySorted();
            }
            values[i] = v;
            starts[i] = context.docBase;
        }
        starts[size] = this.maxDoc();
        return new MultiDocValues.MultiSortedDocValues(values, starts, map);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SortedSetDocValues getSortedSetDocValues(String field) throws IOException {
        this.ensureOpen();
        MultiDocValues.OrdinalMap map = null;
        Map<String, MultiDocValues.OrdinalMap> map2 = this.cachedOrdMaps;
        synchronized (map2) {
            map = this.cachedOrdMaps.get(field);
            if (map == null) {
                SortedSetDocValues dv = MultiDocValues.getSortedSetValues((IndexReader)this.in, (String)field);
                if (dv instanceof MultiDocValues.MultiSortedSetDocValues) {
                    map = ((MultiDocValues.MultiSortedSetDocValues)dv).mapping;
                    if (map.owner == this.getCoreCacheKey() && !this.merging) {
                        this.cachedOrdMaps.put(field, map);
                    }
                }
                return dv;
            }
        }
        assert (map != null);
        int size = this.in.leaves().size();
        SortedSetDocValues[] values = new SortedSetDocValues[size];
        int[] starts = new int[size + 1];
        for (int i = 0; i < size; ++i) {
            LeafReaderContext context = (LeafReaderContext)this.in.leaves().get(i);
            LeafReader reader = context.reader();
            FieldInfo fieldInfo = reader.getFieldInfos().fieldInfo(field);
            if (fieldInfo != null && fieldInfo.getDocValuesType() != DocValuesType.SORTED_SET) {
                return null;
            }
            SortedSetDocValues v = reader.getSortedSetDocValues(field);
            if (v == null) {
                v = DocValues.emptySortedSet();
            }
            values[i] = v;
            starts[i] = context.docBase;
        }
        starts[size] = this.maxDoc();
        return new MultiDocValues.MultiSortedSetDocValues(values, starts, map);
    }

    public NumericDocValues getNormValues(String field) throws IOException {
        this.ensureOpen();
        return MultiDocValues.getNormValues((IndexReader)this.in, (String)field);
    }

    public Fields getTermVectors(int docID) throws IOException {
        this.ensureOpen();
        return this.in.getTermVectors(docID);
    }

    public int numDocs() {
        return this.in.numDocs();
    }

    public int maxDoc() {
        return this.in.maxDoc();
    }

    public void document(int docID, StoredFieldVisitor visitor) throws IOException {
        this.ensureOpen();
        this.in.document(docID, visitor);
    }

    public Bits getLiveDocs() {
        this.ensureOpen();
        return MultiFields.getLiveDocs((IndexReader)this.in);
    }

    public PointValues getPointValues() {
        this.ensureOpen();
        return null;
    }

    public FieldInfos getFieldInfos() {
        this.ensureOpen();
        return MultiFields.getMergedFieldInfos((IndexReader)this.in);
    }

    public Object getCoreCacheKey() {
        return this.in.getCoreCacheKey();
    }

    public Object getCombinedCoreAndDeletesKey() {
        return this.in.getCombinedCoreAndDeletesKey();
    }

    protected void doClose() throws IOException {
        this.in.close();
    }

    public void checkIntegrity() throws IOException {
        this.ensureOpen();
        for (LeafReaderContext ctx : this.in.leaves()) {
            ctx.reader().checkIntegrity();
        }
    }

    public Sort getIndexSort() {
        return null;
    }
}

