/*
 * Decompiled with CFR 0.152.
 */
package org.scale7.cassandra.pelops;

import java.util.List;
import org.apache.cassandra.thrift.Cassandra;
import org.apache.cassandra.thrift.KsDef;
import org.apache.cassandra.thrift.TokenRange;
import org.scale7.cassandra.pelops.Cluster;
import org.scale7.cassandra.pelops.ManagerOperand;
import org.scale7.portability.SystemProxy;
import org.slf4j.Logger;

public class KeyspaceManager
extends ManagerOperand {
    private static final Logger logger = SystemProxy.getLoggerFromFactory(KeyspaceManager.class);
    public static final String KSDEF_STRATEGY_SIMPLE = "org.apache.cassandra.locator.SimpleStrategy";
    public static final String KSDEF_STRATEGY_LOCAL = "org.apache.cassandra.locator.LocalStrategy";
    public static final String KSDEF_STRATEGY_NETWORK_TOPOLOGY = "org.apache.cassandra.locator.NetworkTopologyStrategy";
    public static final String KSDEF_STRATEGY_NETWORK_TOPOLOGY_OLD = "org.apache.cassandra.locator.OldNetworkTopologyStrategy";

    public KeyspaceManager(Cluster cluster) {
        super(cluster);
    }

    public KeyspaceManager(Cluster cluster, int safeNodeChangeDelay) {
        super(cluster, safeNodeChangeDelay);
    }

    public List<KsDef> getKeyspaceNames() throws Exception {
        ManagerOperand.IManagerOperation<List<KsDef>> operation = new ManagerOperand.IManagerOperation<List<KsDef>>(){

            @Override
            public List<KsDef> execute(Cassandra.Client conn) throws Exception {
                return conn.describe_keyspaces();
            }
        };
        return this.tryOperation(operation);
    }

    public List<TokenRange> getKeyspaceRingMappings(final String keyspace) throws Exception {
        ManagerOperand.IManagerOperation<List<TokenRange>> operation = new ManagerOperand.IManagerOperation<List<TokenRange>>(){

            @Override
            public List<TokenRange> execute(Cassandra.Client conn) throws Exception {
                return conn.describe_ring(keyspace);
            }
        };
        return this.tryOperation(operation);
    }

    public KsDef getKeyspaceSchema(final String keyspace) throws Exception {
        ManagerOperand.IManagerOperation<KsDef> operation = new ManagerOperand.IManagerOperation<KsDef>(){

            @Override
            public KsDef execute(Cassandra.Client conn) throws Exception {
                return conn.describe_keyspace(keyspace);
            }
        };
        return this.tryOperation(operation);
    }

    public String addKeyspace(final KsDef keyspaceDefinition) throws Exception {
        if (logger.isInfoEnabled()) {
            logger.info("Adding keyspace '{}'", (Object)keyspaceDefinition.getName());
        }
        ManagerOperand.IManagerOperation<String> operation = new ManagerOperand.IManagerOperation<String>(){

            @Override
            public String execute(Cassandra.Client conn) throws Exception {
                return conn.system_add_keyspace(keyspaceDefinition);
            }
        };
        String schemaVersion = this.tryOperation(operation);
        if (logger.isInfoEnabled()) {
            logger.info("Added keyspace '{}', schema version is now '{}'", new Object[]{keyspaceDefinition.getName(), schemaVersion});
        }
        return schemaVersion;
    }

    public String dropKeyspace(final String keyspace) throws Exception {
        if (logger.isInfoEnabled()) {
            logger.info("Dropping keyspace '{}'", (Object)keyspace);
        }
        ManagerOperand.IManagerOperation<String> operation = new ManagerOperand.IManagerOperation<String>(){

            @Override
            public String execute(Cassandra.Client conn) throws Exception {
                return conn.system_drop_keyspace(keyspace);
            }
        };
        String schemaVersion = this.tryOperation(operation);
        if (logger.isInfoEnabled()) {
            logger.info("Dropped keyspace '{}', schema version is now '{}'", (Object)keyspace, (Object)schemaVersion);
        }
        return schemaVersion;
    }
}

